/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Optional;


public class UpsertSchedule {
    /**
     * Simple description of what the schedule is.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("description")
    private Optional<String> description;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("occurrences")
    private Optional<? extends List<Occurrence>> occurrences;

    /**
     * Defines configuration for recurring transfers.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("recur")
    private Optional<? extends Recur> recur;

    @JsonCreator
    public UpsertSchedule(
            @JsonProperty("description") Optional<String> description,
            @JsonProperty("occurrences") Optional<? extends List<Occurrence>> occurrences,
            @JsonProperty("recur") Optional<? extends Recur> recur) {
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(occurrences, "occurrences");
        Utils.checkNotNull(recur, "recur");
        this.description = description;
        this.occurrences = occurrences;
        this.recur = recur;
    }
    
    public UpsertSchedule() {
        this(Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * Simple description of what the schedule is.
     */
    @JsonIgnore
    public Optional<String> description() {
        return description;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<Occurrence>> occurrences() {
        return (Optional<List<Occurrence>>) occurrences;
    }

    /**
     * Defines configuration for recurring transfers.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Recur> recur() {
        return (Optional<Recur>) recur;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Simple description of what the schedule is.
     */
    public UpsertSchedule withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = Optional.ofNullable(description);
        return this;
    }


    /**
     * Simple description of what the schedule is.
     */
    public UpsertSchedule withDescription(Optional<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    public UpsertSchedule withOccurrences(List<Occurrence> occurrences) {
        Utils.checkNotNull(occurrences, "occurrences");
        this.occurrences = Optional.ofNullable(occurrences);
        return this;
    }


    public UpsertSchedule withOccurrences(Optional<? extends List<Occurrence>> occurrences) {
        Utils.checkNotNull(occurrences, "occurrences");
        this.occurrences = occurrences;
        return this;
    }

    /**
     * Defines configuration for recurring transfers.
     */
    public UpsertSchedule withRecur(Recur recur) {
        Utils.checkNotNull(recur, "recur");
        this.recur = Optional.ofNullable(recur);
        return this;
    }


    /**
     * Defines configuration for recurring transfers.
     */
    public UpsertSchedule withRecur(Optional<? extends Recur> recur) {
        Utils.checkNotNull(recur, "recur");
        this.recur = recur;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpsertSchedule other = (UpsertSchedule) o;
        return 
            Utils.enhancedDeepEquals(this.description, other.description) &&
            Utils.enhancedDeepEquals(this.occurrences, other.occurrences) &&
            Utils.enhancedDeepEquals(this.recur, other.recur);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            description, occurrences, recur);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UpsertSchedule.class,
                "description", description,
                "occurrences", occurrences,
                "recur", recur);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> description = Optional.empty();

        private Optional<? extends List<Occurrence>> occurrences = Optional.empty();

        private Optional<? extends Recur> recur = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Simple description of what the schedule is.
         */
        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = Optional.ofNullable(description);
            return this;
        }

        /**
         * Simple description of what the schedule is.
         */
        public Builder description(Optional<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }


        public Builder occurrences(List<Occurrence> occurrences) {
            Utils.checkNotNull(occurrences, "occurrences");
            this.occurrences = Optional.ofNullable(occurrences);
            return this;
        }

        public Builder occurrences(Optional<? extends List<Occurrence>> occurrences) {
            Utils.checkNotNull(occurrences, "occurrences");
            this.occurrences = occurrences;
            return this;
        }


        /**
         * Defines configuration for recurring transfers.
         */
        public Builder recur(Recur recur) {
            Utils.checkNotNull(recur, "recur");
            this.recur = Optional.ofNullable(recur);
            return this;
        }

        /**
         * Defines configuration for recurring transfers.
         */
        public Builder recur(Optional<? extends Recur> recur) {
            Utils.checkNotNull(recur, "recur");
            this.recur = recur;
            return this;
        }

        public UpsertSchedule build() {

            return new UpsertSchedule(
                description, occurrences, recur);
        }

    }
}
