/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;


public class UpdatePaymentLink {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("amount")
    private Optional<? extends AmountUpdate> amount;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("expiresOn")
    private JsonNullable<OffsetDateTime> expiresOn;

    /**
     * Customizable display options for a payment link.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("display")
    private Optional<? extends PaymentLinkDisplayOptionsUpdate> display;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("customer")
    private Optional<? extends PaymentLinkCustomerOptions> customer;

    /**
     * Options for payment links used to collect payment.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("payment")
    private Optional<? extends PaymentLinkPaymentDetailsUpdate> payment;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("payout")
    private Optional<? extends PaymentLinkPayoutDetailsUpdate> payout;

    @JsonCreator
    public UpdatePaymentLink(
            @JsonProperty("amount") Optional<? extends AmountUpdate> amount,
            @JsonProperty("expiresOn") JsonNullable<OffsetDateTime> expiresOn,
            @JsonProperty("display") Optional<? extends PaymentLinkDisplayOptionsUpdate> display,
            @JsonProperty("customer") Optional<? extends PaymentLinkCustomerOptions> customer,
            @JsonProperty("payment") Optional<? extends PaymentLinkPaymentDetailsUpdate> payment,
            @JsonProperty("payout") Optional<? extends PaymentLinkPayoutDetailsUpdate> payout) {
        Utils.checkNotNull(amount, "amount");
        Utils.checkNotNull(expiresOn, "expiresOn");
        Utils.checkNotNull(display, "display");
        Utils.checkNotNull(customer, "customer");
        Utils.checkNotNull(payment, "payment");
        Utils.checkNotNull(payout, "payout");
        this.amount = amount;
        this.expiresOn = expiresOn;
        this.display = display;
        this.customer = customer;
        this.payment = payment;
        this.payout = payout;
    }
    
    public UpdatePaymentLink() {
        this(Optional.empty(), JsonNullable.undefined(), Optional.empty(),
            Optional.empty(), Optional.empty(), Optional.empty());
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<AmountUpdate> amount() {
        return (Optional<AmountUpdate>) amount;
    }

    @JsonIgnore
    public JsonNullable<OffsetDateTime> expiresOn() {
        return expiresOn;
    }

    /**
     * Customizable display options for a payment link.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<PaymentLinkDisplayOptionsUpdate> display() {
        return (Optional<PaymentLinkDisplayOptionsUpdate>) display;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<PaymentLinkCustomerOptions> customer() {
        return (Optional<PaymentLinkCustomerOptions>) customer;
    }

    /**
     * Options for payment links used to collect payment.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<PaymentLinkPaymentDetailsUpdate> payment() {
        return (Optional<PaymentLinkPaymentDetailsUpdate>) payment;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<PaymentLinkPayoutDetailsUpdate> payout() {
        return (Optional<PaymentLinkPayoutDetailsUpdate>) payout;
    }

    public static Builder builder() {
        return new Builder();
    }


    public UpdatePaymentLink withAmount(AmountUpdate amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = Optional.ofNullable(amount);
        return this;
    }


    public UpdatePaymentLink withAmount(Optional<? extends AmountUpdate> amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    public UpdatePaymentLink withExpiresOn(OffsetDateTime expiresOn) {
        Utils.checkNotNull(expiresOn, "expiresOn");
        this.expiresOn = JsonNullable.of(expiresOn);
        return this;
    }

    public UpdatePaymentLink withExpiresOn(JsonNullable<OffsetDateTime> expiresOn) {
        Utils.checkNotNull(expiresOn, "expiresOn");
        this.expiresOn = expiresOn;
        return this;
    }

    /**
     * Customizable display options for a payment link.
     */
    public UpdatePaymentLink withDisplay(PaymentLinkDisplayOptionsUpdate display) {
        Utils.checkNotNull(display, "display");
        this.display = Optional.ofNullable(display);
        return this;
    }


    /**
     * Customizable display options for a payment link.
     */
    public UpdatePaymentLink withDisplay(Optional<? extends PaymentLinkDisplayOptionsUpdate> display) {
        Utils.checkNotNull(display, "display");
        this.display = display;
        return this;
    }

    public UpdatePaymentLink withCustomer(PaymentLinkCustomerOptions customer) {
        Utils.checkNotNull(customer, "customer");
        this.customer = Optional.ofNullable(customer);
        return this;
    }


    public UpdatePaymentLink withCustomer(Optional<? extends PaymentLinkCustomerOptions> customer) {
        Utils.checkNotNull(customer, "customer");
        this.customer = customer;
        return this;
    }

    /**
     * Options for payment links used to collect payment.
     */
    public UpdatePaymentLink withPayment(PaymentLinkPaymentDetailsUpdate payment) {
        Utils.checkNotNull(payment, "payment");
        this.payment = Optional.ofNullable(payment);
        return this;
    }


    /**
     * Options for payment links used to collect payment.
     */
    public UpdatePaymentLink withPayment(Optional<? extends PaymentLinkPaymentDetailsUpdate> payment) {
        Utils.checkNotNull(payment, "payment");
        this.payment = payment;
        return this;
    }

    public UpdatePaymentLink withPayout(PaymentLinkPayoutDetailsUpdate payout) {
        Utils.checkNotNull(payout, "payout");
        this.payout = Optional.ofNullable(payout);
        return this;
    }


    public UpdatePaymentLink withPayout(Optional<? extends PaymentLinkPayoutDetailsUpdate> payout) {
        Utils.checkNotNull(payout, "payout");
        this.payout = payout;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdatePaymentLink other = (UpdatePaymentLink) o;
        return 
            Utils.enhancedDeepEquals(this.amount, other.amount) &&
            Utils.enhancedDeepEquals(this.expiresOn, other.expiresOn) &&
            Utils.enhancedDeepEquals(this.display, other.display) &&
            Utils.enhancedDeepEquals(this.customer, other.customer) &&
            Utils.enhancedDeepEquals(this.payment, other.payment) &&
            Utils.enhancedDeepEquals(this.payout, other.payout);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            amount, expiresOn, display,
            customer, payment, payout);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UpdatePaymentLink.class,
                "amount", amount,
                "expiresOn", expiresOn,
                "display", display,
                "customer", customer,
                "payment", payment,
                "payout", payout);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<? extends AmountUpdate> amount = Optional.empty();

        private JsonNullable<OffsetDateTime> expiresOn = JsonNullable.undefined();

        private Optional<? extends PaymentLinkDisplayOptionsUpdate> display = Optional.empty();

        private Optional<? extends PaymentLinkCustomerOptions> customer = Optional.empty();

        private Optional<? extends PaymentLinkPaymentDetailsUpdate> payment = Optional.empty();

        private Optional<? extends PaymentLinkPayoutDetailsUpdate> payout = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder amount(AmountUpdate amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = Optional.ofNullable(amount);
            return this;
        }

        public Builder amount(Optional<? extends AmountUpdate> amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }


        public Builder expiresOn(OffsetDateTime expiresOn) {
            Utils.checkNotNull(expiresOn, "expiresOn");
            this.expiresOn = JsonNullable.of(expiresOn);
            return this;
        }

        public Builder expiresOn(JsonNullable<OffsetDateTime> expiresOn) {
            Utils.checkNotNull(expiresOn, "expiresOn");
            this.expiresOn = expiresOn;
            return this;
        }


        /**
         * Customizable display options for a payment link.
         */
        public Builder display(PaymentLinkDisplayOptionsUpdate display) {
            Utils.checkNotNull(display, "display");
            this.display = Optional.ofNullable(display);
            return this;
        }

        /**
         * Customizable display options for a payment link.
         */
        public Builder display(Optional<? extends PaymentLinkDisplayOptionsUpdate> display) {
            Utils.checkNotNull(display, "display");
            this.display = display;
            return this;
        }


        public Builder customer(PaymentLinkCustomerOptions customer) {
            Utils.checkNotNull(customer, "customer");
            this.customer = Optional.ofNullable(customer);
            return this;
        }

        public Builder customer(Optional<? extends PaymentLinkCustomerOptions> customer) {
            Utils.checkNotNull(customer, "customer");
            this.customer = customer;
            return this;
        }


        /**
         * Options for payment links used to collect payment.
         */
        public Builder payment(PaymentLinkPaymentDetailsUpdate payment) {
            Utils.checkNotNull(payment, "payment");
            this.payment = Optional.ofNullable(payment);
            return this;
        }

        /**
         * Options for payment links used to collect payment.
         */
        public Builder payment(Optional<? extends PaymentLinkPaymentDetailsUpdate> payment) {
            Utils.checkNotNull(payment, "payment");
            this.payment = payment;
            return this;
        }


        public Builder payout(PaymentLinkPayoutDetailsUpdate payout) {
            Utils.checkNotNull(payout, "payout");
            this.payout = Optional.ofNullable(payout);
            return this;
        }

        public Builder payout(Optional<? extends PaymentLinkPayoutDetailsUpdate> payout) {
            Utils.checkNotNull(payout, "payout");
            this.payout = payout;
            return this;
        }

        public UpdatePaymentLink build() {

            return new UpdatePaymentLink(
                amount, expiresOn, display,
                customer, payment, payout);
        }

    }
}
