/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class UpdateEvidence {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("evidenceType")
    private Optional<? extends EvidenceType> evidenceType;

    /**
     * If updating text evidence, the new text to associate with the dispute.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("text")
    private Optional<String> text;

    @JsonCreator
    public UpdateEvidence(
            @JsonProperty("evidenceType") Optional<? extends EvidenceType> evidenceType,
            @JsonProperty("text") Optional<String> text) {
        Utils.checkNotNull(evidenceType, "evidenceType");
        Utils.checkNotNull(text, "text");
        this.evidenceType = evidenceType;
        this.text = text;
    }
    
    public UpdateEvidence() {
        this(Optional.empty(), Optional.empty());
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<EvidenceType> evidenceType() {
        return (Optional<EvidenceType>) evidenceType;
    }

    /**
     * If updating text evidence, the new text to associate with the dispute.
     */
    @JsonIgnore
    public Optional<String> text() {
        return text;
    }

    public static Builder builder() {
        return new Builder();
    }


    public UpdateEvidence withEvidenceType(EvidenceType evidenceType) {
        Utils.checkNotNull(evidenceType, "evidenceType");
        this.evidenceType = Optional.ofNullable(evidenceType);
        return this;
    }


    public UpdateEvidence withEvidenceType(Optional<? extends EvidenceType> evidenceType) {
        Utils.checkNotNull(evidenceType, "evidenceType");
        this.evidenceType = evidenceType;
        return this;
    }

    /**
     * If updating text evidence, the new text to associate with the dispute.
     */
    public UpdateEvidence withText(String text) {
        Utils.checkNotNull(text, "text");
        this.text = Optional.ofNullable(text);
        return this;
    }


    /**
     * If updating text evidence, the new text to associate with the dispute.
     */
    public UpdateEvidence withText(Optional<String> text) {
        Utils.checkNotNull(text, "text");
        this.text = text;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateEvidence other = (UpdateEvidence) o;
        return 
            Utils.enhancedDeepEquals(this.evidenceType, other.evidenceType) &&
            Utils.enhancedDeepEquals(this.text, other.text);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            evidenceType, text);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UpdateEvidence.class,
                "evidenceType", evidenceType,
                "text", text);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<? extends EvidenceType> evidenceType = Optional.empty();

        private Optional<String> text = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder evidenceType(EvidenceType evidenceType) {
            Utils.checkNotNull(evidenceType, "evidenceType");
            this.evidenceType = Optional.ofNullable(evidenceType);
            return this;
        }

        public Builder evidenceType(Optional<? extends EvidenceType> evidenceType) {
            Utils.checkNotNull(evidenceType, "evidenceType");
            this.evidenceType = evidenceType;
            return this;
        }


        /**
         * If updating text evidence, the new text to associate with the dispute.
         */
        public Builder text(String text) {
            Utils.checkNotNull(text, "text");
            this.text = Optional.ofNullable(text);
            return this;
        }

        /**
         * If updating text evidence, the new text to associate with the dispute.
         */
        public Builder text(Optional<String> text) {
            Utils.checkNotNull(text, "text");
            this.text = text;
            return this;
        }

        public UpdateEvidence build() {

            return new UpdateEvidence(
                evidenceType, text);
        }

    }
}
