/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;


public class TicketMessage {

    @JsonProperty("author")
    private String author;


    @JsonProperty("body")
    private String body;


    @JsonProperty("sentOn")
    private OffsetDateTime sentOn;

    @JsonCreator
    public TicketMessage(
            @JsonProperty("author") String author,
            @JsonProperty("body") String body,
            @JsonProperty("sentOn") OffsetDateTime sentOn) {
        Utils.checkNotNull(author, "author");
        Utils.checkNotNull(body, "body");
        Utils.checkNotNull(sentOn, "sentOn");
        this.author = author;
        this.body = body;
        this.sentOn = sentOn;
    }

    @JsonIgnore
    public String author() {
        return author;
    }

    @JsonIgnore
    public String body() {
        return body;
    }

    @JsonIgnore
    public OffsetDateTime sentOn() {
        return sentOn;
    }

    public static Builder builder() {
        return new Builder();
    }


    public TicketMessage withAuthor(String author) {
        Utils.checkNotNull(author, "author");
        this.author = author;
        return this;
    }

    public TicketMessage withBody(String body) {
        Utils.checkNotNull(body, "body");
        this.body = body;
        return this;
    }

    public TicketMessage withSentOn(OffsetDateTime sentOn) {
        Utils.checkNotNull(sentOn, "sentOn");
        this.sentOn = sentOn;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TicketMessage other = (TicketMessage) o;
        return 
            Utils.enhancedDeepEquals(this.author, other.author) &&
            Utils.enhancedDeepEquals(this.body, other.body) &&
            Utils.enhancedDeepEquals(this.sentOn, other.sentOn);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            author, body, sentOn);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TicketMessage.class,
                "author", author,
                "body", body,
                "sentOn", sentOn);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String author;

        private String body;

        private OffsetDateTime sentOn;

        private Builder() {
          // force use of static builder() method
        }


        public Builder author(String author) {
            Utils.checkNotNull(author, "author");
            this.author = author;
            return this;
        }


        public Builder body(String body) {
            Utils.checkNotNull(body, "body");
            this.body = body;
            return this;
        }


        public Builder sentOn(OffsetDateTime sentOn) {
            Utils.checkNotNull(sentOn, "sentOn");
            this.sentOn = sentOn;
            return this;
        }

        public TicketMessage build() {

            return new TicketMessage(
                author, body, sentOn);
        }

    }
}
