/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Optional;


public class Ticket {

    @JsonProperty("ticketID")
    private String ticketID;


    @JsonProperty("number")
    private long number;


    @JsonProperty("title")
    private String title;


    @JsonProperty("contact")
    private TicketContact contact;


    @JsonProperty("status")
    private TicketStatus status;


    @JsonProperty("createdOn")
    private OffsetDateTime createdOn;


    @JsonProperty("updatedOn")
    private OffsetDateTime updatedOn;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("latestMessageOn")
    private Optional<OffsetDateTime> latestMessageOn;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("closedOn")
    private Optional<OffsetDateTime> closedOn;

    @JsonCreator
    public Ticket(
            @JsonProperty("ticketID") String ticketID,
            @JsonProperty("number") long number,
            @JsonProperty("title") String title,
            @JsonProperty("contact") TicketContact contact,
            @JsonProperty("status") TicketStatus status,
            @JsonProperty("createdOn") OffsetDateTime createdOn,
            @JsonProperty("updatedOn") OffsetDateTime updatedOn,
            @JsonProperty("latestMessageOn") Optional<OffsetDateTime> latestMessageOn,
            @JsonProperty("closedOn") Optional<OffsetDateTime> closedOn) {
        Utils.checkNotNull(ticketID, "ticketID");
        Utils.checkNotNull(number, "number");
        Utils.checkNotNull(title, "title");
        Utils.checkNotNull(contact, "contact");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(createdOn, "createdOn");
        Utils.checkNotNull(updatedOn, "updatedOn");
        Utils.checkNotNull(latestMessageOn, "latestMessageOn");
        Utils.checkNotNull(closedOn, "closedOn");
        this.ticketID = ticketID;
        this.number = number;
        this.title = title;
        this.contact = contact;
        this.status = status;
        this.createdOn = createdOn;
        this.updatedOn = updatedOn;
        this.latestMessageOn = latestMessageOn;
        this.closedOn = closedOn;
    }
    
    public Ticket(
            String ticketID,
            long number,
            String title,
            TicketContact contact,
            TicketStatus status,
            OffsetDateTime createdOn,
            OffsetDateTime updatedOn) {
        this(ticketID, number, title,
            contact, status, createdOn,
            updatedOn, Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public String ticketID() {
        return ticketID;
    }

    @JsonIgnore
    public long number() {
        return number;
    }

    @JsonIgnore
    public String title() {
        return title;
    }

    @JsonIgnore
    public TicketContact contact() {
        return contact;
    }

    @JsonIgnore
    public TicketStatus status() {
        return status;
    }

    @JsonIgnore
    public OffsetDateTime createdOn() {
        return createdOn;
    }

    @JsonIgnore
    public OffsetDateTime updatedOn() {
        return updatedOn;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> latestMessageOn() {
        return latestMessageOn;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> closedOn() {
        return closedOn;
    }

    public static Builder builder() {
        return new Builder();
    }


    public Ticket withTicketID(String ticketID) {
        Utils.checkNotNull(ticketID, "ticketID");
        this.ticketID = ticketID;
        return this;
    }

    public Ticket withNumber(long number) {
        Utils.checkNotNull(number, "number");
        this.number = number;
        return this;
    }

    public Ticket withTitle(String title) {
        Utils.checkNotNull(title, "title");
        this.title = title;
        return this;
    }

    public Ticket withContact(TicketContact contact) {
        Utils.checkNotNull(contact, "contact");
        this.contact = contact;
        return this;
    }

    public Ticket withStatus(TicketStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public Ticket withCreatedOn(OffsetDateTime createdOn) {
        Utils.checkNotNull(createdOn, "createdOn");
        this.createdOn = createdOn;
        return this;
    }

    public Ticket withUpdatedOn(OffsetDateTime updatedOn) {
        Utils.checkNotNull(updatedOn, "updatedOn");
        this.updatedOn = updatedOn;
        return this;
    }

    public Ticket withLatestMessageOn(OffsetDateTime latestMessageOn) {
        Utils.checkNotNull(latestMessageOn, "latestMessageOn");
        this.latestMessageOn = Optional.ofNullable(latestMessageOn);
        return this;
    }


    public Ticket withLatestMessageOn(Optional<OffsetDateTime> latestMessageOn) {
        Utils.checkNotNull(latestMessageOn, "latestMessageOn");
        this.latestMessageOn = latestMessageOn;
        return this;
    }

    public Ticket withClosedOn(OffsetDateTime closedOn) {
        Utils.checkNotNull(closedOn, "closedOn");
        this.closedOn = Optional.ofNullable(closedOn);
        return this;
    }


    public Ticket withClosedOn(Optional<OffsetDateTime> closedOn) {
        Utils.checkNotNull(closedOn, "closedOn");
        this.closedOn = closedOn;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Ticket other = (Ticket) o;
        return 
            Utils.enhancedDeepEquals(this.ticketID, other.ticketID) &&
            Utils.enhancedDeepEquals(this.number, other.number) &&
            Utils.enhancedDeepEquals(this.title, other.title) &&
            Utils.enhancedDeepEquals(this.contact, other.contact) &&
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.createdOn, other.createdOn) &&
            Utils.enhancedDeepEquals(this.updatedOn, other.updatedOn) &&
            Utils.enhancedDeepEquals(this.latestMessageOn, other.latestMessageOn) &&
            Utils.enhancedDeepEquals(this.closedOn, other.closedOn);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            ticketID, number, title,
            contact, status, createdOn,
            updatedOn, latestMessageOn, closedOn);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Ticket.class,
                "ticketID", ticketID,
                "number", number,
                "title", title,
                "contact", contact,
                "status", status,
                "createdOn", createdOn,
                "updatedOn", updatedOn,
                "latestMessageOn", latestMessageOn,
                "closedOn", closedOn);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String ticketID;

        private Long number;

        private String title;

        private TicketContact contact;

        private TicketStatus status;

        private OffsetDateTime createdOn;

        private OffsetDateTime updatedOn;

        private Optional<OffsetDateTime> latestMessageOn = Optional.empty();

        private Optional<OffsetDateTime> closedOn = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder ticketID(String ticketID) {
            Utils.checkNotNull(ticketID, "ticketID");
            this.ticketID = ticketID;
            return this;
        }


        public Builder number(long number) {
            Utils.checkNotNull(number, "number");
            this.number = number;
            return this;
        }


        public Builder title(String title) {
            Utils.checkNotNull(title, "title");
            this.title = title;
            return this;
        }


        public Builder contact(TicketContact contact) {
            Utils.checkNotNull(contact, "contact");
            this.contact = contact;
            return this;
        }


        public Builder status(TicketStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        public Builder createdOn(OffsetDateTime createdOn) {
            Utils.checkNotNull(createdOn, "createdOn");
            this.createdOn = createdOn;
            return this;
        }


        public Builder updatedOn(OffsetDateTime updatedOn) {
            Utils.checkNotNull(updatedOn, "updatedOn");
            this.updatedOn = updatedOn;
            return this;
        }


        public Builder latestMessageOn(OffsetDateTime latestMessageOn) {
            Utils.checkNotNull(latestMessageOn, "latestMessageOn");
            this.latestMessageOn = Optional.ofNullable(latestMessageOn);
            return this;
        }

        public Builder latestMessageOn(Optional<OffsetDateTime> latestMessageOn) {
            Utils.checkNotNull(latestMessageOn, "latestMessageOn");
            this.latestMessageOn = latestMessageOn;
            return this;
        }


        public Builder closedOn(OffsetDateTime closedOn) {
            Utils.checkNotNull(closedOn, "closedOn");
            this.closedOn = Optional.ofNullable(closedOn);
            return this;
        }

        public Builder closedOn(Optional<OffsetDateTime> closedOn) {
            Utils.checkNotNull(closedOn, "closedOn");
            this.closedOn = closedOn;
            return this;
        }

        public Ticket build() {

            return new Ticket(
                ticketID, number, title,
                contact, status, createdOn,
                updatedOn, latestMessageOn, closedOn);
        }

    }
}
