/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;

/**
 * TerminalApplicationVersion
 * 
 * <p>Describes a terminal application version.
 */
public class TerminalApplicationVersion {
    /**
     * The app version of the terminal application (version code for Android terminal application).
     */
    @JsonProperty("version")
    private String version;

    @JsonCreator
    public TerminalApplicationVersion(
            @JsonProperty("version") String version) {
        Utils.checkNotNull(version, "version");
        this.version = version;
    }

    /**
     * The app version of the terminal application (version code for Android terminal application).
     */
    @JsonIgnore
    public String version() {
        return version;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The app version of the terminal application (version code for Android terminal application).
     */
    public TerminalApplicationVersion withVersion(String version) {
        Utils.checkNotNull(version, "version");
        this.version = version;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TerminalApplicationVersion other = (TerminalApplicationVersion) o;
        return 
            Utils.enhancedDeepEquals(this.version, other.version);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            version);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TerminalApplicationVersion.class,
                "version", version);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String version;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The app version of the terminal application (version code for Android terminal application).
         */
        public Builder version(String version) {
            Utils.checkNotNull(version, "version");
            this.version = version;
            return this;
        }

        public TerminalApplicationVersion build() {

            return new TerminalApplicationVersion(
                version);
        }

    }
}
