/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;


public class SweepSubtotal {
    /**
     * The type of wallet transaction the subtotal is for.
     */
    @JsonProperty("type")
    private WalletTransactionType type;

    /**
     * The number of transactions of this type accrued in the sweep.
     */
    @JsonProperty("count")
    private long count;

    /**
     * The value of transactions of this type accrued in the sweep.
     */
    @JsonProperty("amount")
    private AmountDecimal amount;

    @JsonCreator
    public SweepSubtotal(
            @JsonProperty("type") WalletTransactionType type,
            @JsonProperty("count") long count,
            @JsonProperty("amount") AmountDecimal amount) {
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(count, "count");
        Utils.checkNotNull(amount, "amount");
        this.type = type;
        this.count = count;
        this.amount = amount;
    }

    /**
     * The type of wallet transaction the subtotal is for.
     */
    @JsonIgnore
    public WalletTransactionType type() {
        return type;
    }

    /**
     * The number of transactions of this type accrued in the sweep.
     */
    @JsonIgnore
    public long count() {
        return count;
    }

    /**
     * The value of transactions of this type accrued in the sweep.
     */
    @JsonIgnore
    public AmountDecimal amount() {
        return amount;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The type of wallet transaction the subtotal is for.
     */
    public SweepSubtotal withType(WalletTransactionType type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    /**
     * The number of transactions of this type accrued in the sweep.
     */
    public SweepSubtotal withCount(long count) {
        Utils.checkNotNull(count, "count");
        this.count = count;
        return this;
    }

    /**
     * The value of transactions of this type accrued in the sweep.
     */
    public SweepSubtotal withAmount(AmountDecimal amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SweepSubtotal other = (SweepSubtotal) o;
        return 
            Utils.enhancedDeepEquals(this.type, other.type) &&
            Utils.enhancedDeepEquals(this.count, other.count) &&
            Utils.enhancedDeepEquals(this.amount, other.amount);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            type, count, amount);
    }
    
    @Override
    public String toString() {
        return Utils.toString(SweepSubtotal.class,
                "type", type,
                "count", count,
                "amount", amount);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private WalletTransactionType type;

        private Long count;

        private AmountDecimal amount;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The type of wallet transaction the subtotal is for.
         */
        public Builder type(WalletTransactionType type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }


        /**
         * The number of transactions of this type accrued in the sweep.
         */
        public Builder count(long count) {
            Utils.checkNotNull(count, "count");
            this.count = count;
            return this;
        }


        /**
         * The value of transactions of this type accrued in the sweep.
         */
        public Builder amount(AmountDecimal amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }

        public SweepSubtotal build() {

            return new SweepSubtotal(
                type, count, amount);
        }

    }
}
