/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class SourceDestinationOptions {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("accountID")
    private Optional<String> accountID;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("paymentMethodID")
    private Optional<String> paymentMethodID;

    @JsonCreator
    public SourceDestinationOptions(
            @JsonProperty("accountID") Optional<String> accountID,
            @JsonProperty("paymentMethodID") Optional<String> paymentMethodID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(paymentMethodID, "paymentMethodID");
        this.accountID = accountID;
        this.paymentMethodID = paymentMethodID;
    }
    
    public SourceDestinationOptions() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> accountID() {
        return accountID;
    }

    @JsonIgnore
    public Optional<String> paymentMethodID() {
        return paymentMethodID;
    }

    public static Builder builder() {
        return new Builder();
    }


    public SourceDestinationOptions withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = Optional.ofNullable(accountID);
        return this;
    }


    public SourceDestinationOptions withAccountID(Optional<String> accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public SourceDestinationOptions withPaymentMethodID(String paymentMethodID) {
        Utils.checkNotNull(paymentMethodID, "paymentMethodID");
        this.paymentMethodID = Optional.ofNullable(paymentMethodID);
        return this;
    }


    public SourceDestinationOptions withPaymentMethodID(Optional<String> paymentMethodID) {
        Utils.checkNotNull(paymentMethodID, "paymentMethodID");
        this.paymentMethodID = paymentMethodID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SourceDestinationOptions other = (SourceDestinationOptions) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.paymentMethodID, other.paymentMethodID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, paymentMethodID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(SourceDestinationOptions.class,
                "accountID", accountID,
                "paymentMethodID", paymentMethodID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> accountID = Optional.empty();

        private Optional<String> paymentMethodID = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = Optional.ofNullable(accountID);
            return this;
        }

        public Builder accountID(Optional<String> accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder paymentMethodID(String paymentMethodID) {
            Utils.checkNotNull(paymentMethodID, "paymentMethodID");
            this.paymentMethodID = Optional.ofNullable(paymentMethodID);
            return this;
        }

        public Builder paymentMethodID(Optional<String> paymentMethodID) {
            Utils.checkNotNull(paymentMethodID, "paymentMethodID");
            this.paymentMethodID = paymentMethodID;
            return this;
        }

        public SourceDestinationOptions build() {

            return new SourceDestinationOptions(
                accountID, paymentMethodID);
        }

    }
}
