/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class RequestCard {

    @JsonProperty("fundingWalletID")
    private String fundingWalletID;

    /**
     * Fields for identifying an authorized individual.
     */
    @JsonProperty("authorizedUser")
    private CreateAuthorizedUser authorizedUser;

    /**
     * Specifies the type of spend card to be issued. Presently supports virtual only, providing a digital number without a physical card.
     */
    @JsonProperty("formFactor")
    private IssuedCardFormFactor formFactor;

    /**
     * An optional descriptive name for the card.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("memo")
    private Optional<String> memo;

    /**
     * The expiration date of the card or token.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("expiration")
    private Optional<? extends CardExpiration> expiration;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("controls")
    private Optional<? extends IssuingControls> controls;

    @JsonCreator
    public RequestCard(
            @JsonProperty("fundingWalletID") String fundingWalletID,
            @JsonProperty("authorizedUser") CreateAuthorizedUser authorizedUser,
            @JsonProperty("formFactor") IssuedCardFormFactor formFactor,
            @JsonProperty("memo") Optional<String> memo,
            @JsonProperty("expiration") Optional<? extends CardExpiration> expiration,
            @JsonProperty("controls") Optional<? extends IssuingControls> controls) {
        Utils.checkNotNull(fundingWalletID, "fundingWalletID");
        Utils.checkNotNull(authorizedUser, "authorizedUser");
        Utils.checkNotNull(formFactor, "formFactor");
        Utils.checkNotNull(memo, "memo");
        Utils.checkNotNull(expiration, "expiration");
        Utils.checkNotNull(controls, "controls");
        this.fundingWalletID = fundingWalletID;
        this.authorizedUser = authorizedUser;
        this.formFactor = formFactor;
        this.memo = memo;
        this.expiration = expiration;
        this.controls = controls;
    }
    
    public RequestCard(
            String fundingWalletID,
            CreateAuthorizedUser authorizedUser,
            IssuedCardFormFactor formFactor) {
        this(fundingWalletID, authorizedUser, formFactor,
            Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public String fundingWalletID() {
        return fundingWalletID;
    }

    /**
     * Fields for identifying an authorized individual.
     */
    @JsonIgnore
    public CreateAuthorizedUser authorizedUser() {
        return authorizedUser;
    }

    /**
     * Specifies the type of spend card to be issued. Presently supports virtual only, providing a digital number without a physical card.
     */
    @JsonIgnore
    public IssuedCardFormFactor formFactor() {
        return formFactor;
    }

    /**
     * An optional descriptive name for the card.
     */
    @JsonIgnore
    public Optional<String> memo() {
        return memo;
    }

    /**
     * The expiration date of the card or token.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CardExpiration> expiration() {
        return (Optional<CardExpiration>) expiration;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<IssuingControls> controls() {
        return (Optional<IssuingControls>) controls;
    }

    public static Builder builder() {
        return new Builder();
    }


    public RequestCard withFundingWalletID(String fundingWalletID) {
        Utils.checkNotNull(fundingWalletID, "fundingWalletID");
        this.fundingWalletID = fundingWalletID;
        return this;
    }

    /**
     * Fields for identifying an authorized individual.
     */
    public RequestCard withAuthorizedUser(CreateAuthorizedUser authorizedUser) {
        Utils.checkNotNull(authorizedUser, "authorizedUser");
        this.authorizedUser = authorizedUser;
        return this;
    }

    /**
     * Specifies the type of spend card to be issued. Presently supports virtual only, providing a digital number without a physical card.
     */
    public RequestCard withFormFactor(IssuedCardFormFactor formFactor) {
        Utils.checkNotNull(formFactor, "formFactor");
        this.formFactor = formFactor;
        return this;
    }

    /**
     * An optional descriptive name for the card.
     */
    public RequestCard withMemo(String memo) {
        Utils.checkNotNull(memo, "memo");
        this.memo = Optional.ofNullable(memo);
        return this;
    }


    /**
     * An optional descriptive name for the card.
     */
    public RequestCard withMemo(Optional<String> memo) {
        Utils.checkNotNull(memo, "memo");
        this.memo = memo;
        return this;
    }

    /**
     * The expiration date of the card or token.
     */
    public RequestCard withExpiration(CardExpiration expiration) {
        Utils.checkNotNull(expiration, "expiration");
        this.expiration = Optional.ofNullable(expiration);
        return this;
    }


    /**
     * The expiration date of the card or token.
     */
    public RequestCard withExpiration(Optional<? extends CardExpiration> expiration) {
        Utils.checkNotNull(expiration, "expiration");
        this.expiration = expiration;
        return this;
    }

    public RequestCard withControls(IssuingControls controls) {
        Utils.checkNotNull(controls, "controls");
        this.controls = Optional.ofNullable(controls);
        return this;
    }


    public RequestCard withControls(Optional<? extends IssuingControls> controls) {
        Utils.checkNotNull(controls, "controls");
        this.controls = controls;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RequestCard other = (RequestCard) o;
        return 
            Utils.enhancedDeepEquals(this.fundingWalletID, other.fundingWalletID) &&
            Utils.enhancedDeepEquals(this.authorizedUser, other.authorizedUser) &&
            Utils.enhancedDeepEquals(this.formFactor, other.formFactor) &&
            Utils.enhancedDeepEquals(this.memo, other.memo) &&
            Utils.enhancedDeepEquals(this.expiration, other.expiration) &&
            Utils.enhancedDeepEquals(this.controls, other.controls);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            fundingWalletID, authorizedUser, formFactor,
            memo, expiration, controls);
    }
    
    @Override
    public String toString() {
        return Utils.toString(RequestCard.class,
                "fundingWalletID", fundingWalletID,
                "authorizedUser", authorizedUser,
                "formFactor", formFactor,
                "memo", memo,
                "expiration", expiration,
                "controls", controls);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String fundingWalletID;

        private CreateAuthorizedUser authorizedUser;

        private IssuedCardFormFactor formFactor;

        private Optional<String> memo = Optional.empty();

        private Optional<? extends CardExpiration> expiration = Optional.empty();

        private Optional<? extends IssuingControls> controls = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder fundingWalletID(String fundingWalletID) {
            Utils.checkNotNull(fundingWalletID, "fundingWalletID");
            this.fundingWalletID = fundingWalletID;
            return this;
        }


        /**
         * Fields for identifying an authorized individual.
         */
        public Builder authorizedUser(CreateAuthorizedUser authorizedUser) {
            Utils.checkNotNull(authorizedUser, "authorizedUser");
            this.authorizedUser = authorizedUser;
            return this;
        }


        /**
         * Specifies the type of spend card to be issued. Presently supports virtual only, providing a digital number without a physical card.
         */
        public Builder formFactor(IssuedCardFormFactor formFactor) {
            Utils.checkNotNull(formFactor, "formFactor");
            this.formFactor = formFactor;
            return this;
        }


        /**
         * An optional descriptive name for the card.
         */
        public Builder memo(String memo) {
            Utils.checkNotNull(memo, "memo");
            this.memo = Optional.ofNullable(memo);
            return this;
        }

        /**
         * An optional descriptive name for the card.
         */
        public Builder memo(Optional<String> memo) {
            Utils.checkNotNull(memo, "memo");
            this.memo = memo;
            return this;
        }


        /**
         * The expiration date of the card or token.
         */
        public Builder expiration(CardExpiration expiration) {
            Utils.checkNotNull(expiration, "expiration");
            this.expiration = Optional.ofNullable(expiration);
            return this;
        }

        /**
         * The expiration date of the card or token.
         */
        public Builder expiration(Optional<? extends CardExpiration> expiration) {
            Utils.checkNotNull(expiration, "expiration");
            this.expiration = expiration;
            return this;
        }


        public Builder controls(IssuingControls controls) {
            Utils.checkNotNull(controls, "controls");
            this.controls = Optional.ofNullable(controls);
            return this;
        }

        public Builder controls(Optional<? extends IssuingControls> controls) {
            Utils.checkNotNull(controls, "controls");
            this.controls = controls;
            return this;
        }

        public RequestCard build() {

            return new RequestCard(
                fundingWalletID, authorizedUser, formFactor,
                memo, expiration, controls);
        }

    }
}
