/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;

/**
 * RepresentativeResponsibilities
 * 
 * <p>Describes the job responsibilities of a business representative.
 */
public class RepresentativeResponsibilities {
    /**
     * Indicates whether this individual has significant management responsibilities within the business.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("isController")
    private Optional<Boolean> isController;

    /**
     * If `true`, this field indicates that the individual has a business ownership stake of at least 25% in the
     * business. If the representative does not own at least 25% of the business, this field should be `false`.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("isOwner")
    private Optional<Boolean> isOwner;

    /**
     * The percentage of ownership this individual has in the business (required if `isOwner` is `true`).
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("ownershipPercentage")
    private Optional<Long> ownershipPercentage;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("jobTitle")
    private Optional<String> jobTitle;

    @JsonCreator
    public RepresentativeResponsibilities(
            @JsonProperty("isController") Optional<Boolean> isController,
            @JsonProperty("isOwner") Optional<Boolean> isOwner,
            @JsonProperty("ownershipPercentage") Optional<Long> ownershipPercentage,
            @JsonProperty("jobTitle") Optional<String> jobTitle) {
        Utils.checkNotNull(isController, "isController");
        Utils.checkNotNull(isOwner, "isOwner");
        Utils.checkNotNull(ownershipPercentage, "ownershipPercentage");
        Utils.checkNotNull(jobTitle, "jobTitle");
        this.isController = isController;
        this.isOwner = isOwner;
        this.ownershipPercentage = ownershipPercentage;
        this.jobTitle = jobTitle;
    }
    
    public RepresentativeResponsibilities() {
        this(Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty());
    }

    /**
     * Indicates whether this individual has significant management responsibilities within the business.
     */
    @JsonIgnore
    public Optional<Boolean> isController() {
        return isController;
    }

    /**
     * If `true`, this field indicates that the individual has a business ownership stake of at least 25% in the
     * business. If the representative does not own at least 25% of the business, this field should be `false`.
     */
    @JsonIgnore
    public Optional<Boolean> isOwner() {
        return isOwner;
    }

    /**
     * The percentage of ownership this individual has in the business (required if `isOwner` is `true`).
     */
    @JsonIgnore
    public Optional<Long> ownershipPercentage() {
        return ownershipPercentage;
    }

    @JsonIgnore
    public Optional<String> jobTitle() {
        return jobTitle;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Indicates whether this individual has significant management responsibilities within the business.
     */
    public RepresentativeResponsibilities withIsController(boolean isController) {
        Utils.checkNotNull(isController, "isController");
        this.isController = Optional.ofNullable(isController);
        return this;
    }


    /**
     * Indicates whether this individual has significant management responsibilities within the business.
     */
    public RepresentativeResponsibilities withIsController(Optional<Boolean> isController) {
        Utils.checkNotNull(isController, "isController");
        this.isController = isController;
        return this;
    }

    /**
     * If `true`, this field indicates that the individual has a business ownership stake of at least 25% in the
     * business. If the representative does not own at least 25% of the business, this field should be `false`.
     */
    public RepresentativeResponsibilities withIsOwner(boolean isOwner) {
        Utils.checkNotNull(isOwner, "isOwner");
        this.isOwner = Optional.ofNullable(isOwner);
        return this;
    }


    /**
     * If `true`, this field indicates that the individual has a business ownership stake of at least 25% in the
     * business. If the representative does not own at least 25% of the business, this field should be `false`.
     */
    public RepresentativeResponsibilities withIsOwner(Optional<Boolean> isOwner) {
        Utils.checkNotNull(isOwner, "isOwner");
        this.isOwner = isOwner;
        return this;
    }

    /**
     * The percentage of ownership this individual has in the business (required if `isOwner` is `true`).
     */
    public RepresentativeResponsibilities withOwnershipPercentage(long ownershipPercentage) {
        Utils.checkNotNull(ownershipPercentage, "ownershipPercentage");
        this.ownershipPercentage = Optional.ofNullable(ownershipPercentage);
        return this;
    }


    /**
     * The percentage of ownership this individual has in the business (required if `isOwner` is `true`).
     */
    public RepresentativeResponsibilities withOwnershipPercentage(Optional<Long> ownershipPercentage) {
        Utils.checkNotNull(ownershipPercentage, "ownershipPercentage");
        this.ownershipPercentage = ownershipPercentage;
        return this;
    }

    public RepresentativeResponsibilities withJobTitle(String jobTitle) {
        Utils.checkNotNull(jobTitle, "jobTitle");
        this.jobTitle = Optional.ofNullable(jobTitle);
        return this;
    }


    public RepresentativeResponsibilities withJobTitle(Optional<String> jobTitle) {
        Utils.checkNotNull(jobTitle, "jobTitle");
        this.jobTitle = jobTitle;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RepresentativeResponsibilities other = (RepresentativeResponsibilities) o;
        return 
            Utils.enhancedDeepEquals(this.isController, other.isController) &&
            Utils.enhancedDeepEquals(this.isOwner, other.isOwner) &&
            Utils.enhancedDeepEquals(this.ownershipPercentage, other.ownershipPercentage) &&
            Utils.enhancedDeepEquals(this.jobTitle, other.jobTitle);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            isController, isOwner, ownershipPercentage,
            jobTitle);
    }
    
    @Override
    public String toString() {
        return Utils.toString(RepresentativeResponsibilities.class,
                "isController", isController,
                "isOwner", isOwner,
                "ownershipPercentage", ownershipPercentage,
                "jobTitle", jobTitle);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<Boolean> isController = Optional.empty();

        private Optional<Boolean> isOwner = Optional.empty();

        private Optional<Long> ownershipPercentage = Optional.empty();

        private Optional<String> jobTitle = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Indicates whether this individual has significant management responsibilities within the business.
         */
        public Builder isController(boolean isController) {
            Utils.checkNotNull(isController, "isController");
            this.isController = Optional.ofNullable(isController);
            return this;
        }

        /**
         * Indicates whether this individual has significant management responsibilities within the business.
         */
        public Builder isController(Optional<Boolean> isController) {
            Utils.checkNotNull(isController, "isController");
            this.isController = isController;
            return this;
        }


        /**
         * If `true`, this field indicates that the individual has a business ownership stake of at least 25% in the
         * business. If the representative does not own at least 25% of the business, this field should be `false`.
         */
        public Builder isOwner(boolean isOwner) {
            Utils.checkNotNull(isOwner, "isOwner");
            this.isOwner = Optional.ofNullable(isOwner);
            return this;
        }

        /**
         * If `true`, this field indicates that the individual has a business ownership stake of at least 25% in the
         * business. If the representative does not own at least 25% of the business, this field should be `false`.
         */
        public Builder isOwner(Optional<Boolean> isOwner) {
            Utils.checkNotNull(isOwner, "isOwner");
            this.isOwner = isOwner;
            return this;
        }


        /**
         * The percentage of ownership this individual has in the business (required if `isOwner` is `true`).
         */
        public Builder ownershipPercentage(long ownershipPercentage) {
            Utils.checkNotNull(ownershipPercentage, "ownershipPercentage");
            this.ownershipPercentage = Optional.ofNullable(ownershipPercentage);
            return this;
        }

        /**
         * The percentage of ownership this individual has in the business (required if `isOwner` is `true`).
         */
        public Builder ownershipPercentage(Optional<Long> ownershipPercentage) {
            Utils.checkNotNull(ownershipPercentage, "ownershipPercentage");
            this.ownershipPercentage = ownershipPercentage;
            return this;
        }


        public Builder jobTitle(String jobTitle) {
            Utils.checkNotNull(jobTitle, "jobTitle");
            this.jobTitle = Optional.ofNullable(jobTitle);
            return this;
        }

        public Builder jobTitle(Optional<String> jobTitle) {
            Utils.checkNotNull(jobTitle, "jobTitle");
            this.jobTitle = jobTitle;
            return this;
        }

        public RepresentativeResponsibilities build() {

            return new RepresentativeResponsibilities(
                isController, isOwner, ownershipPercentage,
                jobTitle);
        }

    }
}
