/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;

/**
 * RTPRejectionCode
 * 
 * <p>The rejection code of an RTP transaction that caused the bank account status to change.
 * 
 * <p>- AC03: Account Invalid
 * - AC04: Account Closed
 * - AC06: Account Blocked
 * - AC14: Creditor Account Type Invalid
 * - AG01: Transactions Forbidden On Account
 * - AG03: Transaction Type Not Supported
 * - MD07: Customer Deceased
 */
public enum RTPRejectionCode {
    AC03("AC03"),
    AC04("AC04"),
    AC06("AC06"),
    AC14("AC14"),
    AG01("AG01"),
    AG03("AG03"),
    MD07("MD07");

    @JsonValue
    private final String value;

    RTPRejectionCode(String value) {
        this.value = value;
    }
    
    public String value() {
        return value;
    }
    
    public static Optional<RTPRejectionCode> fromValue(String value) {
        for (RTPRejectionCode o: RTPRejectionCode.values()) {
            if (Objects.deepEquals(o.value, value)) {
                return Optional.of(o);
            }
        }
        return Optional.empty();
    }
}

