/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;

/**
 * PlaidIntegration
 * 
 * <p>The details of a Plaid processor integration for a linked funding source. 
 * 
 * <p>`sandbox` - When linking a bank account to a `sandbox` account using a Plaid processor token a default bank account
 * response will be used. The following default data will be used to generate the bank account in this flow:
 * 
 * <p>```
 *   RoutingNumber: "011401533",
 *   AccountNumber: "1111222233330000",
 *   AccountType:   "checking",
 *   Mask:          "0000"
 * ```
 */
public class PlaidIntegration {

    @JsonProperty("token")
    private String token;

    @JsonCreator
    public PlaidIntegration(
            @JsonProperty("token") String token) {
        Utils.checkNotNull(token, "token");
        this.token = token;
    }

    @JsonIgnore
    public String token() {
        return token;
    }

    public static Builder builder() {
        return new Builder();
    }


    public PlaidIntegration withToken(String token) {
        Utils.checkNotNull(token, "token");
        this.token = token;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PlaidIntegration other = (PlaidIntegration) o;
        return 
            Utils.enhancedDeepEquals(this.token, other.token);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            token);
    }
    
    @Override
    public String toString() {
        return Utils.toString(PlaidIntegration.class,
                "token", token);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String token;

        private Builder() {
          // force use of static builder() method
        }


        public Builder token(String token) {
            Utils.checkNotNull(token, "token");
            this.token = token;
            return this;
        }

        public PlaidIntegration build() {

            return new PlaidIntegration(
                token);
        }

    }
}
