/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.Optional;


public class PaymentLink {
    /**
     * Unique code identifying this payment link.
     */
    @JsonProperty("code")
    private String code;

    /**
     * The operating mode for an account.
     */
    @JsonProperty("mode")
    private Mode mode;


    @JsonProperty("status")
    private PaymentLinkStatus status;

    /**
     * The partner's Moov account ID.
     */
    @JsonProperty("partnerAccountID")
    private String partnerAccountID;

    /**
     * The merchant's Moov account ID.
     */
    @JsonProperty("merchantAccountID")
    private String merchantAccountID;

    /**
     * The merchant's preferred payment method ID. Must be a wallet payment method.
     */
    @JsonProperty("merchantPaymentMethodID")
    private String merchantPaymentMethodID;

    /**
     * Link to the payment landing page for this payment link.
     */
    @JsonProperty("link")
    private String link;


    @JsonProperty("amount")
    private Amount amount;

    /**
     * The number of times this payment link has been used.
     */
    @JsonProperty("uses")
    private long uses;

    /**
     * An optional limit on the number of times this payment link can be used. 
     * 
     * <p>**For payouts, `maxUses` is always 1.**
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("maxUses")
    private Optional<Long> maxUses;

    /**
     * The timestamp when this payment link was last used.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("lastUsedOn")
    private Optional<OffsetDateTime> lastUsedOn;

    /**
     * An optional expiration date for this payment link.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("expiresOn")
    private Optional<OffsetDateTime> expiresOn;

    /**
     * Customizable display options for a payment link.
     */
    @JsonProperty("display")
    private PaymentLinkDisplayOptions display;


    @JsonProperty("customer")
    private PaymentLinkCustomerOptions customer;

    /**
     * Options for payment links used to collect payment.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("payment")
    private Optional<? extends PaymentLinkPaymentDetails> payment;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("payout")
    private Optional<? extends PaymentLinkPayoutDetails> payout;


    @JsonProperty("createdOn")
    private OffsetDateTime createdOn;


    @JsonProperty("updatedOn")
    private OffsetDateTime updatedOn;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("disabledOn")
    private Optional<OffsetDateTime> disabledOn;

    @JsonCreator
    public PaymentLink(
            @JsonProperty("code") String code,
            @JsonProperty("mode") Mode mode,
            @JsonProperty("status") PaymentLinkStatus status,
            @JsonProperty("partnerAccountID") String partnerAccountID,
            @JsonProperty("merchantAccountID") String merchantAccountID,
            @JsonProperty("merchantPaymentMethodID") String merchantPaymentMethodID,
            @JsonProperty("link") String link,
            @JsonProperty("amount") Amount amount,
            @JsonProperty("uses") long uses,
            @JsonProperty("maxUses") Optional<Long> maxUses,
            @JsonProperty("lastUsedOn") Optional<OffsetDateTime> lastUsedOn,
            @JsonProperty("expiresOn") Optional<OffsetDateTime> expiresOn,
            @JsonProperty("display") PaymentLinkDisplayOptions display,
            @JsonProperty("customer") PaymentLinkCustomerOptions customer,
            @JsonProperty("payment") Optional<? extends PaymentLinkPaymentDetails> payment,
            @JsonProperty("payout") Optional<? extends PaymentLinkPayoutDetails> payout,
            @JsonProperty("createdOn") OffsetDateTime createdOn,
            @JsonProperty("updatedOn") OffsetDateTime updatedOn,
            @JsonProperty("disabledOn") Optional<OffsetDateTime> disabledOn) {
        Utils.checkNotNull(code, "code");
        Utils.checkNotNull(mode, "mode");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(partnerAccountID, "partnerAccountID");
        Utils.checkNotNull(merchantAccountID, "merchantAccountID");
        Utils.checkNotNull(merchantPaymentMethodID, "merchantPaymentMethodID");
        Utils.checkNotNull(link, "link");
        Utils.checkNotNull(amount, "amount");
        Utils.checkNotNull(uses, "uses");
        Utils.checkNotNull(maxUses, "maxUses");
        Utils.checkNotNull(lastUsedOn, "lastUsedOn");
        Utils.checkNotNull(expiresOn, "expiresOn");
        Utils.checkNotNull(display, "display");
        Utils.checkNotNull(customer, "customer");
        Utils.checkNotNull(payment, "payment");
        Utils.checkNotNull(payout, "payout");
        Utils.checkNotNull(createdOn, "createdOn");
        Utils.checkNotNull(updatedOn, "updatedOn");
        Utils.checkNotNull(disabledOn, "disabledOn");
        this.code = code;
        this.mode = mode;
        this.status = status;
        this.partnerAccountID = partnerAccountID;
        this.merchantAccountID = merchantAccountID;
        this.merchantPaymentMethodID = merchantPaymentMethodID;
        this.link = link;
        this.amount = amount;
        this.uses = uses;
        this.maxUses = maxUses;
        this.lastUsedOn = lastUsedOn;
        this.expiresOn = expiresOn;
        this.display = display;
        this.customer = customer;
        this.payment = payment;
        this.payout = payout;
        this.createdOn = createdOn;
        this.updatedOn = updatedOn;
        this.disabledOn = disabledOn;
    }
    
    public PaymentLink(
            String code,
            Mode mode,
            PaymentLinkStatus status,
            String partnerAccountID,
            String merchantAccountID,
            String merchantPaymentMethodID,
            String link,
            Amount amount,
            long uses,
            PaymentLinkDisplayOptions display,
            PaymentLinkCustomerOptions customer,
            OffsetDateTime createdOn,
            OffsetDateTime updatedOn) {
        this(code, mode, status,
            partnerAccountID, merchantAccountID, merchantPaymentMethodID,
            link, amount, uses,
            Optional.empty(), Optional.empty(), Optional.empty(),
            display, customer, Optional.empty(),
            Optional.empty(), createdOn, updatedOn,
            Optional.empty());
    }

    /**
     * Unique code identifying this payment link.
     */
    @JsonIgnore
    public String code() {
        return code;
    }

    /**
     * The operating mode for an account.
     */
    @JsonIgnore
    public Mode mode() {
        return mode;
    }

    @JsonIgnore
    public PaymentLinkStatus status() {
        return status;
    }

    /**
     * The partner's Moov account ID.
     */
    @JsonIgnore
    public String partnerAccountID() {
        return partnerAccountID;
    }

    /**
     * The merchant's Moov account ID.
     */
    @JsonIgnore
    public String merchantAccountID() {
        return merchantAccountID;
    }

    /**
     * The merchant's preferred payment method ID. Must be a wallet payment method.
     */
    @JsonIgnore
    public String merchantPaymentMethodID() {
        return merchantPaymentMethodID;
    }

    /**
     * Link to the payment landing page for this payment link.
     */
    @JsonIgnore
    public String link() {
        return link;
    }

    @JsonIgnore
    public Amount amount() {
        return amount;
    }

    /**
     * The number of times this payment link has been used.
     */
    @JsonIgnore
    public long uses() {
        return uses;
    }

    /**
     * An optional limit on the number of times this payment link can be used. 
     * 
     * <p>**For payouts, `maxUses` is always 1.**
     */
    @JsonIgnore
    public Optional<Long> maxUses() {
        return maxUses;
    }

    /**
     * The timestamp when this payment link was last used.
     */
    @JsonIgnore
    public Optional<OffsetDateTime> lastUsedOn() {
        return lastUsedOn;
    }

    /**
     * An optional expiration date for this payment link.
     */
    @JsonIgnore
    public Optional<OffsetDateTime> expiresOn() {
        return expiresOn;
    }

    /**
     * Customizable display options for a payment link.
     */
    @JsonIgnore
    public PaymentLinkDisplayOptions display() {
        return display;
    }

    @JsonIgnore
    public PaymentLinkCustomerOptions customer() {
        return customer;
    }

    /**
     * Options for payment links used to collect payment.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<PaymentLinkPaymentDetails> payment() {
        return (Optional<PaymentLinkPaymentDetails>) payment;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<PaymentLinkPayoutDetails> payout() {
        return (Optional<PaymentLinkPayoutDetails>) payout;
    }

    @JsonIgnore
    public OffsetDateTime createdOn() {
        return createdOn;
    }

    @JsonIgnore
    public OffsetDateTime updatedOn() {
        return updatedOn;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> disabledOn() {
        return disabledOn;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique code identifying this payment link.
     */
    public PaymentLink withCode(String code) {
        Utils.checkNotNull(code, "code");
        this.code = code;
        return this;
    }

    /**
     * The operating mode for an account.
     */
    public PaymentLink withMode(Mode mode) {
        Utils.checkNotNull(mode, "mode");
        this.mode = mode;
        return this;
    }

    public PaymentLink withStatus(PaymentLinkStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * The partner's Moov account ID.
     */
    public PaymentLink withPartnerAccountID(String partnerAccountID) {
        Utils.checkNotNull(partnerAccountID, "partnerAccountID");
        this.partnerAccountID = partnerAccountID;
        return this;
    }

    /**
     * The merchant's Moov account ID.
     */
    public PaymentLink withMerchantAccountID(String merchantAccountID) {
        Utils.checkNotNull(merchantAccountID, "merchantAccountID");
        this.merchantAccountID = merchantAccountID;
        return this;
    }

    /**
     * The merchant's preferred payment method ID. Must be a wallet payment method.
     */
    public PaymentLink withMerchantPaymentMethodID(String merchantPaymentMethodID) {
        Utils.checkNotNull(merchantPaymentMethodID, "merchantPaymentMethodID");
        this.merchantPaymentMethodID = merchantPaymentMethodID;
        return this;
    }

    /**
     * Link to the payment landing page for this payment link.
     */
    public PaymentLink withLink(String link) {
        Utils.checkNotNull(link, "link");
        this.link = link;
        return this;
    }

    public PaymentLink withAmount(Amount amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    /**
     * The number of times this payment link has been used.
     */
    public PaymentLink withUses(long uses) {
        Utils.checkNotNull(uses, "uses");
        this.uses = uses;
        return this;
    }

    /**
     * An optional limit on the number of times this payment link can be used. 
     * 
     * <p>**For payouts, `maxUses` is always 1.**
     */
    public PaymentLink withMaxUses(long maxUses) {
        Utils.checkNotNull(maxUses, "maxUses");
        this.maxUses = Optional.ofNullable(maxUses);
        return this;
    }


    /**
     * An optional limit on the number of times this payment link can be used. 
     * 
     * <p>**For payouts, `maxUses` is always 1.**
     */
    public PaymentLink withMaxUses(Optional<Long> maxUses) {
        Utils.checkNotNull(maxUses, "maxUses");
        this.maxUses = maxUses;
        return this;
    }

    /**
     * The timestamp when this payment link was last used.
     */
    public PaymentLink withLastUsedOn(OffsetDateTime lastUsedOn) {
        Utils.checkNotNull(lastUsedOn, "lastUsedOn");
        this.lastUsedOn = Optional.ofNullable(lastUsedOn);
        return this;
    }


    /**
     * The timestamp when this payment link was last used.
     */
    public PaymentLink withLastUsedOn(Optional<OffsetDateTime> lastUsedOn) {
        Utils.checkNotNull(lastUsedOn, "lastUsedOn");
        this.lastUsedOn = lastUsedOn;
        return this;
    }

    /**
     * An optional expiration date for this payment link.
     */
    public PaymentLink withExpiresOn(OffsetDateTime expiresOn) {
        Utils.checkNotNull(expiresOn, "expiresOn");
        this.expiresOn = Optional.ofNullable(expiresOn);
        return this;
    }


    /**
     * An optional expiration date for this payment link.
     */
    public PaymentLink withExpiresOn(Optional<OffsetDateTime> expiresOn) {
        Utils.checkNotNull(expiresOn, "expiresOn");
        this.expiresOn = expiresOn;
        return this;
    }

    /**
     * Customizable display options for a payment link.
     */
    public PaymentLink withDisplay(PaymentLinkDisplayOptions display) {
        Utils.checkNotNull(display, "display");
        this.display = display;
        return this;
    }

    public PaymentLink withCustomer(PaymentLinkCustomerOptions customer) {
        Utils.checkNotNull(customer, "customer");
        this.customer = customer;
        return this;
    }

    /**
     * Options for payment links used to collect payment.
     */
    public PaymentLink withPayment(PaymentLinkPaymentDetails payment) {
        Utils.checkNotNull(payment, "payment");
        this.payment = Optional.ofNullable(payment);
        return this;
    }


    /**
     * Options for payment links used to collect payment.
     */
    public PaymentLink withPayment(Optional<? extends PaymentLinkPaymentDetails> payment) {
        Utils.checkNotNull(payment, "payment");
        this.payment = payment;
        return this;
    }

    public PaymentLink withPayout(PaymentLinkPayoutDetails payout) {
        Utils.checkNotNull(payout, "payout");
        this.payout = Optional.ofNullable(payout);
        return this;
    }


    public PaymentLink withPayout(Optional<? extends PaymentLinkPayoutDetails> payout) {
        Utils.checkNotNull(payout, "payout");
        this.payout = payout;
        return this;
    }

    public PaymentLink withCreatedOn(OffsetDateTime createdOn) {
        Utils.checkNotNull(createdOn, "createdOn");
        this.createdOn = createdOn;
        return this;
    }

    public PaymentLink withUpdatedOn(OffsetDateTime updatedOn) {
        Utils.checkNotNull(updatedOn, "updatedOn");
        this.updatedOn = updatedOn;
        return this;
    }

    public PaymentLink withDisabledOn(OffsetDateTime disabledOn) {
        Utils.checkNotNull(disabledOn, "disabledOn");
        this.disabledOn = Optional.ofNullable(disabledOn);
        return this;
    }


    public PaymentLink withDisabledOn(Optional<OffsetDateTime> disabledOn) {
        Utils.checkNotNull(disabledOn, "disabledOn");
        this.disabledOn = disabledOn;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PaymentLink other = (PaymentLink) o;
        return 
            Utils.enhancedDeepEquals(this.code, other.code) &&
            Utils.enhancedDeepEquals(this.mode, other.mode) &&
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.partnerAccountID, other.partnerAccountID) &&
            Utils.enhancedDeepEquals(this.merchantAccountID, other.merchantAccountID) &&
            Utils.enhancedDeepEquals(this.merchantPaymentMethodID, other.merchantPaymentMethodID) &&
            Utils.enhancedDeepEquals(this.link, other.link) &&
            Utils.enhancedDeepEquals(this.amount, other.amount) &&
            Utils.enhancedDeepEquals(this.uses, other.uses) &&
            Utils.enhancedDeepEquals(this.maxUses, other.maxUses) &&
            Utils.enhancedDeepEquals(this.lastUsedOn, other.lastUsedOn) &&
            Utils.enhancedDeepEquals(this.expiresOn, other.expiresOn) &&
            Utils.enhancedDeepEquals(this.display, other.display) &&
            Utils.enhancedDeepEquals(this.customer, other.customer) &&
            Utils.enhancedDeepEquals(this.payment, other.payment) &&
            Utils.enhancedDeepEquals(this.payout, other.payout) &&
            Utils.enhancedDeepEquals(this.createdOn, other.createdOn) &&
            Utils.enhancedDeepEquals(this.updatedOn, other.updatedOn) &&
            Utils.enhancedDeepEquals(this.disabledOn, other.disabledOn);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            code, mode, status,
            partnerAccountID, merchantAccountID, merchantPaymentMethodID,
            link, amount, uses,
            maxUses, lastUsedOn, expiresOn,
            display, customer, payment,
            payout, createdOn, updatedOn,
            disabledOn);
    }
    
    @Override
    public String toString() {
        return Utils.toString(PaymentLink.class,
                "code", code,
                "mode", mode,
                "status", status,
                "partnerAccountID", partnerAccountID,
                "merchantAccountID", merchantAccountID,
                "merchantPaymentMethodID", merchantPaymentMethodID,
                "link", link,
                "amount", amount,
                "uses", uses,
                "maxUses", maxUses,
                "lastUsedOn", lastUsedOn,
                "expiresOn", expiresOn,
                "display", display,
                "customer", customer,
                "payment", payment,
                "payout", payout,
                "createdOn", createdOn,
                "updatedOn", updatedOn,
                "disabledOn", disabledOn);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String code;

        private Mode mode;

        private PaymentLinkStatus status;

        private String partnerAccountID;

        private String merchantAccountID;

        private String merchantPaymentMethodID;

        private String link;

        private Amount amount;

        private Long uses;

        private Optional<Long> maxUses = Optional.empty();

        private Optional<OffsetDateTime> lastUsedOn = Optional.empty();

        private Optional<OffsetDateTime> expiresOn = Optional.empty();

        private PaymentLinkDisplayOptions display;

        private PaymentLinkCustomerOptions customer;

        private Optional<? extends PaymentLinkPaymentDetails> payment = Optional.empty();

        private Optional<? extends PaymentLinkPayoutDetails> payout = Optional.empty();

        private OffsetDateTime createdOn;

        private OffsetDateTime updatedOn;

        private Optional<OffsetDateTime> disabledOn = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique code identifying this payment link.
         */
        public Builder code(String code) {
            Utils.checkNotNull(code, "code");
            this.code = code;
            return this;
        }


        /**
         * The operating mode for an account.
         */
        public Builder mode(Mode mode) {
            Utils.checkNotNull(mode, "mode");
            this.mode = mode;
            return this;
        }


        public Builder status(PaymentLinkStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        /**
         * The partner's Moov account ID.
         */
        public Builder partnerAccountID(String partnerAccountID) {
            Utils.checkNotNull(partnerAccountID, "partnerAccountID");
            this.partnerAccountID = partnerAccountID;
            return this;
        }


        /**
         * The merchant's Moov account ID.
         */
        public Builder merchantAccountID(String merchantAccountID) {
            Utils.checkNotNull(merchantAccountID, "merchantAccountID");
            this.merchantAccountID = merchantAccountID;
            return this;
        }


        /**
         * The merchant's preferred payment method ID. Must be a wallet payment method.
         */
        public Builder merchantPaymentMethodID(String merchantPaymentMethodID) {
            Utils.checkNotNull(merchantPaymentMethodID, "merchantPaymentMethodID");
            this.merchantPaymentMethodID = merchantPaymentMethodID;
            return this;
        }


        /**
         * Link to the payment landing page for this payment link.
         */
        public Builder link(String link) {
            Utils.checkNotNull(link, "link");
            this.link = link;
            return this;
        }


        public Builder amount(Amount amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }


        /**
         * The number of times this payment link has been used.
         */
        public Builder uses(long uses) {
            Utils.checkNotNull(uses, "uses");
            this.uses = uses;
            return this;
        }


        /**
         * An optional limit on the number of times this payment link can be used. 
         * 
         * <p>**For payouts, `maxUses` is always 1.**
         */
        public Builder maxUses(long maxUses) {
            Utils.checkNotNull(maxUses, "maxUses");
            this.maxUses = Optional.ofNullable(maxUses);
            return this;
        }

        /**
         * An optional limit on the number of times this payment link can be used. 
         * 
         * <p>**For payouts, `maxUses` is always 1.**
         */
        public Builder maxUses(Optional<Long> maxUses) {
            Utils.checkNotNull(maxUses, "maxUses");
            this.maxUses = maxUses;
            return this;
        }


        /**
         * The timestamp when this payment link was last used.
         */
        public Builder lastUsedOn(OffsetDateTime lastUsedOn) {
            Utils.checkNotNull(lastUsedOn, "lastUsedOn");
            this.lastUsedOn = Optional.ofNullable(lastUsedOn);
            return this;
        }

        /**
         * The timestamp when this payment link was last used.
         */
        public Builder lastUsedOn(Optional<OffsetDateTime> lastUsedOn) {
            Utils.checkNotNull(lastUsedOn, "lastUsedOn");
            this.lastUsedOn = lastUsedOn;
            return this;
        }


        /**
         * An optional expiration date for this payment link.
         */
        public Builder expiresOn(OffsetDateTime expiresOn) {
            Utils.checkNotNull(expiresOn, "expiresOn");
            this.expiresOn = Optional.ofNullable(expiresOn);
            return this;
        }

        /**
         * An optional expiration date for this payment link.
         */
        public Builder expiresOn(Optional<OffsetDateTime> expiresOn) {
            Utils.checkNotNull(expiresOn, "expiresOn");
            this.expiresOn = expiresOn;
            return this;
        }


        /**
         * Customizable display options for a payment link.
         */
        public Builder display(PaymentLinkDisplayOptions display) {
            Utils.checkNotNull(display, "display");
            this.display = display;
            return this;
        }


        public Builder customer(PaymentLinkCustomerOptions customer) {
            Utils.checkNotNull(customer, "customer");
            this.customer = customer;
            return this;
        }


        /**
         * Options for payment links used to collect payment.
         */
        public Builder payment(PaymentLinkPaymentDetails payment) {
            Utils.checkNotNull(payment, "payment");
            this.payment = Optional.ofNullable(payment);
            return this;
        }

        /**
         * Options for payment links used to collect payment.
         */
        public Builder payment(Optional<? extends PaymentLinkPaymentDetails> payment) {
            Utils.checkNotNull(payment, "payment");
            this.payment = payment;
            return this;
        }


        public Builder payout(PaymentLinkPayoutDetails payout) {
            Utils.checkNotNull(payout, "payout");
            this.payout = Optional.ofNullable(payout);
            return this;
        }

        public Builder payout(Optional<? extends PaymentLinkPayoutDetails> payout) {
            Utils.checkNotNull(payout, "payout");
            this.payout = payout;
            return this;
        }


        public Builder createdOn(OffsetDateTime createdOn) {
            Utils.checkNotNull(createdOn, "createdOn");
            this.createdOn = createdOn;
            return this;
        }


        public Builder updatedOn(OffsetDateTime updatedOn) {
            Utils.checkNotNull(updatedOn, "updatedOn");
            this.updatedOn = updatedOn;
            return this;
        }


        public Builder disabledOn(OffsetDateTime disabledOn) {
            Utils.checkNotNull(disabledOn, "disabledOn");
            this.disabledOn = Optional.ofNullable(disabledOn);
            return this;
        }

        public Builder disabledOn(Optional<OffsetDateTime> disabledOn) {
            Utils.checkNotNull(disabledOn, "disabledOn");
            this.disabledOn = disabledOn;
            return this;
        }

        public PaymentLink build() {

            return new PaymentLink(
                code, mode, status,
                partnerAccountID, merchantAccountID, merchantPaymentMethodID,
                link, amount, uses,
                maxUses, lastUsedOn, expiresOn,
                display, customer, payment,
                payout, createdOn, updatedOn,
                disabledOn);
        }

    }
}
