/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;


public class PatchSweepConfig {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status")
    private JsonNullable<? extends Status> status;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("pushPaymentMethodID")
    private JsonNullable<? extends PushPaymentMethodID> pushPaymentMethodID;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("pullPaymentMethodID")
    private JsonNullable<? extends PullPaymentMethodID> pullPaymentMethodID;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("statementDescriptor")
    private JsonNullable<? extends StatementDescriptor> statementDescriptor;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("minimumBalance")
    private JsonNullable<String> minimumBalance;

    @JsonCreator
    public PatchSweepConfig(
            @JsonProperty("status") JsonNullable<? extends Status> status,
            @JsonProperty("pushPaymentMethodID") JsonNullable<? extends PushPaymentMethodID> pushPaymentMethodID,
            @JsonProperty("pullPaymentMethodID") JsonNullable<? extends PullPaymentMethodID> pullPaymentMethodID,
            @JsonProperty("statementDescriptor") JsonNullable<? extends StatementDescriptor> statementDescriptor,
            @JsonProperty("minimumBalance") JsonNullable<String> minimumBalance) {
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(pushPaymentMethodID, "pushPaymentMethodID");
        Utils.checkNotNull(pullPaymentMethodID, "pullPaymentMethodID");
        Utils.checkNotNull(statementDescriptor, "statementDescriptor");
        Utils.checkNotNull(minimumBalance, "minimumBalance");
        this.status = status;
        this.pushPaymentMethodID = pushPaymentMethodID;
        this.pullPaymentMethodID = pullPaymentMethodID;
        this.statementDescriptor = statementDescriptor;
        this.minimumBalance = minimumBalance;
    }
    
    public PatchSweepConfig() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined());
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Status> status() {
        return (JsonNullable<Status>) status;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<PushPaymentMethodID> pushPaymentMethodID() {
        return (JsonNullable<PushPaymentMethodID>) pushPaymentMethodID;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<PullPaymentMethodID> pullPaymentMethodID() {
        return (JsonNullable<PullPaymentMethodID>) pullPaymentMethodID;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<StatementDescriptor> statementDescriptor() {
        return (JsonNullable<StatementDescriptor>) statementDescriptor;
    }

    @JsonIgnore
    public JsonNullable<String> minimumBalance() {
        return minimumBalance;
    }

    public static Builder builder() {
        return new Builder();
    }


    public PatchSweepConfig withStatus(Status status) {
        Utils.checkNotNull(status, "status");
        this.status = JsonNullable.of(status);
        return this;
    }

    public PatchSweepConfig withStatus(JsonNullable<? extends Status> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public PatchSweepConfig withPushPaymentMethodID(PushPaymentMethodID pushPaymentMethodID) {
        Utils.checkNotNull(pushPaymentMethodID, "pushPaymentMethodID");
        this.pushPaymentMethodID = JsonNullable.of(pushPaymentMethodID);
        return this;
    }

    public PatchSweepConfig withPushPaymentMethodID(JsonNullable<? extends PushPaymentMethodID> pushPaymentMethodID) {
        Utils.checkNotNull(pushPaymentMethodID, "pushPaymentMethodID");
        this.pushPaymentMethodID = pushPaymentMethodID;
        return this;
    }

    public PatchSweepConfig withPullPaymentMethodID(PullPaymentMethodID pullPaymentMethodID) {
        Utils.checkNotNull(pullPaymentMethodID, "pullPaymentMethodID");
        this.pullPaymentMethodID = JsonNullable.of(pullPaymentMethodID);
        return this;
    }

    public PatchSweepConfig withPullPaymentMethodID(JsonNullable<? extends PullPaymentMethodID> pullPaymentMethodID) {
        Utils.checkNotNull(pullPaymentMethodID, "pullPaymentMethodID");
        this.pullPaymentMethodID = pullPaymentMethodID;
        return this;
    }

    public PatchSweepConfig withStatementDescriptor(StatementDescriptor statementDescriptor) {
        Utils.checkNotNull(statementDescriptor, "statementDescriptor");
        this.statementDescriptor = JsonNullable.of(statementDescriptor);
        return this;
    }

    public PatchSweepConfig withStatementDescriptor(JsonNullable<? extends StatementDescriptor> statementDescriptor) {
        Utils.checkNotNull(statementDescriptor, "statementDescriptor");
        this.statementDescriptor = statementDescriptor;
        return this;
    }

    public PatchSweepConfig withMinimumBalance(String minimumBalance) {
        Utils.checkNotNull(minimumBalance, "minimumBalance");
        this.minimumBalance = JsonNullable.of(minimumBalance);
        return this;
    }

    public PatchSweepConfig withMinimumBalance(JsonNullable<String> minimumBalance) {
        Utils.checkNotNull(minimumBalance, "minimumBalance");
        this.minimumBalance = minimumBalance;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PatchSweepConfig other = (PatchSweepConfig) o;
        return 
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.pushPaymentMethodID, other.pushPaymentMethodID) &&
            Utils.enhancedDeepEquals(this.pullPaymentMethodID, other.pullPaymentMethodID) &&
            Utils.enhancedDeepEquals(this.statementDescriptor, other.statementDescriptor) &&
            Utils.enhancedDeepEquals(this.minimumBalance, other.minimumBalance);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            status, pushPaymentMethodID, pullPaymentMethodID,
            statementDescriptor, minimumBalance);
    }
    
    @Override
    public String toString() {
        return Utils.toString(PatchSweepConfig.class,
                "status", status,
                "pushPaymentMethodID", pushPaymentMethodID,
                "pullPaymentMethodID", pullPaymentMethodID,
                "statementDescriptor", statementDescriptor,
                "minimumBalance", minimumBalance);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends Status> status = JsonNullable.undefined();

        private JsonNullable<? extends PushPaymentMethodID> pushPaymentMethodID = JsonNullable.undefined();

        private JsonNullable<? extends PullPaymentMethodID> pullPaymentMethodID = JsonNullable.undefined();

        private JsonNullable<? extends StatementDescriptor> statementDescriptor = JsonNullable.undefined();

        private JsonNullable<String> minimumBalance = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        public Builder status(Status status) {
            Utils.checkNotNull(status, "status");
            this.status = JsonNullable.of(status);
            return this;
        }

        public Builder status(JsonNullable<? extends Status> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        public Builder pushPaymentMethodID(PushPaymentMethodID pushPaymentMethodID) {
            Utils.checkNotNull(pushPaymentMethodID, "pushPaymentMethodID");
            this.pushPaymentMethodID = JsonNullable.of(pushPaymentMethodID);
            return this;
        }

        public Builder pushPaymentMethodID(JsonNullable<? extends PushPaymentMethodID> pushPaymentMethodID) {
            Utils.checkNotNull(pushPaymentMethodID, "pushPaymentMethodID");
            this.pushPaymentMethodID = pushPaymentMethodID;
            return this;
        }


        public Builder pullPaymentMethodID(PullPaymentMethodID pullPaymentMethodID) {
            Utils.checkNotNull(pullPaymentMethodID, "pullPaymentMethodID");
            this.pullPaymentMethodID = JsonNullable.of(pullPaymentMethodID);
            return this;
        }

        public Builder pullPaymentMethodID(JsonNullable<? extends PullPaymentMethodID> pullPaymentMethodID) {
            Utils.checkNotNull(pullPaymentMethodID, "pullPaymentMethodID");
            this.pullPaymentMethodID = pullPaymentMethodID;
            return this;
        }


        public Builder statementDescriptor(StatementDescriptor statementDescriptor) {
            Utils.checkNotNull(statementDescriptor, "statementDescriptor");
            this.statementDescriptor = JsonNullable.of(statementDescriptor);
            return this;
        }

        public Builder statementDescriptor(JsonNullable<? extends StatementDescriptor> statementDescriptor) {
            Utils.checkNotNull(statementDescriptor, "statementDescriptor");
            this.statementDescriptor = statementDescriptor;
            return this;
        }


        public Builder minimumBalance(String minimumBalance) {
            Utils.checkNotNull(minimumBalance, "minimumBalance");
            this.minimumBalance = JsonNullable.of(minimumBalance);
            return this;
        }

        public Builder minimumBalance(JsonNullable<String> minimumBalance) {
            Utils.checkNotNull(minimumBalance, "minimumBalance");
            this.minimumBalance = minimumBalance;
            return this;
        }

        public PatchSweepConfig build() {

            return new PatchSweepConfig(
                status, pushPaymentMethodID, pullPaymentMethodID,
                statementDescriptor, minimumBalance);
        }

    }
}
