/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;

/**
 * PatchIndividual
 * 
 * <p>Describes the fields available when patching an individual.
 */
public class PatchIndividual {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private Optional<? extends IndividualNameUpdate> name;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("phone")
    private Optional<? extends PhoneNumber> phone;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("email")
    private Optional<String> email;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("address")
    private Optional<? extends AddressUpdate> address;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("birthDate")
    private Optional<? extends BirthDateUpdate> birthDate;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("governmentID")
    private Optional<? extends GovernmentID> governmentID;

    @JsonCreator
    public PatchIndividual(
            @JsonProperty("name") Optional<? extends IndividualNameUpdate> name,
            @JsonProperty("phone") Optional<? extends PhoneNumber> phone,
            @JsonProperty("email") Optional<String> email,
            @JsonProperty("address") Optional<? extends AddressUpdate> address,
            @JsonProperty("birthDate") Optional<? extends BirthDateUpdate> birthDate,
            @JsonProperty("governmentID") Optional<? extends GovernmentID> governmentID) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(phone, "phone");
        Utils.checkNotNull(email, "email");
        Utils.checkNotNull(address, "address");
        Utils.checkNotNull(birthDate, "birthDate");
        Utils.checkNotNull(governmentID, "governmentID");
        this.name = name;
        this.phone = phone;
        this.email = email;
        this.address = address;
        this.birthDate = birthDate;
        this.governmentID = governmentID;
    }
    
    public PatchIndividual() {
        this(Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty(), Optional.empty(), Optional.empty());
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<IndividualNameUpdate> name() {
        return (Optional<IndividualNameUpdate>) name;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<PhoneNumber> phone() {
        return (Optional<PhoneNumber>) phone;
    }

    @JsonIgnore
    public Optional<String> email() {
        return email;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<AddressUpdate> address() {
        return (Optional<AddressUpdate>) address;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<BirthDateUpdate> birthDate() {
        return (Optional<BirthDateUpdate>) birthDate;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<GovernmentID> governmentID() {
        return (Optional<GovernmentID>) governmentID;
    }

    public static Builder builder() {
        return new Builder();
    }


    public PatchIndividual withName(IndividualNameUpdate name) {
        Utils.checkNotNull(name, "name");
        this.name = Optional.ofNullable(name);
        return this;
    }


    public PatchIndividual withName(Optional<? extends IndividualNameUpdate> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public PatchIndividual withPhone(PhoneNumber phone) {
        Utils.checkNotNull(phone, "phone");
        this.phone = Optional.ofNullable(phone);
        return this;
    }


    public PatchIndividual withPhone(Optional<? extends PhoneNumber> phone) {
        Utils.checkNotNull(phone, "phone");
        this.phone = phone;
        return this;
    }

    public PatchIndividual withEmail(String email) {
        Utils.checkNotNull(email, "email");
        this.email = Optional.ofNullable(email);
        return this;
    }


    public PatchIndividual withEmail(Optional<String> email) {
        Utils.checkNotNull(email, "email");
        this.email = email;
        return this;
    }

    public PatchIndividual withAddress(AddressUpdate address) {
        Utils.checkNotNull(address, "address");
        this.address = Optional.ofNullable(address);
        return this;
    }


    public PatchIndividual withAddress(Optional<? extends AddressUpdate> address) {
        Utils.checkNotNull(address, "address");
        this.address = address;
        return this;
    }

    public PatchIndividual withBirthDate(BirthDateUpdate birthDate) {
        Utils.checkNotNull(birthDate, "birthDate");
        this.birthDate = Optional.ofNullable(birthDate);
        return this;
    }


    public PatchIndividual withBirthDate(Optional<? extends BirthDateUpdate> birthDate) {
        Utils.checkNotNull(birthDate, "birthDate");
        this.birthDate = birthDate;
        return this;
    }

    public PatchIndividual withGovernmentID(GovernmentID governmentID) {
        Utils.checkNotNull(governmentID, "governmentID");
        this.governmentID = Optional.ofNullable(governmentID);
        return this;
    }


    public PatchIndividual withGovernmentID(Optional<? extends GovernmentID> governmentID) {
        Utils.checkNotNull(governmentID, "governmentID");
        this.governmentID = governmentID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PatchIndividual other = (PatchIndividual) o;
        return 
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.phone, other.phone) &&
            Utils.enhancedDeepEquals(this.email, other.email) &&
            Utils.enhancedDeepEquals(this.address, other.address) &&
            Utils.enhancedDeepEquals(this.birthDate, other.birthDate) &&
            Utils.enhancedDeepEquals(this.governmentID, other.governmentID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            name, phone, email,
            address, birthDate, governmentID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(PatchIndividual.class,
                "name", name,
                "phone", phone,
                "email", email,
                "address", address,
                "birthDate", birthDate,
                "governmentID", governmentID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<? extends IndividualNameUpdate> name = Optional.empty();

        private Optional<? extends PhoneNumber> phone = Optional.empty();

        private Optional<String> email = Optional.empty();

        private Optional<? extends AddressUpdate> address = Optional.empty();

        private Optional<? extends BirthDateUpdate> birthDate = Optional.empty();

        private Optional<? extends GovernmentID> governmentID = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder name(IndividualNameUpdate name) {
            Utils.checkNotNull(name, "name");
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Optional<? extends IndividualNameUpdate> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }


        public Builder phone(PhoneNumber phone) {
            Utils.checkNotNull(phone, "phone");
            this.phone = Optional.ofNullable(phone);
            return this;
        }

        public Builder phone(Optional<? extends PhoneNumber> phone) {
            Utils.checkNotNull(phone, "phone");
            this.phone = phone;
            return this;
        }


        public Builder email(String email) {
            Utils.checkNotNull(email, "email");
            this.email = Optional.ofNullable(email);
            return this;
        }

        public Builder email(Optional<String> email) {
            Utils.checkNotNull(email, "email");
            this.email = email;
            return this;
        }


        public Builder address(AddressUpdate address) {
            Utils.checkNotNull(address, "address");
            this.address = Optional.ofNullable(address);
            return this;
        }

        public Builder address(Optional<? extends AddressUpdate> address) {
            Utils.checkNotNull(address, "address");
            this.address = address;
            return this;
        }


        public Builder birthDate(BirthDateUpdate birthDate) {
            Utils.checkNotNull(birthDate, "birthDate");
            this.birthDate = Optional.ofNullable(birthDate);
            return this;
        }

        public Builder birthDate(Optional<? extends BirthDateUpdate> birthDate) {
            Utils.checkNotNull(birthDate, "birthDate");
            this.birthDate = birthDate;
            return this;
        }


        public Builder governmentID(GovernmentID governmentID) {
            Utils.checkNotNull(governmentID, "governmentID");
            this.governmentID = Optional.ofNullable(governmentID);
            return this;
        }

        public Builder governmentID(Optional<? extends GovernmentID> governmentID) {
            Utils.checkNotNull(governmentID, "governmentID");
            this.governmentID = governmentID;
            return this;
        }

        public PatchIndividual build() {

            return new PatchIndividual(
                name, phone, email,
                address, birthDate, governmentID);
        }

    }
}
