/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class PatchAccountError {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("profile")
    private Optional<? extends CreateProfileError> profile;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("metadata")
    private Optional<String> metadata;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("termsOfService")
    private Optional<? extends TermsOfServiceError> termsOfService;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("foreignID")
    private Optional<String> foreignID;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("customerSupport")
    private Optional<? extends CustomerSupportError> customerSupport;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("settings")
    private Optional<? extends CreateAccountSettings> settings;

    @JsonCreator
    public PatchAccountError(
            @JsonProperty("profile") Optional<? extends CreateProfileError> profile,
            @JsonProperty("metadata") Optional<String> metadata,
            @JsonProperty("termsOfService") Optional<? extends TermsOfServiceError> termsOfService,
            @JsonProperty("foreignID") Optional<String> foreignID,
            @JsonProperty("customerSupport") Optional<? extends CustomerSupportError> customerSupport,
            @JsonProperty("settings") Optional<? extends CreateAccountSettings> settings) {
        Utils.checkNotNull(profile, "profile");
        Utils.checkNotNull(metadata, "metadata");
        Utils.checkNotNull(termsOfService, "termsOfService");
        Utils.checkNotNull(foreignID, "foreignID");
        Utils.checkNotNull(customerSupport, "customerSupport");
        Utils.checkNotNull(settings, "settings");
        this.profile = profile;
        this.metadata = metadata;
        this.termsOfService = termsOfService;
        this.foreignID = foreignID;
        this.customerSupport = customerSupport;
        this.settings = settings;
    }
    
    public PatchAccountError() {
        this(Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty(), Optional.empty(), Optional.empty());
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CreateProfileError> profile() {
        return (Optional<CreateProfileError>) profile;
    }

    @JsonIgnore
    public Optional<String> metadata() {
        return metadata;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<TermsOfServiceError> termsOfService() {
        return (Optional<TermsOfServiceError>) termsOfService;
    }

    @JsonIgnore
    public Optional<String> foreignID() {
        return foreignID;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CustomerSupportError> customerSupport() {
        return (Optional<CustomerSupportError>) customerSupport;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CreateAccountSettings> settings() {
        return (Optional<CreateAccountSettings>) settings;
    }

    public static Builder builder() {
        return new Builder();
    }


    public PatchAccountError withProfile(CreateProfileError profile) {
        Utils.checkNotNull(profile, "profile");
        this.profile = Optional.ofNullable(profile);
        return this;
    }


    public PatchAccountError withProfile(Optional<? extends CreateProfileError> profile) {
        Utils.checkNotNull(profile, "profile");
        this.profile = profile;
        return this;
    }

    public PatchAccountError withMetadata(String metadata) {
        Utils.checkNotNull(metadata, "metadata");
        this.metadata = Optional.ofNullable(metadata);
        return this;
    }


    public PatchAccountError withMetadata(Optional<String> metadata) {
        Utils.checkNotNull(metadata, "metadata");
        this.metadata = metadata;
        return this;
    }

    public PatchAccountError withTermsOfService(TermsOfServiceError termsOfService) {
        Utils.checkNotNull(termsOfService, "termsOfService");
        this.termsOfService = Optional.ofNullable(termsOfService);
        return this;
    }


    public PatchAccountError withTermsOfService(Optional<? extends TermsOfServiceError> termsOfService) {
        Utils.checkNotNull(termsOfService, "termsOfService");
        this.termsOfService = termsOfService;
        return this;
    }

    public PatchAccountError withForeignID(String foreignID) {
        Utils.checkNotNull(foreignID, "foreignID");
        this.foreignID = Optional.ofNullable(foreignID);
        return this;
    }


    public PatchAccountError withForeignID(Optional<String> foreignID) {
        Utils.checkNotNull(foreignID, "foreignID");
        this.foreignID = foreignID;
        return this;
    }

    public PatchAccountError withCustomerSupport(CustomerSupportError customerSupport) {
        Utils.checkNotNull(customerSupport, "customerSupport");
        this.customerSupport = Optional.ofNullable(customerSupport);
        return this;
    }


    public PatchAccountError withCustomerSupport(Optional<? extends CustomerSupportError> customerSupport) {
        Utils.checkNotNull(customerSupport, "customerSupport");
        this.customerSupport = customerSupport;
        return this;
    }

    public PatchAccountError withSettings(CreateAccountSettings settings) {
        Utils.checkNotNull(settings, "settings");
        this.settings = Optional.ofNullable(settings);
        return this;
    }


    public PatchAccountError withSettings(Optional<? extends CreateAccountSettings> settings) {
        Utils.checkNotNull(settings, "settings");
        this.settings = settings;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PatchAccountError other = (PatchAccountError) o;
        return 
            Utils.enhancedDeepEquals(this.profile, other.profile) &&
            Utils.enhancedDeepEquals(this.metadata, other.metadata) &&
            Utils.enhancedDeepEquals(this.termsOfService, other.termsOfService) &&
            Utils.enhancedDeepEquals(this.foreignID, other.foreignID) &&
            Utils.enhancedDeepEquals(this.customerSupport, other.customerSupport) &&
            Utils.enhancedDeepEquals(this.settings, other.settings);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            profile, metadata, termsOfService,
            foreignID, customerSupport, settings);
    }
    
    @Override
    public String toString() {
        return Utils.toString(PatchAccountError.class,
                "profile", profile,
                "metadata", metadata,
                "termsOfService", termsOfService,
                "foreignID", foreignID,
                "customerSupport", customerSupport,
                "settings", settings);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<? extends CreateProfileError> profile = Optional.empty();

        private Optional<String> metadata = Optional.empty();

        private Optional<? extends TermsOfServiceError> termsOfService = Optional.empty();

        private Optional<String> foreignID = Optional.empty();

        private Optional<? extends CustomerSupportError> customerSupport = Optional.empty();

        private Optional<? extends CreateAccountSettings> settings = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder profile(CreateProfileError profile) {
            Utils.checkNotNull(profile, "profile");
            this.profile = Optional.ofNullable(profile);
            return this;
        }

        public Builder profile(Optional<? extends CreateProfileError> profile) {
            Utils.checkNotNull(profile, "profile");
            this.profile = profile;
            return this;
        }


        public Builder metadata(String metadata) {
            Utils.checkNotNull(metadata, "metadata");
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        public Builder metadata(Optional<String> metadata) {
            Utils.checkNotNull(metadata, "metadata");
            this.metadata = metadata;
            return this;
        }


        public Builder termsOfService(TermsOfServiceError termsOfService) {
            Utils.checkNotNull(termsOfService, "termsOfService");
            this.termsOfService = Optional.ofNullable(termsOfService);
            return this;
        }

        public Builder termsOfService(Optional<? extends TermsOfServiceError> termsOfService) {
            Utils.checkNotNull(termsOfService, "termsOfService");
            this.termsOfService = termsOfService;
            return this;
        }


        public Builder foreignID(String foreignID) {
            Utils.checkNotNull(foreignID, "foreignID");
            this.foreignID = Optional.ofNullable(foreignID);
            return this;
        }

        public Builder foreignID(Optional<String> foreignID) {
            Utils.checkNotNull(foreignID, "foreignID");
            this.foreignID = foreignID;
            return this;
        }


        public Builder customerSupport(CustomerSupportError customerSupport) {
            Utils.checkNotNull(customerSupport, "customerSupport");
            this.customerSupport = Optional.ofNullable(customerSupport);
            return this;
        }

        public Builder customerSupport(Optional<? extends CustomerSupportError> customerSupport) {
            Utils.checkNotNull(customerSupport, "customerSupport");
            this.customerSupport = customerSupport;
            return this;
        }


        public Builder settings(CreateAccountSettings settings) {
            Utils.checkNotNull(settings, "settings");
            this.settings = Optional.ofNullable(settings);
            return this;
        }

        public Builder settings(Optional<? extends CreateAccountSettings> settings) {
            Utils.checkNotNull(settings, "settings");
            this.settings = settings;
            return this;
        }

        public PatchAccountError build() {

            return new PatchAccountError(
                profile, metadata, termsOfService,
                foreignID, customerSupport, settings);
        }

    }
}
