/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;

/**
 * MoovFeeDetails
 * 
 * <p>Processing and pass-through costs that add up to the moovFee.
 */
public class MoovFeeDetails {
    /**
     * Card scheme fees accrued during authorization and settlement. String type represents dollars with up to 9 decimal place precision.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cardScheme")
    private Optional<String> cardScheme;

    /**
     * Network interchange fee for Visa, Mastercard, or Discover. String type represents dollars with up to 9 decimal place precision.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("interchange")
    private Optional<String> interchange;

    /**
     * Network discount fee for American Express. String type represents dollars with up to 9 decimal place precision.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("discount")
    private Optional<String> discount;

    /**
     * Moov processing fee. String type represents dollars with up to 9 decimal place precision.
     */
    @JsonProperty("moovProcessing")
    private String moovProcessing;

    @JsonCreator
    public MoovFeeDetails(
            @JsonProperty("cardScheme") Optional<String> cardScheme,
            @JsonProperty("interchange") Optional<String> interchange,
            @JsonProperty("discount") Optional<String> discount,
            @JsonProperty("moovProcessing") String moovProcessing) {
        Utils.checkNotNull(cardScheme, "cardScheme");
        Utils.checkNotNull(interchange, "interchange");
        Utils.checkNotNull(discount, "discount");
        Utils.checkNotNull(moovProcessing, "moovProcessing");
        this.cardScheme = cardScheme;
        this.interchange = interchange;
        this.discount = discount;
        this.moovProcessing = moovProcessing;
    }
    
    public MoovFeeDetails(
            String moovProcessing) {
        this(Optional.empty(), Optional.empty(), Optional.empty(),
            moovProcessing);
    }

    /**
     * Card scheme fees accrued during authorization and settlement. String type represents dollars with up to 9 decimal place precision.
     */
    @JsonIgnore
    public Optional<String> cardScheme() {
        return cardScheme;
    }

    /**
     * Network interchange fee for Visa, Mastercard, or Discover. String type represents dollars with up to 9 decimal place precision.
     */
    @JsonIgnore
    public Optional<String> interchange() {
        return interchange;
    }

    /**
     * Network discount fee for American Express. String type represents dollars with up to 9 decimal place precision.
     */
    @JsonIgnore
    public Optional<String> discount() {
        return discount;
    }

    /**
     * Moov processing fee. String type represents dollars with up to 9 decimal place precision.
     */
    @JsonIgnore
    public String moovProcessing() {
        return moovProcessing;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Card scheme fees accrued during authorization and settlement. String type represents dollars with up to 9 decimal place precision.
     */
    public MoovFeeDetails withCardScheme(String cardScheme) {
        Utils.checkNotNull(cardScheme, "cardScheme");
        this.cardScheme = Optional.ofNullable(cardScheme);
        return this;
    }


    /**
     * Card scheme fees accrued during authorization and settlement. String type represents dollars with up to 9 decimal place precision.
     */
    public MoovFeeDetails withCardScheme(Optional<String> cardScheme) {
        Utils.checkNotNull(cardScheme, "cardScheme");
        this.cardScheme = cardScheme;
        return this;
    }

    /**
     * Network interchange fee for Visa, Mastercard, or Discover. String type represents dollars with up to 9 decimal place precision.
     */
    public MoovFeeDetails withInterchange(String interchange) {
        Utils.checkNotNull(interchange, "interchange");
        this.interchange = Optional.ofNullable(interchange);
        return this;
    }


    /**
     * Network interchange fee for Visa, Mastercard, or Discover. String type represents dollars with up to 9 decimal place precision.
     */
    public MoovFeeDetails withInterchange(Optional<String> interchange) {
        Utils.checkNotNull(interchange, "interchange");
        this.interchange = interchange;
        return this;
    }

    /**
     * Network discount fee for American Express. String type represents dollars with up to 9 decimal place precision.
     */
    public MoovFeeDetails withDiscount(String discount) {
        Utils.checkNotNull(discount, "discount");
        this.discount = Optional.ofNullable(discount);
        return this;
    }


    /**
     * Network discount fee for American Express. String type represents dollars with up to 9 decimal place precision.
     */
    public MoovFeeDetails withDiscount(Optional<String> discount) {
        Utils.checkNotNull(discount, "discount");
        this.discount = discount;
        return this;
    }

    /**
     * Moov processing fee. String type represents dollars with up to 9 decimal place precision.
     */
    public MoovFeeDetails withMoovProcessing(String moovProcessing) {
        Utils.checkNotNull(moovProcessing, "moovProcessing");
        this.moovProcessing = moovProcessing;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MoovFeeDetails other = (MoovFeeDetails) o;
        return 
            Utils.enhancedDeepEquals(this.cardScheme, other.cardScheme) &&
            Utils.enhancedDeepEquals(this.interchange, other.interchange) &&
            Utils.enhancedDeepEquals(this.discount, other.discount) &&
            Utils.enhancedDeepEquals(this.moovProcessing, other.moovProcessing);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            cardScheme, interchange, discount,
            moovProcessing);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MoovFeeDetails.class,
                "cardScheme", cardScheme,
                "interchange", interchange,
                "discount", discount,
                "moovProcessing", moovProcessing);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> cardScheme = Optional.empty();

        private Optional<String> interchange = Optional.empty();

        private Optional<String> discount = Optional.empty();

        private String moovProcessing;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Card scheme fees accrued during authorization and settlement. String type represents dollars with up to 9 decimal place precision.
         */
        public Builder cardScheme(String cardScheme) {
            Utils.checkNotNull(cardScheme, "cardScheme");
            this.cardScheme = Optional.ofNullable(cardScheme);
            return this;
        }

        /**
         * Card scheme fees accrued during authorization and settlement. String type represents dollars with up to 9 decimal place precision.
         */
        public Builder cardScheme(Optional<String> cardScheme) {
            Utils.checkNotNull(cardScheme, "cardScheme");
            this.cardScheme = cardScheme;
            return this;
        }


        /**
         * Network interchange fee for Visa, Mastercard, or Discover. String type represents dollars with up to 9 decimal place precision.
         */
        public Builder interchange(String interchange) {
            Utils.checkNotNull(interchange, "interchange");
            this.interchange = Optional.ofNullable(interchange);
            return this;
        }

        /**
         * Network interchange fee for Visa, Mastercard, or Discover. String type represents dollars with up to 9 decimal place precision.
         */
        public Builder interchange(Optional<String> interchange) {
            Utils.checkNotNull(interchange, "interchange");
            this.interchange = interchange;
            return this;
        }


        /**
         * Network discount fee for American Express. String type represents dollars with up to 9 decimal place precision.
         */
        public Builder discount(String discount) {
            Utils.checkNotNull(discount, "discount");
            this.discount = Optional.ofNullable(discount);
            return this;
        }

        /**
         * Network discount fee for American Express. String type represents dollars with up to 9 decimal place precision.
         */
        public Builder discount(Optional<String> discount) {
            Utils.checkNotNull(discount, "discount");
            this.discount = discount;
            return this;
        }


        /**
         * Moov processing fee. String type represents dollars with up to 9 decimal place precision.
         */
        public Builder moovProcessing(String moovProcessing) {
            Utils.checkNotNull(moovProcessing, "moovProcessing");
            this.moovProcessing = moovProcessing;
            return this;
        }

        public MoovFeeDetails build() {

            return new MoovFeeDetails(
                cardScheme, interchange, discount,
                moovProcessing);
        }

    }
}
