/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.List;

/**
 * MoovFee
 * 
 * <p>Moov fee charged to an account involved in a transfer.
 */
public class MoovFee {
    /**
     * ID of the account that fees were charged to.
     */
    @JsonProperty("accountID")
    private String accountID;

    /**
     * Indicates whether the account charged was the partner, source, or destination of the transfer.
     */
    @JsonProperty("transferParty")
    private TransferParty transferParty;

    /**
     * The total amount of fees charged to the account.
     */
    @JsonProperty("totalAmount")
    private AmountDecimal totalAmount;

    /**
     * List of fee IDs that sum to the totalAmount.
     */
    @JsonProperty("feeIDs")
    private List<String> feeIDs;

    @JsonCreator
    public MoovFee(
            @JsonProperty("accountID") String accountID,
            @JsonProperty("transferParty") TransferParty transferParty,
            @JsonProperty("totalAmount") AmountDecimal totalAmount,
            @JsonProperty("feeIDs") List<String> feeIDs) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(transferParty, "transferParty");
        Utils.checkNotNull(totalAmount, "totalAmount");
        Utils.checkNotNull(feeIDs, "feeIDs");
        this.accountID = accountID;
        this.transferParty = transferParty;
        this.totalAmount = totalAmount;
        this.feeIDs = feeIDs;
    }

    /**
     * ID of the account that fees were charged to.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    /**
     * Indicates whether the account charged was the partner, source, or destination of the transfer.
     */
    @JsonIgnore
    public TransferParty transferParty() {
        return transferParty;
    }

    /**
     * The total amount of fees charged to the account.
     */
    @JsonIgnore
    public AmountDecimal totalAmount() {
        return totalAmount;
    }

    /**
     * List of fee IDs that sum to the totalAmount.
     */
    @JsonIgnore
    public List<String> feeIDs() {
        return feeIDs;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * ID of the account that fees were charged to.
     */
    public MoovFee withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    /**
     * Indicates whether the account charged was the partner, source, or destination of the transfer.
     */
    public MoovFee withTransferParty(TransferParty transferParty) {
        Utils.checkNotNull(transferParty, "transferParty");
        this.transferParty = transferParty;
        return this;
    }

    /**
     * The total amount of fees charged to the account.
     */
    public MoovFee withTotalAmount(AmountDecimal totalAmount) {
        Utils.checkNotNull(totalAmount, "totalAmount");
        this.totalAmount = totalAmount;
        return this;
    }

    /**
     * List of fee IDs that sum to the totalAmount.
     */
    public MoovFee withFeeIDs(List<String> feeIDs) {
        Utils.checkNotNull(feeIDs, "feeIDs");
        this.feeIDs = feeIDs;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MoovFee other = (MoovFee) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.transferParty, other.transferParty) &&
            Utils.enhancedDeepEquals(this.totalAmount, other.totalAmount) &&
            Utils.enhancedDeepEquals(this.feeIDs, other.feeIDs);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, transferParty, totalAmount,
            feeIDs);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MoovFee.class,
                "accountID", accountID,
                "transferParty", transferParty,
                "totalAmount", totalAmount,
                "feeIDs", feeIDs);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private TransferParty transferParty;

        private AmountDecimal totalAmount;

        private List<String> feeIDs;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * ID of the account that fees were charged to.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        /**
         * Indicates whether the account charged was the partner, source, or destination of the transfer.
         */
        public Builder transferParty(TransferParty transferParty) {
            Utils.checkNotNull(transferParty, "transferParty");
            this.transferParty = transferParty;
            return this;
        }


        /**
         * The total amount of fees charged to the account.
         */
        public Builder totalAmount(AmountDecimal totalAmount) {
            Utils.checkNotNull(totalAmount, "totalAmount");
            this.totalAmount = totalAmount;
            return this;
        }


        /**
         * List of fee IDs that sum to the totalAmount.
         */
        public Builder feeIDs(List<String> feeIDs) {
            Utils.checkNotNull(feeIDs, "feeIDs");
            this.feeIDs = feeIDs;
            return this;
        }

        public MoovFee build() {

            return new MoovFee(
                accountID, transferParty, totalAmount,
                feeIDs);
        }

    }
}
