/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;

/**
 * MinimumCommitment
 * 
 * <p>The minimum spending amount that must be met in the billing period. If actual usage is below the minimum amount, account is charged the difference.
 */
public class MinimumCommitment {
    /**
     * A 3-letter ISO 4217 currency code.
     */
    @JsonProperty("currency")
    private String currency;

    /**
     * A decimal-formatted numerical string that represents up to 9 decimal place precision. 
     * 
     * <p>For example, $12.987654321 is '12.987654321'.
     */
    @JsonProperty("valueDecimal")
    private String valueDecimal;

    @JsonCreator
    public MinimumCommitment(
            @JsonProperty("currency") String currency,
            @JsonProperty("valueDecimal") String valueDecimal) {
        Utils.checkNotNull(currency, "currency");
        Utils.checkNotNull(valueDecimal, "valueDecimal");
        this.currency = currency;
        this.valueDecimal = valueDecimal;
    }

    /**
     * A 3-letter ISO 4217 currency code.
     */
    @JsonIgnore
    public String currency() {
        return currency;
    }

    /**
     * A decimal-formatted numerical string that represents up to 9 decimal place precision. 
     * 
     * <p>For example, $12.987654321 is '12.987654321'.
     */
    @JsonIgnore
    public String valueDecimal() {
        return valueDecimal;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * A 3-letter ISO 4217 currency code.
     */
    public MinimumCommitment withCurrency(String currency) {
        Utils.checkNotNull(currency, "currency");
        this.currency = currency;
        return this;
    }

    /**
     * A decimal-formatted numerical string that represents up to 9 decimal place precision. 
     * 
     * <p>For example, $12.987654321 is '12.987654321'.
     */
    public MinimumCommitment withValueDecimal(String valueDecimal) {
        Utils.checkNotNull(valueDecimal, "valueDecimal");
        this.valueDecimal = valueDecimal;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MinimumCommitment other = (MinimumCommitment) o;
        return 
            Utils.enhancedDeepEquals(this.currency, other.currency) &&
            Utils.enhancedDeepEquals(this.valueDecimal, other.valueDecimal);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            currency, valueDecimal);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MinimumCommitment.class,
                "currency", currency,
                "valueDecimal", valueDecimal);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String currency;

        private String valueDecimal;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * A 3-letter ISO 4217 currency code.
         */
        public Builder currency(String currency) {
            Utils.checkNotNull(currency, "currency");
            this.currency = currency;
            return this;
        }


        /**
         * A decimal-formatted numerical string that represents up to 9 decimal place precision. 
         * 
         * <p>For example, $12.987654321 is '12.987654321'.
         */
        public Builder valueDecimal(String valueDecimal) {
            Utils.checkNotNull(valueDecimal, "valueDecimal");
            this.valueDecimal = valueDecimal;
            return this;
        }

        public MinimumCommitment build() {

            return new MinimumCommitment(
                currency, valueDecimal);
        }

    }
}
