/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Optional;

/**
 * ManualTermsOfServiceUpdate
 * 
 * <p>Describes the acceptance of the Terms of Service. All data is required, and must be from the user.
 */
public class ManualTermsOfServiceUpdate {
    /**
     * The date and time the terms of service were accepted.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("acceptedDate")
    private Optional<OffsetDateTime> acceptedDate;

    /**
     * The IP address from which the terms of service were accepted.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("acceptedIP")
    private Optional<String> acceptedIP;

    /**
     * The user-agent of the user making the request.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("acceptedUserAgent")
    private Optional<String> acceptedUserAgent;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("acceptedDomain")
    private Optional<String> acceptedDomain;

    @JsonCreator
    public ManualTermsOfServiceUpdate(
            @JsonProperty("acceptedDate") Optional<OffsetDateTime> acceptedDate,
            @JsonProperty("acceptedIP") Optional<String> acceptedIP,
            @JsonProperty("acceptedUserAgent") Optional<String> acceptedUserAgent,
            @JsonProperty("acceptedDomain") Optional<String> acceptedDomain) {
        Utils.checkNotNull(acceptedDate, "acceptedDate");
        Utils.checkNotNull(acceptedIP, "acceptedIP");
        Utils.checkNotNull(acceptedUserAgent, "acceptedUserAgent");
        Utils.checkNotNull(acceptedDomain, "acceptedDomain");
        this.acceptedDate = acceptedDate;
        this.acceptedIP = acceptedIP;
        this.acceptedUserAgent = acceptedUserAgent;
        this.acceptedDomain = acceptedDomain;
    }
    
    public ManualTermsOfServiceUpdate() {
        this(Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty());
    }

    /**
     * The date and time the terms of service were accepted.
     */
    @JsonIgnore
    public Optional<OffsetDateTime> acceptedDate() {
        return acceptedDate;
    }

    /**
     * The IP address from which the terms of service were accepted.
     */
    @JsonIgnore
    public Optional<String> acceptedIP() {
        return acceptedIP;
    }

    /**
     * The user-agent of the user making the request.
     */
    @JsonIgnore
    public Optional<String> acceptedUserAgent() {
        return acceptedUserAgent;
    }

    @JsonIgnore
    public Optional<String> acceptedDomain() {
        return acceptedDomain;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The date and time the terms of service were accepted.
     */
    public ManualTermsOfServiceUpdate withAcceptedDate(OffsetDateTime acceptedDate) {
        Utils.checkNotNull(acceptedDate, "acceptedDate");
        this.acceptedDate = Optional.ofNullable(acceptedDate);
        return this;
    }


    /**
     * The date and time the terms of service were accepted.
     */
    public ManualTermsOfServiceUpdate withAcceptedDate(Optional<OffsetDateTime> acceptedDate) {
        Utils.checkNotNull(acceptedDate, "acceptedDate");
        this.acceptedDate = acceptedDate;
        return this;
    }

    /**
     * The IP address from which the terms of service were accepted.
     */
    public ManualTermsOfServiceUpdate withAcceptedIP(String acceptedIP) {
        Utils.checkNotNull(acceptedIP, "acceptedIP");
        this.acceptedIP = Optional.ofNullable(acceptedIP);
        return this;
    }


    /**
     * The IP address from which the terms of service were accepted.
     */
    public ManualTermsOfServiceUpdate withAcceptedIP(Optional<String> acceptedIP) {
        Utils.checkNotNull(acceptedIP, "acceptedIP");
        this.acceptedIP = acceptedIP;
        return this;
    }

    /**
     * The user-agent of the user making the request.
     */
    public ManualTermsOfServiceUpdate withAcceptedUserAgent(String acceptedUserAgent) {
        Utils.checkNotNull(acceptedUserAgent, "acceptedUserAgent");
        this.acceptedUserAgent = Optional.ofNullable(acceptedUserAgent);
        return this;
    }


    /**
     * The user-agent of the user making the request.
     */
    public ManualTermsOfServiceUpdate withAcceptedUserAgent(Optional<String> acceptedUserAgent) {
        Utils.checkNotNull(acceptedUserAgent, "acceptedUserAgent");
        this.acceptedUserAgent = acceptedUserAgent;
        return this;
    }

    public ManualTermsOfServiceUpdate withAcceptedDomain(String acceptedDomain) {
        Utils.checkNotNull(acceptedDomain, "acceptedDomain");
        this.acceptedDomain = Optional.ofNullable(acceptedDomain);
        return this;
    }


    public ManualTermsOfServiceUpdate withAcceptedDomain(Optional<String> acceptedDomain) {
        Utils.checkNotNull(acceptedDomain, "acceptedDomain");
        this.acceptedDomain = acceptedDomain;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ManualTermsOfServiceUpdate other = (ManualTermsOfServiceUpdate) o;
        return 
            Utils.enhancedDeepEquals(this.acceptedDate, other.acceptedDate) &&
            Utils.enhancedDeepEquals(this.acceptedIP, other.acceptedIP) &&
            Utils.enhancedDeepEquals(this.acceptedUserAgent, other.acceptedUserAgent) &&
            Utils.enhancedDeepEquals(this.acceptedDomain, other.acceptedDomain);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            acceptedDate, acceptedIP, acceptedUserAgent,
            acceptedDomain);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ManualTermsOfServiceUpdate.class,
                "acceptedDate", acceptedDate,
                "acceptedIP", acceptedIP,
                "acceptedUserAgent", acceptedUserAgent,
                "acceptedDomain", acceptedDomain);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<OffsetDateTime> acceptedDate = Optional.empty();

        private Optional<String> acceptedIP = Optional.empty();

        private Optional<String> acceptedUserAgent = Optional.empty();

        private Optional<String> acceptedDomain = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The date and time the terms of service were accepted.
         */
        public Builder acceptedDate(OffsetDateTime acceptedDate) {
            Utils.checkNotNull(acceptedDate, "acceptedDate");
            this.acceptedDate = Optional.ofNullable(acceptedDate);
            return this;
        }

        /**
         * The date and time the terms of service were accepted.
         */
        public Builder acceptedDate(Optional<OffsetDateTime> acceptedDate) {
            Utils.checkNotNull(acceptedDate, "acceptedDate");
            this.acceptedDate = acceptedDate;
            return this;
        }


        /**
         * The IP address from which the terms of service were accepted.
         */
        public Builder acceptedIP(String acceptedIP) {
            Utils.checkNotNull(acceptedIP, "acceptedIP");
            this.acceptedIP = Optional.ofNullable(acceptedIP);
            return this;
        }

        /**
         * The IP address from which the terms of service were accepted.
         */
        public Builder acceptedIP(Optional<String> acceptedIP) {
            Utils.checkNotNull(acceptedIP, "acceptedIP");
            this.acceptedIP = acceptedIP;
            return this;
        }


        /**
         * The user-agent of the user making the request.
         */
        public Builder acceptedUserAgent(String acceptedUserAgent) {
            Utils.checkNotNull(acceptedUserAgent, "acceptedUserAgent");
            this.acceptedUserAgent = Optional.ofNullable(acceptedUserAgent);
            return this;
        }

        /**
         * The user-agent of the user making the request.
         */
        public Builder acceptedUserAgent(Optional<String> acceptedUserAgent) {
            Utils.checkNotNull(acceptedUserAgent, "acceptedUserAgent");
            this.acceptedUserAgent = acceptedUserAgent;
            return this;
        }


        public Builder acceptedDomain(String acceptedDomain) {
            Utils.checkNotNull(acceptedDomain, "acceptedDomain");
            this.acceptedDomain = Optional.ofNullable(acceptedDomain);
            return this;
        }

        public Builder acceptedDomain(Optional<String> acceptedDomain) {
            Utils.checkNotNull(acceptedDomain, "acceptedDomain");
            this.acceptedDomain = acceptedDomain;
            return this;
        }

        public ManualTermsOfServiceUpdate build() {

            return new ManualTermsOfServiceUpdate(
                acceptedDate, acceptedIP, acceptedUserAgent,
                acceptedDomain);
        }

    }
}
