/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;

/**
 * ManualTermsOfService
 * 
 * <p>Describes the acceptance of the Terms of Service. All data is required, and must be from the user.
 */
public class ManualTermsOfService {
    /**
     * The date and time the terms of service were accepted.
     */
    @JsonProperty("acceptedDate")
    private OffsetDateTime acceptedDate;

    /**
     * The IP address from which the terms of service were accepted.
     */
    @JsonProperty("acceptedIP")
    private String acceptedIP;

    /**
     * The user-agent of the user making the request.
     */
    @JsonProperty("acceptedUserAgent")
    private String acceptedUserAgent;


    @JsonProperty("acceptedDomain")
    private String acceptedDomain;

    @JsonCreator
    public ManualTermsOfService(
            @JsonProperty("acceptedDate") OffsetDateTime acceptedDate,
            @JsonProperty("acceptedIP") String acceptedIP,
            @JsonProperty("acceptedUserAgent") String acceptedUserAgent,
            @JsonProperty("acceptedDomain") String acceptedDomain) {
        Utils.checkNotNull(acceptedDate, "acceptedDate");
        Utils.checkNotNull(acceptedIP, "acceptedIP");
        Utils.checkNotNull(acceptedUserAgent, "acceptedUserAgent");
        Utils.checkNotNull(acceptedDomain, "acceptedDomain");
        this.acceptedDate = acceptedDate;
        this.acceptedIP = acceptedIP;
        this.acceptedUserAgent = acceptedUserAgent;
        this.acceptedDomain = acceptedDomain;
    }

    /**
     * The date and time the terms of service were accepted.
     */
    @JsonIgnore
    public OffsetDateTime acceptedDate() {
        return acceptedDate;
    }

    /**
     * The IP address from which the terms of service were accepted.
     */
    @JsonIgnore
    public String acceptedIP() {
        return acceptedIP;
    }

    /**
     * The user-agent of the user making the request.
     */
    @JsonIgnore
    public String acceptedUserAgent() {
        return acceptedUserAgent;
    }

    @JsonIgnore
    public String acceptedDomain() {
        return acceptedDomain;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The date and time the terms of service were accepted.
     */
    public ManualTermsOfService withAcceptedDate(OffsetDateTime acceptedDate) {
        Utils.checkNotNull(acceptedDate, "acceptedDate");
        this.acceptedDate = acceptedDate;
        return this;
    }

    /**
     * The IP address from which the terms of service were accepted.
     */
    public ManualTermsOfService withAcceptedIP(String acceptedIP) {
        Utils.checkNotNull(acceptedIP, "acceptedIP");
        this.acceptedIP = acceptedIP;
        return this;
    }

    /**
     * The user-agent of the user making the request.
     */
    public ManualTermsOfService withAcceptedUserAgent(String acceptedUserAgent) {
        Utils.checkNotNull(acceptedUserAgent, "acceptedUserAgent");
        this.acceptedUserAgent = acceptedUserAgent;
        return this;
    }

    public ManualTermsOfService withAcceptedDomain(String acceptedDomain) {
        Utils.checkNotNull(acceptedDomain, "acceptedDomain");
        this.acceptedDomain = acceptedDomain;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ManualTermsOfService other = (ManualTermsOfService) o;
        return 
            Utils.enhancedDeepEquals(this.acceptedDate, other.acceptedDate) &&
            Utils.enhancedDeepEquals(this.acceptedIP, other.acceptedIP) &&
            Utils.enhancedDeepEquals(this.acceptedUserAgent, other.acceptedUserAgent) &&
            Utils.enhancedDeepEquals(this.acceptedDomain, other.acceptedDomain);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            acceptedDate, acceptedIP, acceptedUserAgent,
            acceptedDomain);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ManualTermsOfService.class,
                "acceptedDate", acceptedDate,
                "acceptedIP", acceptedIP,
                "acceptedUserAgent", acceptedUserAgent,
                "acceptedDomain", acceptedDomain);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private OffsetDateTime acceptedDate;

        private String acceptedIP;

        private String acceptedUserAgent;

        private String acceptedDomain;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The date and time the terms of service were accepted.
         */
        public Builder acceptedDate(OffsetDateTime acceptedDate) {
            Utils.checkNotNull(acceptedDate, "acceptedDate");
            this.acceptedDate = acceptedDate;
            return this;
        }


        /**
         * The IP address from which the terms of service were accepted.
         */
        public Builder acceptedIP(String acceptedIP) {
            Utils.checkNotNull(acceptedIP, "acceptedIP");
            this.acceptedIP = acceptedIP;
            return this;
        }


        /**
         * The user-agent of the user making the request.
         */
        public Builder acceptedUserAgent(String acceptedUserAgent) {
            Utils.checkNotNull(acceptedUserAgent, "acceptedUserAgent");
            this.acceptedUserAgent = acceptedUserAgent;
            return this;
        }


        public Builder acceptedDomain(String acceptedDomain) {
            Utils.checkNotNull(acceptedDomain, "acceptedDomain");
            this.acceptedDomain = acceptedDomain;
            return this;
        }

        public ManualTermsOfService build() {

            return new ManualTermsOfService(
                acceptedDate, acceptedIP, acceptedUserAgent,
                acceptedDomain);
        }

    }
}
