/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Boolean;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class LinkCard {
    /**
     * Wraps a compact-serialized JSON Web Encryption (JWE) token used for secure transmission of sensitive data (e.g., PCI information) through intermediaries. 
     * This token is encrypted using the public key from /end-to-end-keys and wraps an AES key. For details and examples, refer to our 
     * [GitHub repository](https://github.com/moovfinancial/moov-go/blob/main/examples/e2ee/e2ee_test.go).
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("e2ee")
    private Optional<? extends E2EEToken> e2ee;


    @JsonProperty("cardNumber")
    private String cardNumber;


    @JsonProperty("cardCvv")
    private String cardCvv;

    /**
     * The expiration date of the card or token.
     */
    @JsonProperty("expiration")
    private CardExpiration expiration;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("holderName")
    private Optional<String> holderName;


    @JsonProperty("billingAddress")
    private CardAddress billingAddress;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cardOnFile")
    private Optional<Boolean> cardOnFile;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("merchantAccountID")
    private Optional<String> merchantAccountID;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("verifyName")
    private Optional<Boolean> verifyName;

    @JsonCreator
    public LinkCard(
            @JsonProperty("e2ee") Optional<? extends E2EEToken> e2ee,
            @JsonProperty("cardNumber") String cardNumber,
            @JsonProperty("cardCvv") String cardCvv,
            @JsonProperty("expiration") CardExpiration expiration,
            @JsonProperty("holderName") Optional<String> holderName,
            @JsonProperty("billingAddress") CardAddress billingAddress,
            @JsonProperty("cardOnFile") Optional<Boolean> cardOnFile,
            @JsonProperty("merchantAccountID") Optional<String> merchantAccountID,
            @JsonProperty("verifyName") Optional<Boolean> verifyName) {
        Utils.checkNotNull(e2ee, "e2ee");
        Utils.checkNotNull(cardNumber, "cardNumber");
        Utils.checkNotNull(cardCvv, "cardCvv");
        Utils.checkNotNull(expiration, "expiration");
        Utils.checkNotNull(holderName, "holderName");
        Utils.checkNotNull(billingAddress, "billingAddress");
        Utils.checkNotNull(cardOnFile, "cardOnFile");
        Utils.checkNotNull(merchantAccountID, "merchantAccountID");
        Utils.checkNotNull(verifyName, "verifyName");
        this.e2ee = e2ee;
        this.cardNumber = cardNumber;
        this.cardCvv = cardCvv;
        this.expiration = expiration;
        this.holderName = holderName;
        this.billingAddress = billingAddress;
        this.cardOnFile = cardOnFile;
        this.merchantAccountID = merchantAccountID;
        this.verifyName = verifyName;
    }
    
    public LinkCard(
            String cardNumber,
            String cardCvv,
            CardExpiration expiration,
            CardAddress billingAddress) {
        this(Optional.empty(), cardNumber, cardCvv,
            expiration, Optional.empty(), billingAddress,
            Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * Wraps a compact-serialized JSON Web Encryption (JWE) token used for secure transmission of sensitive data (e.g., PCI information) through intermediaries. 
     * This token is encrypted using the public key from /end-to-end-keys and wraps an AES key. For details and examples, refer to our 
     * [GitHub repository](https://github.com/moovfinancial/moov-go/blob/main/examples/e2ee/e2ee_test.go).
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<E2EEToken> e2ee() {
        return (Optional<E2EEToken>) e2ee;
    }

    @JsonIgnore
    public String cardNumber() {
        return cardNumber;
    }

    @JsonIgnore
    public String cardCvv() {
        return cardCvv;
    }

    /**
     * The expiration date of the card or token.
     */
    @JsonIgnore
    public CardExpiration expiration() {
        return expiration;
    }

    @JsonIgnore
    public Optional<String> holderName() {
        return holderName;
    }

    @JsonIgnore
    public CardAddress billingAddress() {
        return billingAddress;
    }

    @JsonIgnore
    public Optional<Boolean> cardOnFile() {
        return cardOnFile;
    }

    @JsonIgnore
    public Optional<String> merchantAccountID() {
        return merchantAccountID;
    }

    @JsonIgnore
    public Optional<Boolean> verifyName() {
        return verifyName;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Wraps a compact-serialized JSON Web Encryption (JWE) token used for secure transmission of sensitive data (e.g., PCI information) through intermediaries. 
     * This token is encrypted using the public key from /end-to-end-keys and wraps an AES key. For details and examples, refer to our 
     * [GitHub repository](https://github.com/moovfinancial/moov-go/blob/main/examples/e2ee/e2ee_test.go).
     */
    public LinkCard withE2ee(E2EEToken e2ee) {
        Utils.checkNotNull(e2ee, "e2ee");
        this.e2ee = Optional.ofNullable(e2ee);
        return this;
    }


    /**
     * Wraps a compact-serialized JSON Web Encryption (JWE) token used for secure transmission of sensitive data (e.g., PCI information) through intermediaries. 
     * This token is encrypted using the public key from /end-to-end-keys and wraps an AES key. For details and examples, refer to our 
     * [GitHub repository](https://github.com/moovfinancial/moov-go/blob/main/examples/e2ee/e2ee_test.go).
     */
    public LinkCard withE2ee(Optional<? extends E2EEToken> e2ee) {
        Utils.checkNotNull(e2ee, "e2ee");
        this.e2ee = e2ee;
        return this;
    }

    public LinkCard withCardNumber(String cardNumber) {
        Utils.checkNotNull(cardNumber, "cardNumber");
        this.cardNumber = cardNumber;
        return this;
    }

    public LinkCard withCardCvv(String cardCvv) {
        Utils.checkNotNull(cardCvv, "cardCvv");
        this.cardCvv = cardCvv;
        return this;
    }

    /**
     * The expiration date of the card or token.
     */
    public LinkCard withExpiration(CardExpiration expiration) {
        Utils.checkNotNull(expiration, "expiration");
        this.expiration = expiration;
        return this;
    }

    public LinkCard withHolderName(String holderName) {
        Utils.checkNotNull(holderName, "holderName");
        this.holderName = Optional.ofNullable(holderName);
        return this;
    }


    public LinkCard withHolderName(Optional<String> holderName) {
        Utils.checkNotNull(holderName, "holderName");
        this.holderName = holderName;
        return this;
    }

    public LinkCard withBillingAddress(CardAddress billingAddress) {
        Utils.checkNotNull(billingAddress, "billingAddress");
        this.billingAddress = billingAddress;
        return this;
    }

    public LinkCard withCardOnFile(boolean cardOnFile) {
        Utils.checkNotNull(cardOnFile, "cardOnFile");
        this.cardOnFile = Optional.ofNullable(cardOnFile);
        return this;
    }


    public LinkCard withCardOnFile(Optional<Boolean> cardOnFile) {
        Utils.checkNotNull(cardOnFile, "cardOnFile");
        this.cardOnFile = cardOnFile;
        return this;
    }

    public LinkCard withMerchantAccountID(String merchantAccountID) {
        Utils.checkNotNull(merchantAccountID, "merchantAccountID");
        this.merchantAccountID = Optional.ofNullable(merchantAccountID);
        return this;
    }


    public LinkCard withMerchantAccountID(Optional<String> merchantAccountID) {
        Utils.checkNotNull(merchantAccountID, "merchantAccountID");
        this.merchantAccountID = merchantAccountID;
        return this;
    }

    public LinkCard withVerifyName(boolean verifyName) {
        Utils.checkNotNull(verifyName, "verifyName");
        this.verifyName = Optional.ofNullable(verifyName);
        return this;
    }


    public LinkCard withVerifyName(Optional<Boolean> verifyName) {
        Utils.checkNotNull(verifyName, "verifyName");
        this.verifyName = verifyName;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LinkCard other = (LinkCard) o;
        return 
            Utils.enhancedDeepEquals(this.e2ee, other.e2ee) &&
            Utils.enhancedDeepEquals(this.cardNumber, other.cardNumber) &&
            Utils.enhancedDeepEquals(this.cardCvv, other.cardCvv) &&
            Utils.enhancedDeepEquals(this.expiration, other.expiration) &&
            Utils.enhancedDeepEquals(this.holderName, other.holderName) &&
            Utils.enhancedDeepEquals(this.billingAddress, other.billingAddress) &&
            Utils.enhancedDeepEquals(this.cardOnFile, other.cardOnFile) &&
            Utils.enhancedDeepEquals(this.merchantAccountID, other.merchantAccountID) &&
            Utils.enhancedDeepEquals(this.verifyName, other.verifyName);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            e2ee, cardNumber, cardCvv,
            expiration, holderName, billingAddress,
            cardOnFile, merchantAccountID, verifyName);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LinkCard.class,
                "e2ee", e2ee,
                "cardNumber", cardNumber,
                "cardCvv", cardCvv,
                "expiration", expiration,
                "holderName", holderName,
                "billingAddress", billingAddress,
                "cardOnFile", cardOnFile,
                "merchantAccountID", merchantAccountID,
                "verifyName", verifyName);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<? extends E2EEToken> e2ee = Optional.empty();

        private String cardNumber;

        private String cardCvv;

        private CardExpiration expiration;

        private Optional<String> holderName = Optional.empty();

        private CardAddress billingAddress;

        private Optional<Boolean> cardOnFile = Optional.empty();

        private Optional<String> merchantAccountID = Optional.empty();

        private Optional<Boolean> verifyName = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Wraps a compact-serialized JSON Web Encryption (JWE) token used for secure transmission of sensitive data (e.g., PCI information) through intermediaries. 
         * This token is encrypted using the public key from /end-to-end-keys and wraps an AES key. For details and examples, refer to our 
         * [GitHub repository](https://github.com/moovfinancial/moov-go/blob/main/examples/e2ee/e2ee_test.go).
         */
        public Builder e2ee(E2EEToken e2ee) {
            Utils.checkNotNull(e2ee, "e2ee");
            this.e2ee = Optional.ofNullable(e2ee);
            return this;
        }

        /**
         * Wraps a compact-serialized JSON Web Encryption (JWE) token used for secure transmission of sensitive data (e.g., PCI information) through intermediaries. 
         * This token is encrypted using the public key from /end-to-end-keys and wraps an AES key. For details and examples, refer to our 
         * [GitHub repository](https://github.com/moovfinancial/moov-go/blob/main/examples/e2ee/e2ee_test.go).
         */
        public Builder e2ee(Optional<? extends E2EEToken> e2ee) {
            Utils.checkNotNull(e2ee, "e2ee");
            this.e2ee = e2ee;
            return this;
        }


        public Builder cardNumber(String cardNumber) {
            Utils.checkNotNull(cardNumber, "cardNumber");
            this.cardNumber = cardNumber;
            return this;
        }


        public Builder cardCvv(String cardCvv) {
            Utils.checkNotNull(cardCvv, "cardCvv");
            this.cardCvv = cardCvv;
            return this;
        }


        /**
         * The expiration date of the card or token.
         */
        public Builder expiration(CardExpiration expiration) {
            Utils.checkNotNull(expiration, "expiration");
            this.expiration = expiration;
            return this;
        }


        public Builder holderName(String holderName) {
            Utils.checkNotNull(holderName, "holderName");
            this.holderName = Optional.ofNullable(holderName);
            return this;
        }

        public Builder holderName(Optional<String> holderName) {
            Utils.checkNotNull(holderName, "holderName");
            this.holderName = holderName;
            return this;
        }


        public Builder billingAddress(CardAddress billingAddress) {
            Utils.checkNotNull(billingAddress, "billingAddress");
            this.billingAddress = billingAddress;
            return this;
        }


        public Builder cardOnFile(boolean cardOnFile) {
            Utils.checkNotNull(cardOnFile, "cardOnFile");
            this.cardOnFile = Optional.ofNullable(cardOnFile);
            return this;
        }

        public Builder cardOnFile(Optional<Boolean> cardOnFile) {
            Utils.checkNotNull(cardOnFile, "cardOnFile");
            this.cardOnFile = cardOnFile;
            return this;
        }


        public Builder merchantAccountID(String merchantAccountID) {
            Utils.checkNotNull(merchantAccountID, "merchantAccountID");
            this.merchantAccountID = Optional.ofNullable(merchantAccountID);
            return this;
        }

        public Builder merchantAccountID(Optional<String> merchantAccountID) {
            Utils.checkNotNull(merchantAccountID, "merchantAccountID");
            this.merchantAccountID = merchantAccountID;
            return this;
        }


        public Builder verifyName(boolean verifyName) {
            Utils.checkNotNull(verifyName, "verifyName");
            this.verifyName = Optional.ofNullable(verifyName);
            return this;
        }

        public Builder verifyName(Optional<Boolean> verifyName) {
            Utils.checkNotNull(verifyName, "verifyName");
            this.verifyName = verifyName;
            return this;
        }

        public LinkCard build() {

            return new LinkCard(
                e2ee, cardNumber, cardCvv,
                expiration, holderName, billingAddress,
                cardOnFile, merchantAccountID, verifyName);
        }

    }
}
