/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class IssuingVelocityLimitError {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("amount")
    private Optional<String> amount;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("interval")
    private Optional<String> interval;

    @JsonCreator
    public IssuingVelocityLimitError(
            @JsonProperty("amount") Optional<String> amount,
            @JsonProperty("interval") Optional<String> interval) {
        Utils.checkNotNull(amount, "amount");
        Utils.checkNotNull(interval, "interval");
        this.amount = amount;
        this.interval = interval;
    }
    
    public IssuingVelocityLimitError() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> amount() {
        return amount;
    }

    @JsonIgnore
    public Optional<String> interval() {
        return interval;
    }

    public static Builder builder() {
        return new Builder();
    }


    public IssuingVelocityLimitError withAmount(String amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = Optional.ofNullable(amount);
        return this;
    }


    public IssuingVelocityLimitError withAmount(Optional<String> amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    public IssuingVelocityLimitError withInterval(String interval) {
        Utils.checkNotNull(interval, "interval");
        this.interval = Optional.ofNullable(interval);
        return this;
    }


    public IssuingVelocityLimitError withInterval(Optional<String> interval) {
        Utils.checkNotNull(interval, "interval");
        this.interval = interval;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IssuingVelocityLimitError other = (IssuingVelocityLimitError) o;
        return 
            Utils.enhancedDeepEquals(this.amount, other.amount) &&
            Utils.enhancedDeepEquals(this.interval, other.interval);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            amount, interval);
    }
    
    @Override
    public String toString() {
        return Utils.toString(IssuingVelocityLimitError.class,
                "amount", amount,
                "interval", interval);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> amount = Optional.empty();

        private Optional<String> interval = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder amount(String amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = Optional.ofNullable(amount);
            return this;
        }

        public Builder amount(Optional<String> amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }


        public Builder interval(String interval) {
            Utils.checkNotNull(interval, "interval");
            this.interval = Optional.ofNullable(interval);
            return this;
        }

        public Builder interval(Optional<String> interval) {
            Utils.checkNotNull(interval, "interval");
            this.interval = interval;
            return this;
        }

        public IssuingVelocityLimitError build() {

            return new IssuingVelocityLimitError(
                amount, interval);
        }

    }
}
