/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;

/**
 * IssuedCardState
 * 
 * <p>The `state` represents the operational status of an issued card. A card can only approve incoming authorizations if it is in an active state.
 * 
 * <p>- `active`: The card is operational and approves authorizations. Generally becomes active shortly after card creation.
 * - `inactive`: The card cannot approve authorizations. This is currently a temporary state assigned post-creation during the activation process.
 * - `closed`: The card is permanently deactivated and cannot approve authorizations. A card can be closed by request or when it expires.
 * - `pending-verification`: Awaiting additional authorized user verification before the card can be activated.
 */
public enum IssuedCardState {
    ACTIVE("active"),
    INACTIVE("inactive"),
    PENDING_VERIFICATION("pending-verification"),
    CLOSED("closed");

    @JsonValue
    private final String value;

    IssuedCardState(String value) {
        this.value = value;
    }
    
    public String value() {
        return value;
    }
    
    public static Optional<IssuedCardState> fromValue(String value) {
        for (IssuedCardState o: IssuedCardState.values()) {
            if (Objects.deepEquals(o.value, value)) {
                return Optional.of(o);
            }
        }
        return Optional.empty();
    }
}

