/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;


public class IssuedCardAuthorization {

    @JsonProperty("authorizationID")
    private String authorizationID;


    @JsonProperty("issuedCardID")
    private String issuedCardID;


    @JsonProperty("fundingWalletID")
    private String fundingWalletID;

    /**
     * The name of the network a card transaction is routed through.
     */
    @JsonProperty("network")
    private CardIssuingNetwork network;

    /**
     * A decimal-formatted numerical string that represents up to 2 decimal place precision. In USD for example, 12.34 is $12.34 and 0.99 is $0.99.
     */
    @JsonProperty("authorizedAmount")
    private String authorizedAmount;

    /**
     * Status of a card issuing authorization.
     */
    @JsonProperty("status")
    private IssuingAuthorizationStatus status;


    @JsonProperty("merchantData")
    private IssuingMerchantData merchantData;


    @JsonProperty("createdOn")
    private OffsetDateTime createdOn;

    /**
     * List of card transaction IDs associated with this authorization.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cardTransactions")
    private Optional<? extends List<String>> cardTransactions;

    @JsonCreator
    public IssuedCardAuthorization(
            @JsonProperty("authorizationID") String authorizationID,
            @JsonProperty("issuedCardID") String issuedCardID,
            @JsonProperty("fundingWalletID") String fundingWalletID,
            @JsonProperty("network") CardIssuingNetwork network,
            @JsonProperty("authorizedAmount") String authorizedAmount,
            @JsonProperty("status") IssuingAuthorizationStatus status,
            @JsonProperty("merchantData") IssuingMerchantData merchantData,
            @JsonProperty("createdOn") OffsetDateTime createdOn,
            @JsonProperty("cardTransactions") Optional<? extends List<String>> cardTransactions) {
        Utils.checkNotNull(authorizationID, "authorizationID");
        Utils.checkNotNull(issuedCardID, "issuedCardID");
        Utils.checkNotNull(fundingWalletID, "fundingWalletID");
        Utils.checkNotNull(network, "network");
        Utils.checkNotNull(authorizedAmount, "authorizedAmount");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(merchantData, "merchantData");
        Utils.checkNotNull(createdOn, "createdOn");
        Utils.checkNotNull(cardTransactions, "cardTransactions");
        this.authorizationID = authorizationID;
        this.issuedCardID = issuedCardID;
        this.fundingWalletID = fundingWalletID;
        this.network = network;
        this.authorizedAmount = authorizedAmount;
        this.status = status;
        this.merchantData = merchantData;
        this.createdOn = createdOn;
        this.cardTransactions = cardTransactions;
    }
    
    public IssuedCardAuthorization(
            String authorizationID,
            String issuedCardID,
            String fundingWalletID,
            CardIssuingNetwork network,
            String authorizedAmount,
            IssuingAuthorizationStatus status,
            IssuingMerchantData merchantData,
            OffsetDateTime createdOn) {
        this(authorizationID, issuedCardID, fundingWalletID,
            network, authorizedAmount, status,
            merchantData, createdOn, Optional.empty());
    }

    @JsonIgnore
    public String authorizationID() {
        return authorizationID;
    }

    @JsonIgnore
    public String issuedCardID() {
        return issuedCardID;
    }

    @JsonIgnore
    public String fundingWalletID() {
        return fundingWalletID;
    }

    /**
     * The name of the network a card transaction is routed through.
     */
    @JsonIgnore
    public CardIssuingNetwork network() {
        return network;
    }

    /**
     * A decimal-formatted numerical string that represents up to 2 decimal place precision. In USD for example, 12.34 is $12.34 and 0.99 is $0.99.
     */
    @JsonIgnore
    public String authorizedAmount() {
        return authorizedAmount;
    }

    /**
     * Status of a card issuing authorization.
     */
    @JsonIgnore
    public IssuingAuthorizationStatus status() {
        return status;
    }

    @JsonIgnore
    public IssuingMerchantData merchantData() {
        return merchantData;
    }

    @JsonIgnore
    public OffsetDateTime createdOn() {
        return createdOn;
    }

    /**
     * List of card transaction IDs associated with this authorization.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<String>> cardTransactions() {
        return (Optional<List<String>>) cardTransactions;
    }

    public static Builder builder() {
        return new Builder();
    }


    public IssuedCardAuthorization withAuthorizationID(String authorizationID) {
        Utils.checkNotNull(authorizationID, "authorizationID");
        this.authorizationID = authorizationID;
        return this;
    }

    public IssuedCardAuthorization withIssuedCardID(String issuedCardID) {
        Utils.checkNotNull(issuedCardID, "issuedCardID");
        this.issuedCardID = issuedCardID;
        return this;
    }

    public IssuedCardAuthorization withFundingWalletID(String fundingWalletID) {
        Utils.checkNotNull(fundingWalletID, "fundingWalletID");
        this.fundingWalletID = fundingWalletID;
        return this;
    }

    /**
     * The name of the network a card transaction is routed through.
     */
    public IssuedCardAuthorization withNetwork(CardIssuingNetwork network) {
        Utils.checkNotNull(network, "network");
        this.network = network;
        return this;
    }

    /**
     * A decimal-formatted numerical string that represents up to 2 decimal place precision. In USD for example, 12.34 is $12.34 and 0.99 is $0.99.
     */
    public IssuedCardAuthorization withAuthorizedAmount(String authorizedAmount) {
        Utils.checkNotNull(authorizedAmount, "authorizedAmount");
        this.authorizedAmount = authorizedAmount;
        return this;
    }

    /**
     * Status of a card issuing authorization.
     */
    public IssuedCardAuthorization withStatus(IssuingAuthorizationStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public IssuedCardAuthorization withMerchantData(IssuingMerchantData merchantData) {
        Utils.checkNotNull(merchantData, "merchantData");
        this.merchantData = merchantData;
        return this;
    }

    public IssuedCardAuthorization withCreatedOn(OffsetDateTime createdOn) {
        Utils.checkNotNull(createdOn, "createdOn");
        this.createdOn = createdOn;
        return this;
    }

    /**
     * List of card transaction IDs associated with this authorization.
     */
    public IssuedCardAuthorization withCardTransactions(List<String> cardTransactions) {
        Utils.checkNotNull(cardTransactions, "cardTransactions");
        this.cardTransactions = Optional.ofNullable(cardTransactions);
        return this;
    }


    /**
     * List of card transaction IDs associated with this authorization.
     */
    public IssuedCardAuthorization withCardTransactions(Optional<? extends List<String>> cardTransactions) {
        Utils.checkNotNull(cardTransactions, "cardTransactions");
        this.cardTransactions = cardTransactions;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IssuedCardAuthorization other = (IssuedCardAuthorization) o;
        return 
            Utils.enhancedDeepEquals(this.authorizationID, other.authorizationID) &&
            Utils.enhancedDeepEquals(this.issuedCardID, other.issuedCardID) &&
            Utils.enhancedDeepEquals(this.fundingWalletID, other.fundingWalletID) &&
            Utils.enhancedDeepEquals(this.network, other.network) &&
            Utils.enhancedDeepEquals(this.authorizedAmount, other.authorizedAmount) &&
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.merchantData, other.merchantData) &&
            Utils.enhancedDeepEquals(this.createdOn, other.createdOn) &&
            Utils.enhancedDeepEquals(this.cardTransactions, other.cardTransactions);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            authorizationID, issuedCardID, fundingWalletID,
            network, authorizedAmount, status,
            merchantData, createdOn, cardTransactions);
    }
    
    @Override
    public String toString() {
        return Utils.toString(IssuedCardAuthorization.class,
                "authorizationID", authorizationID,
                "issuedCardID", issuedCardID,
                "fundingWalletID", fundingWalletID,
                "network", network,
                "authorizedAmount", authorizedAmount,
                "status", status,
                "merchantData", merchantData,
                "createdOn", createdOn,
                "cardTransactions", cardTransactions);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String authorizationID;

        private String issuedCardID;

        private String fundingWalletID;

        private CardIssuingNetwork network;

        private String authorizedAmount;

        private IssuingAuthorizationStatus status;

        private IssuingMerchantData merchantData;

        private OffsetDateTime createdOn;

        private Optional<? extends List<String>> cardTransactions = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder authorizationID(String authorizationID) {
            Utils.checkNotNull(authorizationID, "authorizationID");
            this.authorizationID = authorizationID;
            return this;
        }


        public Builder issuedCardID(String issuedCardID) {
            Utils.checkNotNull(issuedCardID, "issuedCardID");
            this.issuedCardID = issuedCardID;
            return this;
        }


        public Builder fundingWalletID(String fundingWalletID) {
            Utils.checkNotNull(fundingWalletID, "fundingWalletID");
            this.fundingWalletID = fundingWalletID;
            return this;
        }


        /**
         * The name of the network a card transaction is routed through.
         */
        public Builder network(CardIssuingNetwork network) {
            Utils.checkNotNull(network, "network");
            this.network = network;
            return this;
        }


        /**
         * A decimal-formatted numerical string that represents up to 2 decimal place precision. In USD for example, 12.34 is $12.34 and 0.99 is $0.99.
         */
        public Builder authorizedAmount(String authorizedAmount) {
            Utils.checkNotNull(authorizedAmount, "authorizedAmount");
            this.authorizedAmount = authorizedAmount;
            return this;
        }


        /**
         * Status of a card issuing authorization.
         */
        public Builder status(IssuingAuthorizationStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        public Builder merchantData(IssuingMerchantData merchantData) {
            Utils.checkNotNull(merchantData, "merchantData");
            this.merchantData = merchantData;
            return this;
        }


        public Builder createdOn(OffsetDateTime createdOn) {
            Utils.checkNotNull(createdOn, "createdOn");
            this.createdOn = createdOn;
            return this;
        }


        /**
         * List of card transaction IDs associated with this authorization.
         */
        public Builder cardTransactions(List<String> cardTransactions) {
            Utils.checkNotNull(cardTransactions, "cardTransactions");
            this.cardTransactions = Optional.ofNullable(cardTransactions);
            return this;
        }

        /**
         * List of card transaction IDs associated with this authorization.
         */
        public Builder cardTransactions(Optional<? extends List<String>> cardTransactions) {
            Utils.checkNotNull(cardTransactions, "cardTransactions");
            this.cardTransactions = cardTransactions;
            return this;
        }

        public IssuedCardAuthorization build() {

            return new IssuedCardAuthorization(
                authorizationID, issuedCardID, fundingWalletID,
                network, authorizedAmount, status,
                merchantData, createdOn, cardTransactions);
        }

    }
}
