/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class IndividualName {
    /**
     * The individual's first given name.
     */
    @JsonProperty("firstName")
    private String firstName;

    /**
     * The individual's second given name, if any.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("middleName")
    private Optional<String> middleName;

    /**
     * The individual's family name.
     */
    @JsonProperty("lastName")
    private String lastName;

    /**
     * Suffix of a given name.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("suffix")
    private Optional<String> suffix;

    @JsonCreator
    public IndividualName(
            @JsonProperty("firstName") String firstName,
            @JsonProperty("middleName") Optional<String> middleName,
            @JsonProperty("lastName") String lastName,
            @JsonProperty("suffix") Optional<String> suffix) {
        Utils.checkNotNull(firstName, "firstName");
        Utils.checkNotNull(middleName, "middleName");
        Utils.checkNotNull(lastName, "lastName");
        Utils.checkNotNull(suffix, "suffix");
        this.firstName = firstName;
        this.middleName = middleName;
        this.lastName = lastName;
        this.suffix = suffix;
    }
    
    public IndividualName(
            String firstName,
            String lastName) {
        this(firstName, Optional.empty(), lastName,
            Optional.empty());
    }

    /**
     * The individual's first given name.
     */
    @JsonIgnore
    public String firstName() {
        return firstName;
    }

    /**
     * The individual's second given name, if any.
     */
    @JsonIgnore
    public Optional<String> middleName() {
        return middleName;
    }

    /**
     * The individual's family name.
     */
    @JsonIgnore
    public String lastName() {
        return lastName;
    }

    /**
     * Suffix of a given name.
     */
    @JsonIgnore
    public Optional<String> suffix() {
        return suffix;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The individual's first given name.
     */
    public IndividualName withFirstName(String firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = firstName;
        return this;
    }

    /**
     * The individual's second given name, if any.
     */
    public IndividualName withMiddleName(String middleName) {
        Utils.checkNotNull(middleName, "middleName");
        this.middleName = Optional.ofNullable(middleName);
        return this;
    }


    /**
     * The individual's second given name, if any.
     */
    public IndividualName withMiddleName(Optional<String> middleName) {
        Utils.checkNotNull(middleName, "middleName");
        this.middleName = middleName;
        return this;
    }

    /**
     * The individual's family name.
     */
    public IndividualName withLastName(String lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = lastName;
        return this;
    }

    /**
     * Suffix of a given name.
     */
    public IndividualName withSuffix(String suffix) {
        Utils.checkNotNull(suffix, "suffix");
        this.suffix = Optional.ofNullable(suffix);
        return this;
    }


    /**
     * Suffix of a given name.
     */
    public IndividualName withSuffix(Optional<String> suffix) {
        Utils.checkNotNull(suffix, "suffix");
        this.suffix = suffix;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IndividualName other = (IndividualName) o;
        return 
            Utils.enhancedDeepEquals(this.firstName, other.firstName) &&
            Utils.enhancedDeepEquals(this.middleName, other.middleName) &&
            Utils.enhancedDeepEquals(this.lastName, other.lastName) &&
            Utils.enhancedDeepEquals(this.suffix, other.suffix);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            firstName, middleName, lastName,
            suffix);
    }
    
    @Override
    public String toString() {
        return Utils.toString(IndividualName.class,
                "firstName", firstName,
                "middleName", middleName,
                "lastName", lastName,
                "suffix", suffix);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String firstName;

        private Optional<String> middleName = Optional.empty();

        private String lastName;

        private Optional<String> suffix = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The individual's first given name.
         */
        public Builder firstName(String firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = firstName;
            return this;
        }


        /**
         * The individual's second given name, if any.
         */
        public Builder middleName(String middleName) {
            Utils.checkNotNull(middleName, "middleName");
            this.middleName = Optional.ofNullable(middleName);
            return this;
        }

        /**
         * The individual's second given name, if any.
         */
        public Builder middleName(Optional<String> middleName) {
            Utils.checkNotNull(middleName, "middleName");
            this.middleName = middleName;
            return this;
        }


        /**
         * The individual's family name.
         */
        public Builder lastName(String lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = lastName;
            return this;
        }


        /**
         * Suffix of a given name.
         */
        public Builder suffix(String suffix) {
            Utils.checkNotNull(suffix, "suffix");
            this.suffix = Optional.ofNullable(suffix);
            return this;
        }

        /**
         * Suffix of a given name.
         */
        public Builder suffix(Optional<String> suffix) {
            Utils.checkNotNull(suffix, "suffix");
            this.suffix = suffix;
            return this;
        }

        public IndividualName build() {

            return new IndividualName(
                firstName, middleName, lastName,
                suffix);
        }

    }
}
