/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.Optional;

/**
 * IncurredFee
 * 
 * <p>A fee incurred by a user.
 */
public class IncurredFee {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("feeID")
    private Optional<String> feeID;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("accountID")
    private Optional<String> accountID;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("walletID")
    private Optional<String> walletID;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("createdOn")
    private Optional<OffsetDateTime> createdOn;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("feeName")
    private Optional<String> feeName;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("amount")
    private Optional<? extends AmountDecimal> amount;

    /**
     * The entity that generated the fee.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("generatedBy")
    private Optional<? extends GeneratedBy> generatedBy;

    @JsonCreator
    public IncurredFee(
            @JsonProperty("feeID") Optional<String> feeID,
            @JsonProperty("accountID") Optional<String> accountID,
            @JsonProperty("walletID") Optional<String> walletID,
            @JsonProperty("createdOn") Optional<OffsetDateTime> createdOn,
            @JsonProperty("feeName") Optional<String> feeName,
            @JsonProperty("amount") Optional<? extends AmountDecimal> amount,
            @JsonProperty("generatedBy") Optional<? extends GeneratedBy> generatedBy) {
        Utils.checkNotNull(feeID, "feeID");
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(walletID, "walletID");
        Utils.checkNotNull(createdOn, "createdOn");
        Utils.checkNotNull(feeName, "feeName");
        Utils.checkNotNull(amount, "amount");
        Utils.checkNotNull(generatedBy, "generatedBy");
        this.feeID = feeID;
        this.accountID = accountID;
        this.walletID = walletID;
        this.createdOn = createdOn;
        this.feeName = feeName;
        this.amount = amount;
        this.generatedBy = generatedBy;
    }
    
    public IncurredFee() {
        this(Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty());
    }

    @JsonIgnore
    public Optional<String> feeID() {
        return feeID;
    }

    @JsonIgnore
    public Optional<String> accountID() {
        return accountID;
    }

    @JsonIgnore
    public Optional<String> walletID() {
        return walletID;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> createdOn() {
        return createdOn;
    }

    @JsonIgnore
    public Optional<String> feeName() {
        return feeName;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<AmountDecimal> amount() {
        return (Optional<AmountDecimal>) amount;
    }

    /**
     * The entity that generated the fee.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<GeneratedBy> generatedBy() {
        return (Optional<GeneratedBy>) generatedBy;
    }

    public static Builder builder() {
        return new Builder();
    }


    public IncurredFee withFeeID(String feeID) {
        Utils.checkNotNull(feeID, "feeID");
        this.feeID = Optional.ofNullable(feeID);
        return this;
    }


    public IncurredFee withFeeID(Optional<String> feeID) {
        Utils.checkNotNull(feeID, "feeID");
        this.feeID = feeID;
        return this;
    }

    public IncurredFee withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = Optional.ofNullable(accountID);
        return this;
    }


    public IncurredFee withAccountID(Optional<String> accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public IncurredFee withWalletID(String walletID) {
        Utils.checkNotNull(walletID, "walletID");
        this.walletID = Optional.ofNullable(walletID);
        return this;
    }


    public IncurredFee withWalletID(Optional<String> walletID) {
        Utils.checkNotNull(walletID, "walletID");
        this.walletID = walletID;
        return this;
    }

    public IncurredFee withCreatedOn(OffsetDateTime createdOn) {
        Utils.checkNotNull(createdOn, "createdOn");
        this.createdOn = Optional.ofNullable(createdOn);
        return this;
    }


    public IncurredFee withCreatedOn(Optional<OffsetDateTime> createdOn) {
        Utils.checkNotNull(createdOn, "createdOn");
        this.createdOn = createdOn;
        return this;
    }

    public IncurredFee withFeeName(String feeName) {
        Utils.checkNotNull(feeName, "feeName");
        this.feeName = Optional.ofNullable(feeName);
        return this;
    }


    public IncurredFee withFeeName(Optional<String> feeName) {
        Utils.checkNotNull(feeName, "feeName");
        this.feeName = feeName;
        return this;
    }

    public IncurredFee withAmount(AmountDecimal amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = Optional.ofNullable(amount);
        return this;
    }


    public IncurredFee withAmount(Optional<? extends AmountDecimal> amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    /**
     * The entity that generated the fee.
     */
    public IncurredFee withGeneratedBy(GeneratedBy generatedBy) {
        Utils.checkNotNull(generatedBy, "generatedBy");
        this.generatedBy = Optional.ofNullable(generatedBy);
        return this;
    }


    /**
     * The entity that generated the fee.
     */
    public IncurredFee withGeneratedBy(Optional<? extends GeneratedBy> generatedBy) {
        Utils.checkNotNull(generatedBy, "generatedBy");
        this.generatedBy = generatedBy;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IncurredFee other = (IncurredFee) o;
        return 
            Utils.enhancedDeepEquals(this.feeID, other.feeID) &&
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.walletID, other.walletID) &&
            Utils.enhancedDeepEquals(this.createdOn, other.createdOn) &&
            Utils.enhancedDeepEquals(this.feeName, other.feeName) &&
            Utils.enhancedDeepEquals(this.amount, other.amount) &&
            Utils.enhancedDeepEquals(this.generatedBy, other.generatedBy);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            feeID, accountID, walletID,
            createdOn, feeName, amount,
            generatedBy);
    }
    
    @Override
    public String toString() {
        return Utils.toString(IncurredFee.class,
                "feeID", feeID,
                "accountID", accountID,
                "walletID", walletID,
                "createdOn", createdOn,
                "feeName", feeName,
                "amount", amount,
                "generatedBy", generatedBy);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> feeID = Optional.empty();

        private Optional<String> accountID = Optional.empty();

        private Optional<String> walletID = Optional.empty();

        private Optional<OffsetDateTime> createdOn = Optional.empty();

        private Optional<String> feeName = Optional.empty();

        private Optional<? extends AmountDecimal> amount = Optional.empty();

        private Optional<? extends GeneratedBy> generatedBy = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder feeID(String feeID) {
            Utils.checkNotNull(feeID, "feeID");
            this.feeID = Optional.ofNullable(feeID);
            return this;
        }

        public Builder feeID(Optional<String> feeID) {
            Utils.checkNotNull(feeID, "feeID");
            this.feeID = feeID;
            return this;
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = Optional.ofNullable(accountID);
            return this;
        }

        public Builder accountID(Optional<String> accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder walletID(String walletID) {
            Utils.checkNotNull(walletID, "walletID");
            this.walletID = Optional.ofNullable(walletID);
            return this;
        }

        public Builder walletID(Optional<String> walletID) {
            Utils.checkNotNull(walletID, "walletID");
            this.walletID = walletID;
            return this;
        }


        public Builder createdOn(OffsetDateTime createdOn) {
            Utils.checkNotNull(createdOn, "createdOn");
            this.createdOn = Optional.ofNullable(createdOn);
            return this;
        }

        public Builder createdOn(Optional<OffsetDateTime> createdOn) {
            Utils.checkNotNull(createdOn, "createdOn");
            this.createdOn = createdOn;
            return this;
        }


        public Builder feeName(String feeName) {
            Utils.checkNotNull(feeName, "feeName");
            this.feeName = Optional.ofNullable(feeName);
            return this;
        }

        public Builder feeName(Optional<String> feeName) {
            Utils.checkNotNull(feeName, "feeName");
            this.feeName = feeName;
            return this;
        }


        public Builder amount(AmountDecimal amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = Optional.ofNullable(amount);
            return this;
        }

        public Builder amount(Optional<? extends AmountDecimal> amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }


        /**
         * The entity that generated the fee.
         */
        public Builder generatedBy(GeneratedBy generatedBy) {
            Utils.checkNotNull(generatedBy, "generatedBy");
            this.generatedBy = Optional.ofNullable(generatedBy);
            return this;
        }

        /**
         * The entity that generated the fee.
         */
        public Builder generatedBy(Optional<? extends GeneratedBy> generatedBy) {
            Utils.checkNotNull(generatedBy, "generatedBy");
            this.generatedBy = generatedBy;
            return this;
        }

        public IncurredFee build() {

            return new IncurredFee(
                feeID, accountID, walletID,
                createdOn, feeName, amount,
                generatedBy);
        }

    }
}
