/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;

/**
 * GuestProfile
 * 
 * <p>Describes a guest account profile.
 */
public class GuestProfile {
    /**
     * The name associated with the guest account.
     * This will default to "Guest {accountIDfirst8}" if no other name is provided.
     */
    @JsonProperty("name")
    private String name;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("phone")
    private Optional<? extends PhoneNumber> phone;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("email")
    private Optional<String> email;

    @JsonCreator
    public GuestProfile(
            @JsonProperty("name") String name,
            @JsonProperty("phone") Optional<? extends PhoneNumber> phone,
            @JsonProperty("email") Optional<String> email) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(phone, "phone");
        Utils.checkNotNull(email, "email");
        this.name = name;
        this.phone = phone;
        this.email = email;
    }
    
    public GuestProfile(
            String name) {
        this(name, Optional.empty(), Optional.empty());
    }

    /**
     * The name associated with the guest account.
     * This will default to "Guest {accountIDfirst8}" if no other name is provided.
     */
    @JsonIgnore
    public String name() {
        return name;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<PhoneNumber> phone() {
        return (Optional<PhoneNumber>) phone;
    }

    @JsonIgnore
    public Optional<String> email() {
        return email;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The name associated with the guest account.
     * This will default to "Guest {accountIDfirst8}" if no other name is provided.
     */
    public GuestProfile withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public GuestProfile withPhone(PhoneNumber phone) {
        Utils.checkNotNull(phone, "phone");
        this.phone = Optional.ofNullable(phone);
        return this;
    }


    public GuestProfile withPhone(Optional<? extends PhoneNumber> phone) {
        Utils.checkNotNull(phone, "phone");
        this.phone = phone;
        return this;
    }

    public GuestProfile withEmail(String email) {
        Utils.checkNotNull(email, "email");
        this.email = Optional.ofNullable(email);
        return this;
    }


    public GuestProfile withEmail(Optional<String> email) {
        Utils.checkNotNull(email, "email");
        this.email = email;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GuestProfile other = (GuestProfile) o;
        return 
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.phone, other.phone) &&
            Utils.enhancedDeepEquals(this.email, other.email);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            name, phone, email);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GuestProfile.class,
                "name", name,
                "phone", phone,
                "email", email);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String name;

        private Optional<? extends PhoneNumber> phone = Optional.empty();

        private Optional<String> email = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The name associated with the guest account.
         * This will default to "Guest {accountIDfirst8}" if no other name is provided.
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }


        public Builder phone(PhoneNumber phone) {
            Utils.checkNotNull(phone, "phone");
            this.phone = Optional.ofNullable(phone);
            return this;
        }

        public Builder phone(Optional<? extends PhoneNumber> phone) {
            Utils.checkNotNull(phone, "phone");
            this.phone = phone;
            return this;
        }


        public Builder email(String email) {
            Utils.checkNotNull(email, "email");
            this.email = Optional.ofNullable(email);
            return this;
        }

        public Builder email(Optional<String> email) {
            Utils.checkNotNull(email, "email");
            this.email = email;
            return this;
        }

        public GuestProfile build() {

            return new GuestProfile(
                name, phone, email);
        }

    }
}
