/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class FulfillmentError {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("method")
    private Optional<String> method;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("timeframe")
    private Optional<String> timeframe;

    @JsonCreator
    public FulfillmentError(
            @JsonProperty("method") Optional<String> method,
            @JsonProperty("timeframe") Optional<String> timeframe) {
        Utils.checkNotNull(method, "method");
        Utils.checkNotNull(timeframe, "timeframe");
        this.method = method;
        this.timeframe = timeframe;
    }
    
    public FulfillmentError() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> method() {
        return method;
    }

    @JsonIgnore
    public Optional<String> timeframe() {
        return timeframe;
    }

    public static Builder builder() {
        return new Builder();
    }


    public FulfillmentError withMethod(String method) {
        Utils.checkNotNull(method, "method");
        this.method = Optional.ofNullable(method);
        return this;
    }


    public FulfillmentError withMethod(Optional<String> method) {
        Utils.checkNotNull(method, "method");
        this.method = method;
        return this;
    }

    public FulfillmentError withTimeframe(String timeframe) {
        Utils.checkNotNull(timeframe, "timeframe");
        this.timeframe = Optional.ofNullable(timeframe);
        return this;
    }


    public FulfillmentError withTimeframe(Optional<String> timeframe) {
        Utils.checkNotNull(timeframe, "timeframe");
        this.timeframe = timeframe;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FulfillmentError other = (FulfillmentError) o;
        return 
            Utils.enhancedDeepEquals(this.method, other.method) &&
            Utils.enhancedDeepEquals(this.timeframe, other.timeframe);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            method, timeframe);
    }
    
    @Override
    public String toString() {
        return Utils.toString(FulfillmentError.class,
                "method", method,
                "timeframe", timeframe);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> method = Optional.empty();

        private Optional<String> timeframe = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder method(String method) {
            Utils.checkNotNull(method, "method");
            this.method = Optional.ofNullable(method);
            return this;
        }

        public Builder method(Optional<String> method) {
            Utils.checkNotNull(method, "method");
            this.method = method;
            return this;
        }


        public Builder timeframe(String timeframe) {
            Utils.checkNotNull(timeframe, "timeframe");
            this.timeframe = Optional.ofNullable(timeframe);
            return this;
        }

        public Builder timeframe(Optional<String> timeframe) {
            Utils.checkNotNull(timeframe, "timeframe");
            this.timeframe = timeframe;
            return this;
        }

        public FulfillmentError build() {

            return new FulfillmentError(
                method, timeframe);
        }

    }
}
