/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class FulfillmentDetailsError {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("shipmentDurationDays")
    private Optional<String> shipmentDurationDays;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("returnPolicy")
    private Optional<String> returnPolicy;

    @JsonCreator
    public FulfillmentDetailsError(
            @JsonProperty("shipmentDurationDays") Optional<String> shipmentDurationDays,
            @JsonProperty("returnPolicy") Optional<String> returnPolicy) {
        Utils.checkNotNull(shipmentDurationDays, "shipmentDurationDays");
        Utils.checkNotNull(returnPolicy, "returnPolicy");
        this.shipmentDurationDays = shipmentDurationDays;
        this.returnPolicy = returnPolicy;
    }
    
    public FulfillmentDetailsError() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> shipmentDurationDays() {
        return shipmentDurationDays;
    }

    @JsonIgnore
    public Optional<String> returnPolicy() {
        return returnPolicy;
    }

    public static Builder builder() {
        return new Builder();
    }


    public FulfillmentDetailsError withShipmentDurationDays(String shipmentDurationDays) {
        Utils.checkNotNull(shipmentDurationDays, "shipmentDurationDays");
        this.shipmentDurationDays = Optional.ofNullable(shipmentDurationDays);
        return this;
    }


    public FulfillmentDetailsError withShipmentDurationDays(Optional<String> shipmentDurationDays) {
        Utils.checkNotNull(shipmentDurationDays, "shipmentDurationDays");
        this.shipmentDurationDays = shipmentDurationDays;
        return this;
    }

    public FulfillmentDetailsError withReturnPolicy(String returnPolicy) {
        Utils.checkNotNull(returnPolicy, "returnPolicy");
        this.returnPolicy = Optional.ofNullable(returnPolicy);
        return this;
    }


    public FulfillmentDetailsError withReturnPolicy(Optional<String> returnPolicy) {
        Utils.checkNotNull(returnPolicy, "returnPolicy");
        this.returnPolicy = returnPolicy;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FulfillmentDetailsError other = (FulfillmentDetailsError) o;
        return 
            Utils.enhancedDeepEquals(this.shipmentDurationDays, other.shipmentDurationDays) &&
            Utils.enhancedDeepEquals(this.returnPolicy, other.returnPolicy);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            shipmentDurationDays, returnPolicy);
    }
    
    @Override
    public String toString() {
        return Utils.toString(FulfillmentDetailsError.class,
                "shipmentDurationDays", shipmentDurationDays,
                "returnPolicy", returnPolicy);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> shipmentDurationDays = Optional.empty();

        private Optional<String> returnPolicy = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder shipmentDurationDays(String shipmentDurationDays) {
            Utils.checkNotNull(shipmentDurationDays, "shipmentDurationDays");
            this.shipmentDurationDays = Optional.ofNullable(shipmentDurationDays);
            return this;
        }

        public Builder shipmentDurationDays(Optional<String> shipmentDurationDays) {
            Utils.checkNotNull(shipmentDurationDays, "shipmentDurationDays");
            this.shipmentDurationDays = shipmentDurationDays;
            return this;
        }


        public Builder returnPolicy(String returnPolicy) {
            Utils.checkNotNull(returnPolicy, "returnPolicy");
            this.returnPolicy = Optional.ofNullable(returnPolicy);
            return this;
        }

        public Builder returnPolicy(Optional<String> returnPolicy) {
            Utils.checkNotNull(returnPolicy, "returnPolicy");
            this.returnPolicy = returnPolicy;
            return this;
        }

        public FulfillmentDetailsError build() {

            return new FulfillmentDetailsError(
                shipmentDurationDays, returnPolicy);
        }

    }
}
