/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class Fulfillment {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("method")
    private Optional<? extends FulfillmentMethod> method;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("timeframe")
    private Optional<? extends FulfillmentTimeframe> timeframe;

    @JsonCreator
    public Fulfillment(
            @JsonProperty("method") Optional<? extends FulfillmentMethod> method,
            @JsonProperty("timeframe") Optional<? extends FulfillmentTimeframe> timeframe) {
        Utils.checkNotNull(method, "method");
        Utils.checkNotNull(timeframe, "timeframe");
        this.method = method;
        this.timeframe = timeframe;
    }
    
    public Fulfillment() {
        this(Optional.empty(), Optional.empty());
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<FulfillmentMethod> method() {
        return (Optional<FulfillmentMethod>) method;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<FulfillmentTimeframe> timeframe() {
        return (Optional<FulfillmentTimeframe>) timeframe;
    }

    public static Builder builder() {
        return new Builder();
    }


    public Fulfillment withMethod(FulfillmentMethod method) {
        Utils.checkNotNull(method, "method");
        this.method = Optional.ofNullable(method);
        return this;
    }


    public Fulfillment withMethod(Optional<? extends FulfillmentMethod> method) {
        Utils.checkNotNull(method, "method");
        this.method = method;
        return this;
    }

    public Fulfillment withTimeframe(FulfillmentTimeframe timeframe) {
        Utils.checkNotNull(timeframe, "timeframe");
        this.timeframe = Optional.ofNullable(timeframe);
        return this;
    }


    public Fulfillment withTimeframe(Optional<? extends FulfillmentTimeframe> timeframe) {
        Utils.checkNotNull(timeframe, "timeframe");
        this.timeframe = timeframe;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Fulfillment other = (Fulfillment) o;
        return 
            Utils.enhancedDeepEquals(this.method, other.method) &&
            Utils.enhancedDeepEquals(this.timeframe, other.timeframe);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            method, timeframe);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Fulfillment.class,
                "method", method,
                "timeframe", timeframe);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<? extends FulfillmentMethod> method = Optional.empty();

        private Optional<? extends FulfillmentTimeframe> timeframe = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder method(FulfillmentMethod method) {
            Utils.checkNotNull(method, "method");
            this.method = Optional.ofNullable(method);
            return this;
        }

        public Builder method(Optional<? extends FulfillmentMethod> method) {
            Utils.checkNotNull(method, "method");
            this.method = method;
            return this;
        }


        public Builder timeframe(FulfillmentTimeframe timeframe) {
            Utils.checkNotNull(timeframe, "timeframe");
            this.timeframe = Optional.ofNullable(timeframe);
            return this;
        }

        public Builder timeframe(Optional<? extends FulfillmentTimeframe> timeframe) {
            Utils.checkNotNull(timeframe, "timeframe");
            this.timeframe = timeframe;
            return this;
        }

        public Fulfillment build() {

            return new Fulfillment(
                method, timeframe);
        }

    }
}
