/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;


public class FeePlan {

    @JsonProperty("planID")
    private String planID;

    /**
     * The name of the fee plan.
     */
    @JsonProperty("name")
    private String name;

    /**
     * A description of the fee plan.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("description")
    private Optional<String> description;

    /**
     * Specifies the card processing pricing model
     */
    @JsonProperty("cardAcquiringModel")
    private CardAcquiringModel cardAcquiringModel;

    /**
     * Additional usage-based fees for this plan.
     */
    @JsonProperty("billableFees")
    private List<BillableFee> billableFees;

    /**
     * The minimum spending amount that must be met in the billing period. If actual usage is below the minimum amount, account is charged the difference.
     */
    @JsonProperty("minimumCommitment")
    private MinimumCommitment minimumCommitment;

    /**
     * Fixed recurring amount paid in the billing period regardless of usage.
     */
    @JsonProperty("monthlyPlatformFee")
    private MonthlyPlatformFee monthlyPlatformFee;


    @JsonProperty("createdAt")
    private OffsetDateTime createdAt;

    @JsonCreator
    public FeePlan(
            @JsonProperty("planID") String planID,
            @JsonProperty("name") String name,
            @JsonProperty("description") Optional<String> description,
            @JsonProperty("cardAcquiringModel") CardAcquiringModel cardAcquiringModel,
            @JsonProperty("billableFees") List<BillableFee> billableFees,
            @JsonProperty("minimumCommitment") MinimumCommitment minimumCommitment,
            @JsonProperty("monthlyPlatformFee") MonthlyPlatformFee monthlyPlatformFee,
            @JsonProperty("createdAt") OffsetDateTime createdAt) {
        Utils.checkNotNull(planID, "planID");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(cardAcquiringModel, "cardAcquiringModel");
        Utils.checkNotNull(billableFees, "billableFees");
        Utils.checkNotNull(minimumCommitment, "minimumCommitment");
        Utils.checkNotNull(monthlyPlatformFee, "monthlyPlatformFee");
        Utils.checkNotNull(createdAt, "createdAt");
        this.planID = planID;
        this.name = name;
        this.description = description;
        this.cardAcquiringModel = cardAcquiringModel;
        this.billableFees = billableFees;
        this.minimumCommitment = minimumCommitment;
        this.monthlyPlatformFee = monthlyPlatformFee;
        this.createdAt = createdAt;
    }
    
    public FeePlan(
            String planID,
            String name,
            CardAcquiringModel cardAcquiringModel,
            List<BillableFee> billableFees,
            MinimumCommitment minimumCommitment,
            MonthlyPlatformFee monthlyPlatformFee,
            OffsetDateTime createdAt) {
        this(planID, name, Optional.empty(),
            cardAcquiringModel, billableFees, minimumCommitment,
            monthlyPlatformFee, createdAt);
    }

    @JsonIgnore
    public String planID() {
        return planID;
    }

    /**
     * The name of the fee plan.
     */
    @JsonIgnore
    public String name() {
        return name;
    }

    /**
     * A description of the fee plan.
     */
    @JsonIgnore
    public Optional<String> description() {
        return description;
    }

    /**
     * Specifies the card processing pricing model
     */
    @JsonIgnore
    public CardAcquiringModel cardAcquiringModel() {
        return cardAcquiringModel;
    }

    /**
     * Additional usage-based fees for this plan.
     */
    @JsonIgnore
    public List<BillableFee> billableFees() {
        return billableFees;
    }

    /**
     * The minimum spending amount that must be met in the billing period. If actual usage is below the minimum amount, account is charged the difference.
     */
    @JsonIgnore
    public MinimumCommitment minimumCommitment() {
        return minimumCommitment;
    }

    /**
     * Fixed recurring amount paid in the billing period regardless of usage.
     */
    @JsonIgnore
    public MonthlyPlatformFee monthlyPlatformFee() {
        return monthlyPlatformFee;
    }

    @JsonIgnore
    public OffsetDateTime createdAt() {
        return createdAt;
    }

    public static Builder builder() {
        return new Builder();
    }


    public FeePlan withPlanID(String planID) {
        Utils.checkNotNull(planID, "planID");
        this.planID = planID;
        return this;
    }

    /**
     * The name of the fee plan.
     */
    public FeePlan withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * A description of the fee plan.
     */
    public FeePlan withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = Optional.ofNullable(description);
        return this;
    }


    /**
     * A description of the fee plan.
     */
    public FeePlan withDescription(Optional<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    /**
     * Specifies the card processing pricing model
     */
    public FeePlan withCardAcquiringModel(CardAcquiringModel cardAcquiringModel) {
        Utils.checkNotNull(cardAcquiringModel, "cardAcquiringModel");
        this.cardAcquiringModel = cardAcquiringModel;
        return this;
    }

    /**
     * Additional usage-based fees for this plan.
     */
    public FeePlan withBillableFees(List<BillableFee> billableFees) {
        Utils.checkNotNull(billableFees, "billableFees");
        this.billableFees = billableFees;
        return this;
    }

    /**
     * The minimum spending amount that must be met in the billing period. If actual usage is below the minimum amount, account is charged the difference.
     */
    public FeePlan withMinimumCommitment(MinimumCommitment minimumCommitment) {
        Utils.checkNotNull(minimumCommitment, "minimumCommitment");
        this.minimumCommitment = minimumCommitment;
        return this;
    }

    /**
     * Fixed recurring amount paid in the billing period regardless of usage.
     */
    public FeePlan withMonthlyPlatformFee(MonthlyPlatformFee monthlyPlatformFee) {
        Utils.checkNotNull(monthlyPlatformFee, "monthlyPlatformFee");
        this.monthlyPlatformFee = monthlyPlatformFee;
        return this;
    }

    public FeePlan withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FeePlan other = (FeePlan) o;
        return 
            Utils.enhancedDeepEquals(this.planID, other.planID) &&
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.description, other.description) &&
            Utils.enhancedDeepEquals(this.cardAcquiringModel, other.cardAcquiringModel) &&
            Utils.enhancedDeepEquals(this.billableFees, other.billableFees) &&
            Utils.enhancedDeepEquals(this.minimumCommitment, other.minimumCommitment) &&
            Utils.enhancedDeepEquals(this.monthlyPlatformFee, other.monthlyPlatformFee) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            planID, name, description,
            cardAcquiringModel, billableFees, minimumCommitment,
            monthlyPlatformFee, createdAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(FeePlan.class,
                "planID", planID,
                "name", name,
                "description", description,
                "cardAcquiringModel", cardAcquiringModel,
                "billableFees", billableFees,
                "minimumCommitment", minimumCommitment,
                "monthlyPlatformFee", monthlyPlatformFee,
                "createdAt", createdAt);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String planID;

        private String name;

        private Optional<String> description = Optional.empty();

        private CardAcquiringModel cardAcquiringModel;

        private List<BillableFee> billableFees;

        private MinimumCommitment minimumCommitment;

        private MonthlyPlatformFee monthlyPlatformFee;

        private OffsetDateTime createdAt;

        private Builder() {
          // force use of static builder() method
        }


        public Builder planID(String planID) {
            Utils.checkNotNull(planID, "planID");
            this.planID = planID;
            return this;
        }


        /**
         * The name of the fee plan.
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }


        /**
         * A description of the fee plan.
         */
        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = Optional.ofNullable(description);
            return this;
        }

        /**
         * A description of the fee plan.
         */
        public Builder description(Optional<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }


        /**
         * Specifies the card processing pricing model
         */
        public Builder cardAcquiringModel(CardAcquiringModel cardAcquiringModel) {
            Utils.checkNotNull(cardAcquiringModel, "cardAcquiringModel");
            this.cardAcquiringModel = cardAcquiringModel;
            return this;
        }


        /**
         * Additional usage-based fees for this plan.
         */
        public Builder billableFees(List<BillableFee> billableFees) {
            Utils.checkNotNull(billableFees, "billableFees");
            this.billableFees = billableFees;
            return this;
        }


        /**
         * The minimum spending amount that must be met in the billing period. If actual usage is below the minimum amount, account is charged the difference.
         */
        public Builder minimumCommitment(MinimumCommitment minimumCommitment) {
            Utils.checkNotNull(minimumCommitment, "minimumCommitment");
            this.minimumCommitment = minimumCommitment;
            return this;
        }


        /**
         * Fixed recurring amount paid in the billing period regardless of usage.
         */
        public Builder monthlyPlatformFee(MonthlyPlatformFee monthlyPlatformFee) {
            Utils.checkNotNull(monthlyPlatformFee, "monthlyPlatformFee");
            this.monthlyPlatformFee = monthlyPlatformFee;
            return this;
        }


        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public FeePlan build() {

            return new FeePlan(
                planID, name, description,
                cardAcquiringModel, billableFees, minimumCommitment,
                monthlyPlatformFee, createdAt);
        }

    }
}
