/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class EstimatedActivity {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("averageTransactionAmount")
    private Optional<Long> averageTransactionAmount;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("maximumTransactionAmount")
    private Optional<Long> maximumTransactionAmount;

    /**
     * The low value in each range is included. The high value in each range is excluded.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("monthlyVolumeRange")
    private Optional<? extends MonthlyVolumeRange> monthlyVolumeRange;

    @JsonCreator
    public EstimatedActivity(
            @JsonProperty("averageTransactionAmount") Optional<Long> averageTransactionAmount,
            @JsonProperty("maximumTransactionAmount") Optional<Long> maximumTransactionAmount,
            @JsonProperty("monthlyVolumeRange") Optional<? extends MonthlyVolumeRange> monthlyVolumeRange) {
        Utils.checkNotNull(averageTransactionAmount, "averageTransactionAmount");
        Utils.checkNotNull(maximumTransactionAmount, "maximumTransactionAmount");
        Utils.checkNotNull(monthlyVolumeRange, "monthlyVolumeRange");
        this.averageTransactionAmount = averageTransactionAmount;
        this.maximumTransactionAmount = maximumTransactionAmount;
        this.monthlyVolumeRange = monthlyVolumeRange;
    }
    
    public EstimatedActivity() {
        this(Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<Long> averageTransactionAmount() {
        return averageTransactionAmount;
    }

    @JsonIgnore
    public Optional<Long> maximumTransactionAmount() {
        return maximumTransactionAmount;
    }

    /**
     * The low value in each range is included. The high value in each range is excluded.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<MonthlyVolumeRange> monthlyVolumeRange() {
        return (Optional<MonthlyVolumeRange>) monthlyVolumeRange;
    }

    public static Builder builder() {
        return new Builder();
    }


    public EstimatedActivity withAverageTransactionAmount(long averageTransactionAmount) {
        Utils.checkNotNull(averageTransactionAmount, "averageTransactionAmount");
        this.averageTransactionAmount = Optional.ofNullable(averageTransactionAmount);
        return this;
    }


    public EstimatedActivity withAverageTransactionAmount(Optional<Long> averageTransactionAmount) {
        Utils.checkNotNull(averageTransactionAmount, "averageTransactionAmount");
        this.averageTransactionAmount = averageTransactionAmount;
        return this;
    }

    public EstimatedActivity withMaximumTransactionAmount(long maximumTransactionAmount) {
        Utils.checkNotNull(maximumTransactionAmount, "maximumTransactionAmount");
        this.maximumTransactionAmount = Optional.ofNullable(maximumTransactionAmount);
        return this;
    }


    public EstimatedActivity withMaximumTransactionAmount(Optional<Long> maximumTransactionAmount) {
        Utils.checkNotNull(maximumTransactionAmount, "maximumTransactionAmount");
        this.maximumTransactionAmount = maximumTransactionAmount;
        return this;
    }

    /**
     * The low value in each range is included. The high value in each range is excluded.
     */
    public EstimatedActivity withMonthlyVolumeRange(MonthlyVolumeRange monthlyVolumeRange) {
        Utils.checkNotNull(monthlyVolumeRange, "monthlyVolumeRange");
        this.monthlyVolumeRange = Optional.ofNullable(monthlyVolumeRange);
        return this;
    }


    /**
     * The low value in each range is included. The high value in each range is excluded.
     */
    public EstimatedActivity withMonthlyVolumeRange(Optional<? extends MonthlyVolumeRange> monthlyVolumeRange) {
        Utils.checkNotNull(monthlyVolumeRange, "monthlyVolumeRange");
        this.monthlyVolumeRange = monthlyVolumeRange;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EstimatedActivity other = (EstimatedActivity) o;
        return 
            Utils.enhancedDeepEquals(this.averageTransactionAmount, other.averageTransactionAmount) &&
            Utils.enhancedDeepEquals(this.maximumTransactionAmount, other.maximumTransactionAmount) &&
            Utils.enhancedDeepEquals(this.monthlyVolumeRange, other.monthlyVolumeRange);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            averageTransactionAmount, maximumTransactionAmount, monthlyVolumeRange);
    }
    
    @Override
    public String toString() {
        return Utils.toString(EstimatedActivity.class,
                "averageTransactionAmount", averageTransactionAmount,
                "maximumTransactionAmount", maximumTransactionAmount,
                "monthlyVolumeRange", monthlyVolumeRange);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<Long> averageTransactionAmount = Optional.empty();

        private Optional<Long> maximumTransactionAmount = Optional.empty();

        private Optional<? extends MonthlyVolumeRange> monthlyVolumeRange = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder averageTransactionAmount(long averageTransactionAmount) {
            Utils.checkNotNull(averageTransactionAmount, "averageTransactionAmount");
            this.averageTransactionAmount = Optional.ofNullable(averageTransactionAmount);
            return this;
        }

        public Builder averageTransactionAmount(Optional<Long> averageTransactionAmount) {
            Utils.checkNotNull(averageTransactionAmount, "averageTransactionAmount");
            this.averageTransactionAmount = averageTransactionAmount;
            return this;
        }


        public Builder maximumTransactionAmount(long maximumTransactionAmount) {
            Utils.checkNotNull(maximumTransactionAmount, "maximumTransactionAmount");
            this.maximumTransactionAmount = Optional.ofNullable(maximumTransactionAmount);
            return this;
        }

        public Builder maximumTransactionAmount(Optional<Long> maximumTransactionAmount) {
            Utils.checkNotNull(maximumTransactionAmount, "maximumTransactionAmount");
            this.maximumTransactionAmount = maximumTransactionAmount;
            return this;
        }


        /**
         * The low value in each range is included. The high value in each range is excluded.
         */
        public Builder monthlyVolumeRange(MonthlyVolumeRange monthlyVolumeRange) {
            Utils.checkNotNull(monthlyVolumeRange, "monthlyVolumeRange");
            this.monthlyVolumeRange = Optional.ofNullable(monthlyVolumeRange);
            return this;
        }

        /**
         * The low value in each range is included. The high value in each range is excluded.
         */
        public Builder monthlyVolumeRange(Optional<? extends MonthlyVolumeRange> monthlyVolumeRange) {
            Utils.checkNotNull(monthlyVolumeRange, "monthlyVolumeRange");
            this.monthlyVolumeRange = monthlyVolumeRange;
            return this;
        }

        public EstimatedActivity build() {

            return new EstimatedActivity(
                averageTransactionAmount, maximumTransactionAmount, monthlyVolumeRange);
        }

    }
}
