/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;

/**
 * Error
 * 
 * <p>Contains details on why the occurrence errored.
 */
public class Error {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("message")
    private Optional<String> message;

    @JsonCreator
    public Error(
            @JsonProperty("message") Optional<String> message) {
        Utils.checkNotNull(message, "message");
        this.message = message;
    }
    
    public Error() {
        this(Optional.empty());
    }

    @JsonIgnore
    public Optional<String> message() {
        return message;
    }

    public static Builder builder() {
        return new Builder();
    }


    public Error withMessage(String message) {
        Utils.checkNotNull(message, "message");
        this.message = Optional.ofNullable(message);
        return this;
    }


    public Error withMessage(Optional<String> message) {
        Utils.checkNotNull(message, "message");
        this.message = message;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Error other = (Error) o;
        return 
            Utils.enhancedDeepEquals(this.message, other.message);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            message);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Error.class,
                "message", message);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> message = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder message(String message) {
            Utils.checkNotNull(message, "message");
            this.message = Optional.ofNullable(message);
            return this;
        }

        public Builder message(Optional<String> message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }

        public Error build() {

            return new Error(
                message);
        }

    }
}
