/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;

/**
 * E2EEToken
 * 
 * <p>Wraps a compact-serialized JSON Web Encryption (JWE) token used for secure transmission of sensitive data (e.g., PCI information) through intermediaries. 
 * This token is encrypted using the public key from /end-to-end-keys and wraps an AES key. For details and examples, refer to our 
 * [GitHub repository](https://github.com/moovfinancial/moov-go/blob/main/examples/e2ee/e2ee_test.go).
 */
public class E2EEToken {
    /**
     * An [RFC](https://datatracker.ietf.org/doc/html/rfc7516) compact-serialized JSON Web Encryption (JWE) token.
     */
    @JsonProperty("token")
    private String token;

    @JsonCreator
    public E2EEToken(
            @JsonProperty("token") String token) {
        Utils.checkNotNull(token, "token");
        this.token = token;
    }

    /**
     * An [RFC](https://datatracker.ietf.org/doc/html/rfc7516) compact-serialized JSON Web Encryption (JWE) token.
     */
    @JsonIgnore
    public String token() {
        return token;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * An [RFC](https://datatracker.ietf.org/doc/html/rfc7516) compact-serialized JSON Web Encryption (JWE) token.
     */
    public E2EEToken withToken(String token) {
        Utils.checkNotNull(token, "token");
        this.token = token;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        E2EEToken other = (E2EEToken) o;
        return 
            Utils.enhancedDeepEquals(this.token, other.token);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            token);
    }
    
    @Override
    public String toString() {
        return Utils.toString(E2EEToken.class,
                "token", token);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String token;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * An [RFC](https://datatracker.ietf.org/doc/html/rfc7516) compact-serialized JSON Web Encryption (JWE) token.
         */
        public Builder token(String token) {
            Utils.checkNotNull(token, "token");
            this.token = token;
            return this;
        }

        public E2EEToken build() {

            return new E2EEToken(
                token);
        }

    }
}
