/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class CreateTransferSourceCard {
    /**
     * An optional override of the default card statement descriptor for a transfer. Accounts must be enabled by Moov to set this field.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("dynamicDescriptor")
    private Optional<String> dynamicDescriptor;

    /**
     * Specifies the nature and initiator of a transaction. 
     * 
     * <p>Crucial for recurring and merchant-initiated transactions as per card scheme rules. 
     * Omit for customer-initiated e-commerce transactions.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("transactionSource")
    private Optional<? extends TransactionSource> transactionSource;

    @JsonCreator
    public CreateTransferSourceCard(
            @JsonProperty("dynamicDescriptor") Optional<String> dynamicDescriptor,
            @JsonProperty("transactionSource") Optional<? extends TransactionSource> transactionSource) {
        Utils.checkNotNull(dynamicDescriptor, "dynamicDescriptor");
        Utils.checkNotNull(transactionSource, "transactionSource");
        this.dynamicDescriptor = dynamicDescriptor;
        this.transactionSource = transactionSource;
    }
    
    public CreateTransferSourceCard() {
        this(Optional.empty(), Optional.empty());
    }

    /**
     * An optional override of the default card statement descriptor for a transfer. Accounts must be enabled by Moov to set this field.
     */
    @JsonIgnore
    public Optional<String> dynamicDescriptor() {
        return dynamicDescriptor;
    }

    /**
     * Specifies the nature and initiator of a transaction. 
     * 
     * <p>Crucial for recurring and merchant-initiated transactions as per card scheme rules. 
     * Omit for customer-initiated e-commerce transactions.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<TransactionSource> transactionSource() {
        return (Optional<TransactionSource>) transactionSource;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * An optional override of the default card statement descriptor for a transfer. Accounts must be enabled by Moov to set this field.
     */
    public CreateTransferSourceCard withDynamicDescriptor(String dynamicDescriptor) {
        Utils.checkNotNull(dynamicDescriptor, "dynamicDescriptor");
        this.dynamicDescriptor = Optional.ofNullable(dynamicDescriptor);
        return this;
    }


    /**
     * An optional override of the default card statement descriptor for a transfer. Accounts must be enabled by Moov to set this field.
     */
    public CreateTransferSourceCard withDynamicDescriptor(Optional<String> dynamicDescriptor) {
        Utils.checkNotNull(dynamicDescriptor, "dynamicDescriptor");
        this.dynamicDescriptor = dynamicDescriptor;
        return this;
    }

    /**
     * Specifies the nature and initiator of a transaction. 
     * 
     * <p>Crucial for recurring and merchant-initiated transactions as per card scheme rules. 
     * Omit for customer-initiated e-commerce transactions.
     */
    public CreateTransferSourceCard withTransactionSource(TransactionSource transactionSource) {
        Utils.checkNotNull(transactionSource, "transactionSource");
        this.transactionSource = Optional.ofNullable(transactionSource);
        return this;
    }


    /**
     * Specifies the nature and initiator of a transaction. 
     * 
     * <p>Crucial for recurring and merchant-initiated transactions as per card scheme rules. 
     * Omit for customer-initiated e-commerce transactions.
     */
    public CreateTransferSourceCard withTransactionSource(Optional<? extends TransactionSource> transactionSource) {
        Utils.checkNotNull(transactionSource, "transactionSource");
        this.transactionSource = transactionSource;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateTransferSourceCard other = (CreateTransferSourceCard) o;
        return 
            Utils.enhancedDeepEquals(this.dynamicDescriptor, other.dynamicDescriptor) &&
            Utils.enhancedDeepEquals(this.transactionSource, other.transactionSource);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            dynamicDescriptor, transactionSource);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateTransferSourceCard.class,
                "dynamicDescriptor", dynamicDescriptor,
                "transactionSource", transactionSource);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> dynamicDescriptor = Optional.empty();

        private Optional<? extends TransactionSource> transactionSource = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * An optional override of the default card statement descriptor for a transfer. Accounts must be enabled by Moov to set this field.
         */
        public Builder dynamicDescriptor(String dynamicDescriptor) {
            Utils.checkNotNull(dynamicDescriptor, "dynamicDescriptor");
            this.dynamicDescriptor = Optional.ofNullable(dynamicDescriptor);
            return this;
        }

        /**
         * An optional override of the default card statement descriptor for a transfer. Accounts must be enabled by Moov to set this field.
         */
        public Builder dynamicDescriptor(Optional<String> dynamicDescriptor) {
            Utils.checkNotNull(dynamicDescriptor, "dynamicDescriptor");
            this.dynamicDescriptor = dynamicDescriptor;
            return this;
        }


        /**
         * Specifies the nature and initiator of a transaction. 
         * 
         * <p>Crucial for recurring and merchant-initiated transactions as per card scheme rules. 
         * Omit for customer-initiated e-commerce transactions.
         */
        public Builder transactionSource(TransactionSource transactionSource) {
            Utils.checkNotNull(transactionSource, "transactionSource");
            this.transactionSource = Optional.ofNullable(transactionSource);
            return this;
        }

        /**
         * Specifies the nature and initiator of a transaction. 
         * 
         * <p>Crucial for recurring and merchant-initiated transactions as per card scheme rules. 
         * Omit for customer-initiated e-commerce transactions.
         */
        public Builder transactionSource(Optional<? extends TransactionSource> transactionSource) {
            Utils.checkNotNull(transactionSource, "transactionSource");
            this.transactionSource = transactionSource;
            return this;
        }

        public CreateTransferSourceCard build() {

            return new CreateTransferSourceCard(
                dynamicDescriptor, transactionSource);
        }

    }
}
