/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class CreateTransferSourceACH {
    /**
     * An optional override of the default NACHA company entry description for a transfer.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("companyEntryDescription")
    private Optional<String> companyEntryDescription;

    /**
     * An optional override of the default NACHA company name for a transfer.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("originatingCompanyName")
    private Optional<String> originatingCompanyName;

    /**
     * An optional override of your default ACH hold period in banking days. The hold period must be longer than or equal to your default setting.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("debitHoldPeriod")
    private Optional<? extends DebitHoldPeriod> debitHoldPeriod;

    /**
     * Code used to identify the ACH authorization method.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("secCode")
    private Optional<? extends SECCode> secCode;

    @JsonCreator
    public CreateTransferSourceACH(
            @JsonProperty("companyEntryDescription") Optional<String> companyEntryDescription,
            @JsonProperty("originatingCompanyName") Optional<String> originatingCompanyName,
            @JsonProperty("debitHoldPeriod") Optional<? extends DebitHoldPeriod> debitHoldPeriod,
            @JsonProperty("secCode") Optional<? extends SECCode> secCode) {
        Utils.checkNotNull(companyEntryDescription, "companyEntryDescription");
        Utils.checkNotNull(originatingCompanyName, "originatingCompanyName");
        Utils.checkNotNull(debitHoldPeriod, "debitHoldPeriod");
        Utils.checkNotNull(secCode, "secCode");
        this.companyEntryDescription = companyEntryDescription;
        this.originatingCompanyName = originatingCompanyName;
        this.debitHoldPeriod = debitHoldPeriod;
        this.secCode = secCode;
    }
    
    public CreateTransferSourceACH() {
        this(Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty());
    }

    /**
     * An optional override of the default NACHA company entry description for a transfer.
     */
    @JsonIgnore
    public Optional<String> companyEntryDescription() {
        return companyEntryDescription;
    }

    /**
     * An optional override of the default NACHA company name for a transfer.
     */
    @JsonIgnore
    public Optional<String> originatingCompanyName() {
        return originatingCompanyName;
    }

    /**
     * An optional override of your default ACH hold period in banking days. The hold period must be longer than or equal to your default setting.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<DebitHoldPeriod> debitHoldPeriod() {
        return (Optional<DebitHoldPeriod>) debitHoldPeriod;
    }

    /**
     * Code used to identify the ACH authorization method.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<SECCode> secCode() {
        return (Optional<SECCode>) secCode;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * An optional override of the default NACHA company entry description for a transfer.
     */
    public CreateTransferSourceACH withCompanyEntryDescription(String companyEntryDescription) {
        Utils.checkNotNull(companyEntryDescription, "companyEntryDescription");
        this.companyEntryDescription = Optional.ofNullable(companyEntryDescription);
        return this;
    }


    /**
     * An optional override of the default NACHA company entry description for a transfer.
     */
    public CreateTransferSourceACH withCompanyEntryDescription(Optional<String> companyEntryDescription) {
        Utils.checkNotNull(companyEntryDescription, "companyEntryDescription");
        this.companyEntryDescription = companyEntryDescription;
        return this;
    }

    /**
     * An optional override of the default NACHA company name for a transfer.
     */
    public CreateTransferSourceACH withOriginatingCompanyName(String originatingCompanyName) {
        Utils.checkNotNull(originatingCompanyName, "originatingCompanyName");
        this.originatingCompanyName = Optional.ofNullable(originatingCompanyName);
        return this;
    }


    /**
     * An optional override of the default NACHA company name for a transfer.
     */
    public CreateTransferSourceACH withOriginatingCompanyName(Optional<String> originatingCompanyName) {
        Utils.checkNotNull(originatingCompanyName, "originatingCompanyName");
        this.originatingCompanyName = originatingCompanyName;
        return this;
    }

    /**
     * An optional override of your default ACH hold period in banking days. The hold period must be longer than or equal to your default setting.
     */
    public CreateTransferSourceACH withDebitHoldPeriod(DebitHoldPeriod debitHoldPeriod) {
        Utils.checkNotNull(debitHoldPeriod, "debitHoldPeriod");
        this.debitHoldPeriod = Optional.ofNullable(debitHoldPeriod);
        return this;
    }


    /**
     * An optional override of your default ACH hold period in banking days. The hold period must be longer than or equal to your default setting.
     */
    public CreateTransferSourceACH withDebitHoldPeriod(Optional<? extends DebitHoldPeriod> debitHoldPeriod) {
        Utils.checkNotNull(debitHoldPeriod, "debitHoldPeriod");
        this.debitHoldPeriod = debitHoldPeriod;
        return this;
    }

    /**
     * Code used to identify the ACH authorization method.
     */
    public CreateTransferSourceACH withSecCode(SECCode secCode) {
        Utils.checkNotNull(secCode, "secCode");
        this.secCode = Optional.ofNullable(secCode);
        return this;
    }


    /**
     * Code used to identify the ACH authorization method.
     */
    public CreateTransferSourceACH withSecCode(Optional<? extends SECCode> secCode) {
        Utils.checkNotNull(secCode, "secCode");
        this.secCode = secCode;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateTransferSourceACH other = (CreateTransferSourceACH) o;
        return 
            Utils.enhancedDeepEquals(this.companyEntryDescription, other.companyEntryDescription) &&
            Utils.enhancedDeepEquals(this.originatingCompanyName, other.originatingCompanyName) &&
            Utils.enhancedDeepEquals(this.debitHoldPeriod, other.debitHoldPeriod) &&
            Utils.enhancedDeepEquals(this.secCode, other.secCode);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            companyEntryDescription, originatingCompanyName, debitHoldPeriod,
            secCode);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateTransferSourceACH.class,
                "companyEntryDescription", companyEntryDescription,
                "originatingCompanyName", originatingCompanyName,
                "debitHoldPeriod", debitHoldPeriod,
                "secCode", secCode);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> companyEntryDescription = Optional.empty();

        private Optional<String> originatingCompanyName = Optional.empty();

        private Optional<? extends DebitHoldPeriod> debitHoldPeriod = Optional.empty();

        private Optional<? extends SECCode> secCode = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * An optional override of the default NACHA company entry description for a transfer.
         */
        public Builder companyEntryDescription(String companyEntryDescription) {
            Utils.checkNotNull(companyEntryDescription, "companyEntryDescription");
            this.companyEntryDescription = Optional.ofNullable(companyEntryDescription);
            return this;
        }

        /**
         * An optional override of the default NACHA company entry description for a transfer.
         */
        public Builder companyEntryDescription(Optional<String> companyEntryDescription) {
            Utils.checkNotNull(companyEntryDescription, "companyEntryDescription");
            this.companyEntryDescription = companyEntryDescription;
            return this;
        }


        /**
         * An optional override of the default NACHA company name for a transfer.
         */
        public Builder originatingCompanyName(String originatingCompanyName) {
            Utils.checkNotNull(originatingCompanyName, "originatingCompanyName");
            this.originatingCompanyName = Optional.ofNullable(originatingCompanyName);
            return this;
        }

        /**
         * An optional override of the default NACHA company name for a transfer.
         */
        public Builder originatingCompanyName(Optional<String> originatingCompanyName) {
            Utils.checkNotNull(originatingCompanyName, "originatingCompanyName");
            this.originatingCompanyName = originatingCompanyName;
            return this;
        }


        /**
         * An optional override of your default ACH hold period in banking days. The hold period must be longer than or equal to your default setting.
         */
        public Builder debitHoldPeriod(DebitHoldPeriod debitHoldPeriod) {
            Utils.checkNotNull(debitHoldPeriod, "debitHoldPeriod");
            this.debitHoldPeriod = Optional.ofNullable(debitHoldPeriod);
            return this;
        }

        /**
         * An optional override of your default ACH hold period in banking days. The hold period must be longer than or equal to your default setting.
         */
        public Builder debitHoldPeriod(Optional<? extends DebitHoldPeriod> debitHoldPeriod) {
            Utils.checkNotNull(debitHoldPeriod, "debitHoldPeriod");
            this.debitHoldPeriod = debitHoldPeriod;
            return this;
        }


        /**
         * Code used to identify the ACH authorization method.
         */
        public Builder secCode(SECCode secCode) {
            Utils.checkNotNull(secCode, "secCode");
            this.secCode = Optional.ofNullable(secCode);
            return this;
        }

        /**
         * Code used to identify the ACH authorization method.
         */
        public Builder secCode(Optional<? extends SECCode> secCode) {
            Utils.checkNotNull(secCode, "secCode");
            this.secCode = secCode;
            return this;
        }

        public CreateTransferSourceACH build() {

            return new CreateTransferSourceACH(
                companyEntryDescription, originatingCompanyName, debitHoldPeriod,
                secCode);
        }

    }
}
