/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;

/**
 * CreateTransferSource
 * 
 * <p>Where funds for a transfer originate. For the source, you must include either a `paymentMethodID` or a `transferID`.
 */
public class CreateTransferSource {
    /**
     * A `transferID` is used to create a [transfer group](https://docs.moov.io/guides/money-movement/transfer-groups/),
     * associating the new transfer with a parent transfer.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("transferID")
    private Optional<String> transferID;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("paymentMethodID")
    private Optional<String> paymentMethodID;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("paymentToken")
    private Optional<String> paymentToken;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cardDetails")
    private Optional<? extends CreateTransferSourceCard> cardDetails;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("achDetails")
    private Optional<? extends CreateTransferSourceACH> achDetails;

    @JsonCreator
    public CreateTransferSource(
            @JsonProperty("transferID") Optional<String> transferID,
            @JsonProperty("paymentMethodID") Optional<String> paymentMethodID,
            @JsonProperty("paymentToken") Optional<String> paymentToken,
            @JsonProperty("cardDetails") Optional<? extends CreateTransferSourceCard> cardDetails,
            @JsonProperty("achDetails") Optional<? extends CreateTransferSourceACH> achDetails) {
        Utils.checkNotNull(transferID, "transferID");
        Utils.checkNotNull(paymentMethodID, "paymentMethodID");
        Utils.checkNotNull(paymentToken, "paymentToken");
        Utils.checkNotNull(cardDetails, "cardDetails");
        Utils.checkNotNull(achDetails, "achDetails");
        this.transferID = transferID;
        this.paymentMethodID = paymentMethodID;
        this.paymentToken = paymentToken;
        this.cardDetails = cardDetails;
        this.achDetails = achDetails;
    }
    
    public CreateTransferSource() {
        this(Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty(), Optional.empty());
    }

    /**
     * A `transferID` is used to create a [transfer group](https://docs.moov.io/guides/money-movement/transfer-groups/),
     * associating the new transfer with a parent transfer.
     */
    @JsonIgnore
    public Optional<String> transferID() {
        return transferID;
    }

    @JsonIgnore
    public Optional<String> paymentMethodID() {
        return paymentMethodID;
    }

    @JsonIgnore
    public Optional<String> paymentToken() {
        return paymentToken;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CreateTransferSourceCard> cardDetails() {
        return (Optional<CreateTransferSourceCard>) cardDetails;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CreateTransferSourceACH> achDetails() {
        return (Optional<CreateTransferSourceACH>) achDetails;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * A `transferID` is used to create a [transfer group](https://docs.moov.io/guides/money-movement/transfer-groups/),
     * associating the new transfer with a parent transfer.
     */
    public CreateTransferSource withTransferID(String transferID) {
        Utils.checkNotNull(transferID, "transferID");
        this.transferID = Optional.ofNullable(transferID);
        return this;
    }


    /**
     * A `transferID` is used to create a [transfer group](https://docs.moov.io/guides/money-movement/transfer-groups/),
     * associating the new transfer with a parent transfer.
     */
    public CreateTransferSource withTransferID(Optional<String> transferID) {
        Utils.checkNotNull(transferID, "transferID");
        this.transferID = transferID;
        return this;
    }

    public CreateTransferSource withPaymentMethodID(String paymentMethodID) {
        Utils.checkNotNull(paymentMethodID, "paymentMethodID");
        this.paymentMethodID = Optional.ofNullable(paymentMethodID);
        return this;
    }


    public CreateTransferSource withPaymentMethodID(Optional<String> paymentMethodID) {
        Utils.checkNotNull(paymentMethodID, "paymentMethodID");
        this.paymentMethodID = paymentMethodID;
        return this;
    }

    public CreateTransferSource withPaymentToken(String paymentToken) {
        Utils.checkNotNull(paymentToken, "paymentToken");
        this.paymentToken = Optional.ofNullable(paymentToken);
        return this;
    }


    public CreateTransferSource withPaymentToken(Optional<String> paymentToken) {
        Utils.checkNotNull(paymentToken, "paymentToken");
        this.paymentToken = paymentToken;
        return this;
    }

    public CreateTransferSource withCardDetails(CreateTransferSourceCard cardDetails) {
        Utils.checkNotNull(cardDetails, "cardDetails");
        this.cardDetails = Optional.ofNullable(cardDetails);
        return this;
    }


    public CreateTransferSource withCardDetails(Optional<? extends CreateTransferSourceCard> cardDetails) {
        Utils.checkNotNull(cardDetails, "cardDetails");
        this.cardDetails = cardDetails;
        return this;
    }

    public CreateTransferSource withAchDetails(CreateTransferSourceACH achDetails) {
        Utils.checkNotNull(achDetails, "achDetails");
        this.achDetails = Optional.ofNullable(achDetails);
        return this;
    }


    public CreateTransferSource withAchDetails(Optional<? extends CreateTransferSourceACH> achDetails) {
        Utils.checkNotNull(achDetails, "achDetails");
        this.achDetails = achDetails;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateTransferSource other = (CreateTransferSource) o;
        return 
            Utils.enhancedDeepEquals(this.transferID, other.transferID) &&
            Utils.enhancedDeepEquals(this.paymentMethodID, other.paymentMethodID) &&
            Utils.enhancedDeepEquals(this.paymentToken, other.paymentToken) &&
            Utils.enhancedDeepEquals(this.cardDetails, other.cardDetails) &&
            Utils.enhancedDeepEquals(this.achDetails, other.achDetails);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            transferID, paymentMethodID, paymentToken,
            cardDetails, achDetails);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateTransferSource.class,
                "transferID", transferID,
                "paymentMethodID", paymentMethodID,
                "paymentToken", paymentToken,
                "cardDetails", cardDetails,
                "achDetails", achDetails);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> transferID = Optional.empty();

        private Optional<String> paymentMethodID = Optional.empty();

        private Optional<String> paymentToken = Optional.empty();

        private Optional<? extends CreateTransferSourceCard> cardDetails = Optional.empty();

        private Optional<? extends CreateTransferSourceACH> achDetails = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * A `transferID` is used to create a [transfer group](https://docs.moov.io/guides/money-movement/transfer-groups/),
         * associating the new transfer with a parent transfer.
         */
        public Builder transferID(String transferID) {
            Utils.checkNotNull(transferID, "transferID");
            this.transferID = Optional.ofNullable(transferID);
            return this;
        }

        /**
         * A `transferID` is used to create a [transfer group](https://docs.moov.io/guides/money-movement/transfer-groups/),
         * associating the new transfer with a parent transfer.
         */
        public Builder transferID(Optional<String> transferID) {
            Utils.checkNotNull(transferID, "transferID");
            this.transferID = transferID;
            return this;
        }


        public Builder paymentMethodID(String paymentMethodID) {
            Utils.checkNotNull(paymentMethodID, "paymentMethodID");
            this.paymentMethodID = Optional.ofNullable(paymentMethodID);
            return this;
        }

        public Builder paymentMethodID(Optional<String> paymentMethodID) {
            Utils.checkNotNull(paymentMethodID, "paymentMethodID");
            this.paymentMethodID = paymentMethodID;
            return this;
        }


        public Builder paymentToken(String paymentToken) {
            Utils.checkNotNull(paymentToken, "paymentToken");
            this.paymentToken = Optional.ofNullable(paymentToken);
            return this;
        }

        public Builder paymentToken(Optional<String> paymentToken) {
            Utils.checkNotNull(paymentToken, "paymentToken");
            this.paymentToken = paymentToken;
            return this;
        }


        public Builder cardDetails(CreateTransferSourceCard cardDetails) {
            Utils.checkNotNull(cardDetails, "cardDetails");
            this.cardDetails = Optional.ofNullable(cardDetails);
            return this;
        }

        public Builder cardDetails(Optional<? extends CreateTransferSourceCard> cardDetails) {
            Utils.checkNotNull(cardDetails, "cardDetails");
            this.cardDetails = cardDetails;
            return this;
        }


        public Builder achDetails(CreateTransferSourceACH achDetails) {
            Utils.checkNotNull(achDetails, "achDetails");
            this.achDetails = Optional.ofNullable(achDetails);
            return this;
        }

        public Builder achDetails(Optional<? extends CreateTransferSourceACH> achDetails) {
            Utils.checkNotNull(achDetails, "achDetails");
            this.achDetails = achDetails;
            return this;
        }

        public CreateTransferSource build() {

            return new CreateTransferSource(
                transferID, paymentMethodID, paymentToken,
                cardDetails, achDetails);
        }

    }
}
