/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class CreateTransferOptions {

    @JsonProperty("source")
    private SourceDestinationOptions source;


    @JsonProperty("destination")
    private SourceDestinationOptions destination;


    @JsonProperty("amount")
    private Amount amount;

    @JsonCreator
    public CreateTransferOptions(
            @JsonProperty("source") SourceDestinationOptions source,
            @JsonProperty("destination") SourceDestinationOptions destination,
            @JsonProperty("amount") Amount amount) {
        Utils.checkNotNull(source, "source");
        Utils.checkNotNull(destination, "destination");
        Utils.checkNotNull(amount, "amount");
        this.source = source;
        this.destination = destination;
        this.amount = amount;
    }

    @JsonIgnore
    public SourceDestinationOptions source() {
        return source;
    }

    @JsonIgnore
    public SourceDestinationOptions destination() {
        return destination;
    }

    @JsonIgnore
    public Amount amount() {
        return amount;
    }

    public static Builder builder() {
        return new Builder();
    }


    public CreateTransferOptions withSource(SourceDestinationOptions source) {
        Utils.checkNotNull(source, "source");
        this.source = source;
        return this;
    }

    public CreateTransferOptions withDestination(SourceDestinationOptions destination) {
        Utils.checkNotNull(destination, "destination");
        this.destination = destination;
        return this;
    }

    public CreateTransferOptions withAmount(Amount amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateTransferOptions other = (CreateTransferOptions) o;
        return 
            Utils.enhancedDeepEquals(this.source, other.source) &&
            Utils.enhancedDeepEquals(this.destination, other.destination) &&
            Utils.enhancedDeepEquals(this.amount, other.amount);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            source, destination, amount);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateTransferOptions.class,
                "source", source,
                "destination", destination,
                "amount", amount);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private SourceDestinationOptions source;

        private SourceDestinationOptions destination;

        private Amount amount;

        private Builder() {
          // force use of static builder() method
        }


        public Builder source(SourceDestinationOptions source) {
            Utils.checkNotNull(source, "source");
            this.source = source;
            return this;
        }


        public Builder destination(SourceDestinationOptions destination) {
            Utils.checkNotNull(destination, "destination");
            this.destination = destination;
            return this;
        }


        public Builder amount(Amount amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }

        public CreateTransferOptions build() {

            return new CreateTransferOptions(
                source, destination, amount);
        }

    }
}
