/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class CreateTransferDestinationACH {
    /**
     * An optional override of the default NACHA company entry description for a transfer.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("companyEntryDescription")
    private Optional<String> companyEntryDescription;

    /**
     * An optional override of the default NACHA company name for a transfer.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("originatingCompanyName")
    private Optional<String> originatingCompanyName;

    @JsonCreator
    public CreateTransferDestinationACH(
            @JsonProperty("companyEntryDescription") Optional<String> companyEntryDescription,
            @JsonProperty("originatingCompanyName") Optional<String> originatingCompanyName) {
        Utils.checkNotNull(companyEntryDescription, "companyEntryDescription");
        Utils.checkNotNull(originatingCompanyName, "originatingCompanyName");
        this.companyEntryDescription = companyEntryDescription;
        this.originatingCompanyName = originatingCompanyName;
    }
    
    public CreateTransferDestinationACH() {
        this(Optional.empty(), Optional.empty());
    }

    /**
     * An optional override of the default NACHA company entry description for a transfer.
     */
    @JsonIgnore
    public Optional<String> companyEntryDescription() {
        return companyEntryDescription;
    }

    /**
     * An optional override of the default NACHA company name for a transfer.
     */
    @JsonIgnore
    public Optional<String> originatingCompanyName() {
        return originatingCompanyName;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * An optional override of the default NACHA company entry description for a transfer.
     */
    public CreateTransferDestinationACH withCompanyEntryDescription(String companyEntryDescription) {
        Utils.checkNotNull(companyEntryDescription, "companyEntryDescription");
        this.companyEntryDescription = Optional.ofNullable(companyEntryDescription);
        return this;
    }


    /**
     * An optional override of the default NACHA company entry description for a transfer.
     */
    public CreateTransferDestinationACH withCompanyEntryDescription(Optional<String> companyEntryDescription) {
        Utils.checkNotNull(companyEntryDescription, "companyEntryDescription");
        this.companyEntryDescription = companyEntryDescription;
        return this;
    }

    /**
     * An optional override of the default NACHA company name for a transfer.
     */
    public CreateTransferDestinationACH withOriginatingCompanyName(String originatingCompanyName) {
        Utils.checkNotNull(originatingCompanyName, "originatingCompanyName");
        this.originatingCompanyName = Optional.ofNullable(originatingCompanyName);
        return this;
    }


    /**
     * An optional override of the default NACHA company name for a transfer.
     */
    public CreateTransferDestinationACH withOriginatingCompanyName(Optional<String> originatingCompanyName) {
        Utils.checkNotNull(originatingCompanyName, "originatingCompanyName");
        this.originatingCompanyName = originatingCompanyName;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateTransferDestinationACH other = (CreateTransferDestinationACH) o;
        return 
            Utils.enhancedDeepEquals(this.companyEntryDescription, other.companyEntryDescription) &&
            Utils.enhancedDeepEquals(this.originatingCompanyName, other.originatingCompanyName);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            companyEntryDescription, originatingCompanyName);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateTransferDestinationACH.class,
                "companyEntryDescription", companyEntryDescription,
                "originatingCompanyName", originatingCompanyName);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> companyEntryDescription = Optional.empty();

        private Optional<String> originatingCompanyName = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * An optional override of the default NACHA company entry description for a transfer.
         */
        public Builder companyEntryDescription(String companyEntryDescription) {
            Utils.checkNotNull(companyEntryDescription, "companyEntryDescription");
            this.companyEntryDescription = Optional.ofNullable(companyEntryDescription);
            return this;
        }

        /**
         * An optional override of the default NACHA company entry description for a transfer.
         */
        public Builder companyEntryDescription(Optional<String> companyEntryDescription) {
            Utils.checkNotNull(companyEntryDescription, "companyEntryDescription");
            this.companyEntryDescription = companyEntryDescription;
            return this;
        }


        /**
         * An optional override of the default NACHA company name for a transfer.
         */
        public Builder originatingCompanyName(String originatingCompanyName) {
            Utils.checkNotNull(originatingCompanyName, "originatingCompanyName");
            this.originatingCompanyName = Optional.ofNullable(originatingCompanyName);
            return this;
        }

        /**
         * An optional override of the default NACHA company name for a transfer.
         */
        public Builder originatingCompanyName(Optional<String> originatingCompanyName) {
            Utils.checkNotNull(originatingCompanyName, "originatingCompanyName");
            this.originatingCompanyName = originatingCompanyName;
            return this;
        }

        public CreateTransferDestinationACH build() {

            return new CreateTransferDestinationACH(
                companyEntryDescription, originatingCompanyName);
        }

    }
}
