/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class CreateTicketContactError {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("email")
    private Optional<String> email;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private Optional<String> name;

    @JsonCreator
    public CreateTicketContactError(
            @JsonProperty("email") Optional<String> email,
            @JsonProperty("name") Optional<String> name) {
        Utils.checkNotNull(email, "email");
        Utils.checkNotNull(name, "name");
        this.email = email;
        this.name = name;
    }
    
    public CreateTicketContactError() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> email() {
        return email;
    }

    @JsonIgnore
    public Optional<String> name() {
        return name;
    }

    public static Builder builder() {
        return new Builder();
    }


    public CreateTicketContactError withEmail(String email) {
        Utils.checkNotNull(email, "email");
        this.email = Optional.ofNullable(email);
        return this;
    }


    public CreateTicketContactError withEmail(Optional<String> email) {
        Utils.checkNotNull(email, "email");
        this.email = email;
        return this;
    }

    public CreateTicketContactError withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = Optional.ofNullable(name);
        return this;
    }


    public CreateTicketContactError withName(Optional<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateTicketContactError other = (CreateTicketContactError) o;
        return 
            Utils.enhancedDeepEquals(this.email, other.email) &&
            Utils.enhancedDeepEquals(this.name, other.name);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            email, name);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateTicketContactError.class,
                "email", email,
                "name", name);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> email = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder email(String email) {
            Utils.checkNotNull(email, "email");
            this.email = Optional.ofNullable(email);
            return this;
        }

        public Builder email(Optional<String> email) {
            Utils.checkNotNull(email, "email");
            this.email = email;
            return this;
        }


        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Optional<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public CreateTicketContactError build() {

            return new CreateTicketContactError(
                email, name);
        }

    }
}
