/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;

/**
 * CreateTicket
 * 
 * <p>Request to create a new support ticket.
 */
public class CreateTicket {

    @JsonProperty("title")
    private String title;


    @JsonProperty("body")
    private String body;


    @JsonProperty("contact")
    private TicketContact contact;

    @JsonCreator
    public CreateTicket(
            @JsonProperty("title") String title,
            @JsonProperty("body") String body,
            @JsonProperty("contact") TicketContact contact) {
        Utils.checkNotNull(title, "title");
        Utils.checkNotNull(body, "body");
        Utils.checkNotNull(contact, "contact");
        this.title = title;
        this.body = body;
        this.contact = contact;
    }

    @JsonIgnore
    public String title() {
        return title;
    }

    @JsonIgnore
    public String body() {
        return body;
    }

    @JsonIgnore
    public TicketContact contact() {
        return contact;
    }

    public static Builder builder() {
        return new Builder();
    }


    public CreateTicket withTitle(String title) {
        Utils.checkNotNull(title, "title");
        this.title = title;
        return this;
    }

    public CreateTicket withBody(String body) {
        Utils.checkNotNull(body, "body");
        this.body = body;
        return this;
    }

    public CreateTicket withContact(TicketContact contact) {
        Utils.checkNotNull(contact, "contact");
        this.contact = contact;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateTicket other = (CreateTicket) o;
        return 
            Utils.enhancedDeepEquals(this.title, other.title) &&
            Utils.enhancedDeepEquals(this.body, other.body) &&
            Utils.enhancedDeepEquals(this.contact, other.contact);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            title, body, contact);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateTicket.class,
                "title", title,
                "body", body,
                "contact", contact);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String title;

        private String body;

        private TicketContact contact;

        private Builder() {
          // force use of static builder() method
        }


        public Builder title(String title) {
            Utils.checkNotNull(title, "title");
            this.title = title;
            return this;
        }


        public Builder body(String body) {
            Utils.checkNotNull(body, "body");
            this.body = body;
            return this;
        }


        public Builder contact(TicketContact contact) {
            Utils.checkNotNull(contact, "contact");
            this.contact = contact;
            return this;
        }

        public CreateTicket build() {

            return new CreateTicket(
                title, body, contact);
        }

    }
}
