/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class CreateProfileError {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("individual")
    private Optional<? extends CreateIndividualError> individual;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("business")
    private Optional<? extends CreateBusinessError> business;

    @JsonCreator
    public CreateProfileError(
            @JsonProperty("individual") Optional<? extends CreateIndividualError> individual,
            @JsonProperty("business") Optional<? extends CreateBusinessError> business) {
        Utils.checkNotNull(individual, "individual");
        Utils.checkNotNull(business, "business");
        this.individual = individual;
        this.business = business;
    }
    
    public CreateProfileError() {
        this(Optional.empty(), Optional.empty());
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CreateIndividualError> individual() {
        return (Optional<CreateIndividualError>) individual;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CreateBusinessError> business() {
        return (Optional<CreateBusinessError>) business;
    }

    public static Builder builder() {
        return new Builder();
    }


    public CreateProfileError withIndividual(CreateIndividualError individual) {
        Utils.checkNotNull(individual, "individual");
        this.individual = Optional.ofNullable(individual);
        return this;
    }


    public CreateProfileError withIndividual(Optional<? extends CreateIndividualError> individual) {
        Utils.checkNotNull(individual, "individual");
        this.individual = individual;
        return this;
    }

    public CreateProfileError withBusiness(CreateBusinessError business) {
        Utils.checkNotNull(business, "business");
        this.business = Optional.ofNullable(business);
        return this;
    }


    public CreateProfileError withBusiness(Optional<? extends CreateBusinessError> business) {
        Utils.checkNotNull(business, "business");
        this.business = business;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateProfileError other = (CreateProfileError) o;
        return 
            Utils.enhancedDeepEquals(this.individual, other.individual) &&
            Utils.enhancedDeepEquals(this.business, other.business);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            individual, business);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateProfileError.class,
                "individual", individual,
                "business", business);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<? extends CreateIndividualError> individual = Optional.empty();

        private Optional<? extends CreateBusinessError> business = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder individual(CreateIndividualError individual) {
            Utils.checkNotNull(individual, "individual");
            this.individual = Optional.ofNullable(individual);
            return this;
        }

        public Builder individual(Optional<? extends CreateIndividualError> individual) {
            Utils.checkNotNull(individual, "individual");
            this.individual = individual;
            return this;
        }


        public Builder business(CreateBusinessError business) {
            Utils.checkNotNull(business, "business");
            this.business = Optional.ofNullable(business);
            return this;
        }

        public Builder business(Optional<? extends CreateBusinessError> business) {
            Utils.checkNotNull(business, "business");
            this.business = business;
            return this;
        }

        public CreateProfileError build() {

            return new CreateProfileError(
                individual, business);
        }

    }
}
