/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class CreateProfile {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("individual")
    private Optional<? extends CreateIndividualProfile> individual;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("business")
    private Optional<? extends CreateBusinessProfile> business;

    @JsonCreator
    public CreateProfile(
            @JsonProperty("individual") Optional<? extends CreateIndividualProfile> individual,
            @JsonProperty("business") Optional<? extends CreateBusinessProfile> business) {
        Utils.checkNotNull(individual, "individual");
        Utils.checkNotNull(business, "business");
        this.individual = individual;
        this.business = business;
    }
    
    public CreateProfile() {
        this(Optional.empty(), Optional.empty());
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CreateIndividualProfile> individual() {
        return (Optional<CreateIndividualProfile>) individual;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CreateBusinessProfile> business() {
        return (Optional<CreateBusinessProfile>) business;
    }

    public static Builder builder() {
        return new Builder();
    }


    public CreateProfile withIndividual(CreateIndividualProfile individual) {
        Utils.checkNotNull(individual, "individual");
        this.individual = Optional.ofNullable(individual);
        return this;
    }


    public CreateProfile withIndividual(Optional<? extends CreateIndividualProfile> individual) {
        Utils.checkNotNull(individual, "individual");
        this.individual = individual;
        return this;
    }

    public CreateProfile withBusiness(CreateBusinessProfile business) {
        Utils.checkNotNull(business, "business");
        this.business = Optional.ofNullable(business);
        return this;
    }


    public CreateProfile withBusiness(Optional<? extends CreateBusinessProfile> business) {
        Utils.checkNotNull(business, "business");
        this.business = business;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateProfile other = (CreateProfile) o;
        return 
            Utils.enhancedDeepEquals(this.individual, other.individual) &&
            Utils.enhancedDeepEquals(this.business, other.business);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            individual, business);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateProfile.class,
                "individual", individual,
                "business", business);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<? extends CreateIndividualProfile> individual = Optional.empty();

        private Optional<? extends CreateBusinessProfile> business = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder individual(CreateIndividualProfile individual) {
            Utils.checkNotNull(individual, "individual");
            this.individual = Optional.ofNullable(individual);
            return this;
        }

        public Builder individual(Optional<? extends CreateIndividualProfile> individual) {
            Utils.checkNotNull(individual, "individual");
            this.individual = individual;
            return this;
        }


        public Builder business(CreateBusinessProfile business) {
            Utils.checkNotNull(business, "business");
            this.business = Optional.ofNullable(business);
            return this;
        }

        public Builder business(Optional<? extends CreateBusinessProfile> business) {
            Utils.checkNotNull(business, "business");
            this.business = business;
            return this;
        }

        public CreateProfile build() {

            return new CreateProfile(
                individual, business);
        }

    }
}
