/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class CreateAuthorizedUserError {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("firstName")
    private Optional<String> firstName;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("lastName")
    private Optional<String> lastName;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("birthDate")
    private Optional<? extends BirthDateError> birthDate;

    @JsonCreator
    public CreateAuthorizedUserError(
            @JsonProperty("firstName") Optional<String> firstName,
            @JsonProperty("lastName") Optional<String> lastName,
            @JsonProperty("birthDate") Optional<? extends BirthDateError> birthDate) {
        Utils.checkNotNull(firstName, "firstName");
        Utils.checkNotNull(lastName, "lastName");
        Utils.checkNotNull(birthDate, "birthDate");
        this.firstName = firstName;
        this.lastName = lastName;
        this.birthDate = birthDate;
    }
    
    public CreateAuthorizedUserError() {
        this(Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> firstName() {
        return firstName;
    }

    @JsonIgnore
    public Optional<String> lastName() {
        return lastName;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<BirthDateError> birthDate() {
        return (Optional<BirthDateError>) birthDate;
    }

    public static Builder builder() {
        return new Builder();
    }


    public CreateAuthorizedUserError withFirstName(String firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = Optional.ofNullable(firstName);
        return this;
    }


    public CreateAuthorizedUserError withFirstName(Optional<String> firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = firstName;
        return this;
    }

    public CreateAuthorizedUserError withLastName(String lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = Optional.ofNullable(lastName);
        return this;
    }


    public CreateAuthorizedUserError withLastName(Optional<String> lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = lastName;
        return this;
    }

    public CreateAuthorizedUserError withBirthDate(BirthDateError birthDate) {
        Utils.checkNotNull(birthDate, "birthDate");
        this.birthDate = Optional.ofNullable(birthDate);
        return this;
    }


    public CreateAuthorizedUserError withBirthDate(Optional<? extends BirthDateError> birthDate) {
        Utils.checkNotNull(birthDate, "birthDate");
        this.birthDate = birthDate;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateAuthorizedUserError other = (CreateAuthorizedUserError) o;
        return 
            Utils.enhancedDeepEquals(this.firstName, other.firstName) &&
            Utils.enhancedDeepEquals(this.lastName, other.lastName) &&
            Utils.enhancedDeepEquals(this.birthDate, other.birthDate);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            firstName, lastName, birthDate);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateAuthorizedUserError.class,
                "firstName", firstName,
                "lastName", lastName,
                "birthDate", birthDate);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> firstName = Optional.empty();

        private Optional<String> lastName = Optional.empty();

        private Optional<? extends BirthDateError> birthDate = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder firstName(String firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = Optional.ofNullable(firstName);
            return this;
        }

        public Builder firstName(Optional<String> firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = firstName;
            return this;
        }


        public Builder lastName(String lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = Optional.ofNullable(lastName);
            return this;
        }

        public Builder lastName(Optional<String> lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = lastName;
            return this;
        }


        public Builder birthDate(BirthDateError birthDate) {
            Utils.checkNotNull(birthDate, "birthDate");
            this.birthDate = Optional.ofNullable(birthDate);
            return this;
        }

        public Builder birthDate(Optional<? extends BirthDateError> birthDate) {
            Utils.checkNotNull(birthDate, "birthDate");
            this.birthDate = birthDate;
            return this;
        }

        public CreateAuthorizedUserError build() {

            return new CreateAuthorizedUserError(
                firstName, lastName, birthDate);
        }

    }
}
