/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class ColorsValidationError {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("light")
    private Optional<? extends BrandColorValidationError> light;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("dark")
    private Optional<? extends BrandColorValidationError> dark;

    @JsonCreator
    public ColorsValidationError(
            @JsonProperty("light") Optional<? extends BrandColorValidationError> light,
            @JsonProperty("dark") Optional<? extends BrandColorValidationError> dark) {
        Utils.checkNotNull(light, "light");
        Utils.checkNotNull(dark, "dark");
        this.light = light;
        this.dark = dark;
    }
    
    public ColorsValidationError() {
        this(Optional.empty(), Optional.empty());
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<BrandColorValidationError> light() {
        return (Optional<BrandColorValidationError>) light;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<BrandColorValidationError> dark() {
        return (Optional<BrandColorValidationError>) dark;
    }

    public static Builder builder() {
        return new Builder();
    }


    public ColorsValidationError withLight(BrandColorValidationError light) {
        Utils.checkNotNull(light, "light");
        this.light = Optional.ofNullable(light);
        return this;
    }


    public ColorsValidationError withLight(Optional<? extends BrandColorValidationError> light) {
        Utils.checkNotNull(light, "light");
        this.light = light;
        return this;
    }

    public ColorsValidationError withDark(BrandColorValidationError dark) {
        Utils.checkNotNull(dark, "dark");
        this.dark = Optional.ofNullable(dark);
        return this;
    }


    public ColorsValidationError withDark(Optional<? extends BrandColorValidationError> dark) {
        Utils.checkNotNull(dark, "dark");
        this.dark = dark;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ColorsValidationError other = (ColorsValidationError) o;
        return 
            Utils.enhancedDeepEquals(this.light, other.light) &&
            Utils.enhancedDeepEquals(this.dark, other.dark);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            light, dark);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ColorsValidationError.class,
                "light", light,
                "dark", dark);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<? extends BrandColorValidationError> light = Optional.empty();

        private Optional<? extends BrandColorValidationError> dark = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder light(BrandColorValidationError light) {
            Utils.checkNotNull(light, "light");
            this.light = Optional.ofNullable(light);
            return this;
        }

        public Builder light(Optional<? extends BrandColorValidationError> light) {
            Utils.checkNotNull(light, "light");
            this.light = light;
            return this;
        }


        public Builder dark(BrandColorValidationError dark) {
            Utils.checkNotNull(dark, "dark");
            this.dark = Optional.ofNullable(dark);
            return this;
        }

        public Builder dark(Optional<? extends BrandColorValidationError> dark) {
            Utils.checkNotNull(dark, "dark");
            this.dark = dark;
            return this;
        }

        public ColorsValidationError build() {

            return new ColorsValidationError(
                light, dark);
        }

    }
}
