/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Boolean;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class CollectFundsCardPayments {
    /**
     * Describes the distribution of card transactions by payment method.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cardAcceptanceMethods")
    private Optional<? extends CardAcceptanceMethods> cardAcceptanceMethods;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("currentlyAcceptsCards")
    private Optional<Boolean> currentlyAcceptsCards;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("estimatedActivity")
    private Optional<? extends EstimatedActivity> estimatedActivity;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("fulfillment")
    private Optional<? extends Fulfillment> fulfillment;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("refundPolicy")
    private Optional<? extends RefundPolicy> refundPolicy;

    @JsonCreator
    public CollectFundsCardPayments(
            @JsonProperty("cardAcceptanceMethods") Optional<? extends CardAcceptanceMethods> cardAcceptanceMethods,
            @JsonProperty("currentlyAcceptsCards") Optional<Boolean> currentlyAcceptsCards,
            @JsonProperty("estimatedActivity") Optional<? extends EstimatedActivity> estimatedActivity,
            @JsonProperty("fulfillment") Optional<? extends Fulfillment> fulfillment,
            @JsonProperty("refundPolicy") Optional<? extends RefundPolicy> refundPolicy) {
        Utils.checkNotNull(cardAcceptanceMethods, "cardAcceptanceMethods");
        Utils.checkNotNull(currentlyAcceptsCards, "currentlyAcceptsCards");
        Utils.checkNotNull(estimatedActivity, "estimatedActivity");
        Utils.checkNotNull(fulfillment, "fulfillment");
        Utils.checkNotNull(refundPolicy, "refundPolicy");
        this.cardAcceptanceMethods = cardAcceptanceMethods;
        this.currentlyAcceptsCards = currentlyAcceptsCards;
        this.estimatedActivity = estimatedActivity;
        this.fulfillment = fulfillment;
        this.refundPolicy = refundPolicy;
    }
    
    public CollectFundsCardPayments() {
        this(Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty(), Optional.empty());
    }

    /**
     * Describes the distribution of card transactions by payment method.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CardAcceptanceMethods> cardAcceptanceMethods() {
        return (Optional<CardAcceptanceMethods>) cardAcceptanceMethods;
    }

    @JsonIgnore
    public Optional<Boolean> currentlyAcceptsCards() {
        return currentlyAcceptsCards;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<EstimatedActivity> estimatedActivity() {
        return (Optional<EstimatedActivity>) estimatedActivity;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Fulfillment> fulfillment() {
        return (Optional<Fulfillment>) fulfillment;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<RefundPolicy> refundPolicy() {
        return (Optional<RefundPolicy>) refundPolicy;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Describes the distribution of card transactions by payment method.
     */
    public CollectFundsCardPayments withCardAcceptanceMethods(CardAcceptanceMethods cardAcceptanceMethods) {
        Utils.checkNotNull(cardAcceptanceMethods, "cardAcceptanceMethods");
        this.cardAcceptanceMethods = Optional.ofNullable(cardAcceptanceMethods);
        return this;
    }


    /**
     * Describes the distribution of card transactions by payment method.
     */
    public CollectFundsCardPayments withCardAcceptanceMethods(Optional<? extends CardAcceptanceMethods> cardAcceptanceMethods) {
        Utils.checkNotNull(cardAcceptanceMethods, "cardAcceptanceMethods");
        this.cardAcceptanceMethods = cardAcceptanceMethods;
        return this;
    }

    public CollectFundsCardPayments withCurrentlyAcceptsCards(boolean currentlyAcceptsCards) {
        Utils.checkNotNull(currentlyAcceptsCards, "currentlyAcceptsCards");
        this.currentlyAcceptsCards = Optional.ofNullable(currentlyAcceptsCards);
        return this;
    }


    public CollectFundsCardPayments withCurrentlyAcceptsCards(Optional<Boolean> currentlyAcceptsCards) {
        Utils.checkNotNull(currentlyAcceptsCards, "currentlyAcceptsCards");
        this.currentlyAcceptsCards = currentlyAcceptsCards;
        return this;
    }

    public CollectFundsCardPayments withEstimatedActivity(EstimatedActivity estimatedActivity) {
        Utils.checkNotNull(estimatedActivity, "estimatedActivity");
        this.estimatedActivity = Optional.ofNullable(estimatedActivity);
        return this;
    }


    public CollectFundsCardPayments withEstimatedActivity(Optional<? extends EstimatedActivity> estimatedActivity) {
        Utils.checkNotNull(estimatedActivity, "estimatedActivity");
        this.estimatedActivity = estimatedActivity;
        return this;
    }

    public CollectFundsCardPayments withFulfillment(Fulfillment fulfillment) {
        Utils.checkNotNull(fulfillment, "fulfillment");
        this.fulfillment = Optional.ofNullable(fulfillment);
        return this;
    }


    public CollectFundsCardPayments withFulfillment(Optional<? extends Fulfillment> fulfillment) {
        Utils.checkNotNull(fulfillment, "fulfillment");
        this.fulfillment = fulfillment;
        return this;
    }

    public CollectFundsCardPayments withRefundPolicy(RefundPolicy refundPolicy) {
        Utils.checkNotNull(refundPolicy, "refundPolicy");
        this.refundPolicy = Optional.ofNullable(refundPolicy);
        return this;
    }


    public CollectFundsCardPayments withRefundPolicy(Optional<? extends RefundPolicy> refundPolicy) {
        Utils.checkNotNull(refundPolicy, "refundPolicy");
        this.refundPolicy = refundPolicy;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CollectFundsCardPayments other = (CollectFundsCardPayments) o;
        return 
            Utils.enhancedDeepEquals(this.cardAcceptanceMethods, other.cardAcceptanceMethods) &&
            Utils.enhancedDeepEquals(this.currentlyAcceptsCards, other.currentlyAcceptsCards) &&
            Utils.enhancedDeepEquals(this.estimatedActivity, other.estimatedActivity) &&
            Utils.enhancedDeepEquals(this.fulfillment, other.fulfillment) &&
            Utils.enhancedDeepEquals(this.refundPolicy, other.refundPolicy);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            cardAcceptanceMethods, currentlyAcceptsCards, estimatedActivity,
            fulfillment, refundPolicy);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CollectFundsCardPayments.class,
                "cardAcceptanceMethods", cardAcceptanceMethods,
                "currentlyAcceptsCards", currentlyAcceptsCards,
                "estimatedActivity", estimatedActivity,
                "fulfillment", fulfillment,
                "refundPolicy", refundPolicy);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<? extends CardAcceptanceMethods> cardAcceptanceMethods = Optional.empty();

        private Optional<Boolean> currentlyAcceptsCards = Optional.empty();

        private Optional<? extends EstimatedActivity> estimatedActivity = Optional.empty();

        private Optional<? extends Fulfillment> fulfillment = Optional.empty();

        private Optional<? extends RefundPolicy> refundPolicy = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Describes the distribution of card transactions by payment method.
         */
        public Builder cardAcceptanceMethods(CardAcceptanceMethods cardAcceptanceMethods) {
            Utils.checkNotNull(cardAcceptanceMethods, "cardAcceptanceMethods");
            this.cardAcceptanceMethods = Optional.ofNullable(cardAcceptanceMethods);
            return this;
        }

        /**
         * Describes the distribution of card transactions by payment method.
         */
        public Builder cardAcceptanceMethods(Optional<? extends CardAcceptanceMethods> cardAcceptanceMethods) {
            Utils.checkNotNull(cardAcceptanceMethods, "cardAcceptanceMethods");
            this.cardAcceptanceMethods = cardAcceptanceMethods;
            return this;
        }


        public Builder currentlyAcceptsCards(boolean currentlyAcceptsCards) {
            Utils.checkNotNull(currentlyAcceptsCards, "currentlyAcceptsCards");
            this.currentlyAcceptsCards = Optional.ofNullable(currentlyAcceptsCards);
            return this;
        }

        public Builder currentlyAcceptsCards(Optional<Boolean> currentlyAcceptsCards) {
            Utils.checkNotNull(currentlyAcceptsCards, "currentlyAcceptsCards");
            this.currentlyAcceptsCards = currentlyAcceptsCards;
            return this;
        }


        public Builder estimatedActivity(EstimatedActivity estimatedActivity) {
            Utils.checkNotNull(estimatedActivity, "estimatedActivity");
            this.estimatedActivity = Optional.ofNullable(estimatedActivity);
            return this;
        }

        public Builder estimatedActivity(Optional<? extends EstimatedActivity> estimatedActivity) {
            Utils.checkNotNull(estimatedActivity, "estimatedActivity");
            this.estimatedActivity = estimatedActivity;
            return this;
        }


        public Builder fulfillment(Fulfillment fulfillment) {
            Utils.checkNotNull(fulfillment, "fulfillment");
            this.fulfillment = Optional.ofNullable(fulfillment);
            return this;
        }

        public Builder fulfillment(Optional<? extends Fulfillment> fulfillment) {
            Utils.checkNotNull(fulfillment, "fulfillment");
            this.fulfillment = fulfillment;
            return this;
        }


        public Builder refundPolicy(RefundPolicy refundPolicy) {
            Utils.checkNotNull(refundPolicy, "refundPolicy");
            this.refundPolicy = Optional.ofNullable(refundPolicy);
            return this;
        }

        public Builder refundPolicy(Optional<? extends RefundPolicy> refundPolicy) {
            Utils.checkNotNull(refundPolicy, "refundPolicy");
            this.refundPolicy = refundPolicy;
            return this;
        }

        public CollectFundsCardPayments build() {

            return new CollectFundsCardPayments(
                cardAcceptanceMethods, currentlyAcceptsCards, estimatedActivity,
                fulfillment, refundPolicy);
        }

    }
}
