/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class CollectFunds {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("ach")
    private Optional<? extends CollectFundsAch> ach;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cardPayments")
    private Optional<? extends CollectFundsCardPayments> cardPayments;

    @JsonCreator
    public CollectFunds(
            @JsonProperty("ach") Optional<? extends CollectFundsAch> ach,
            @JsonProperty("cardPayments") Optional<? extends CollectFundsCardPayments> cardPayments) {
        Utils.checkNotNull(ach, "ach");
        Utils.checkNotNull(cardPayments, "cardPayments");
        this.ach = ach;
        this.cardPayments = cardPayments;
    }
    
    public CollectFunds() {
        this(Optional.empty(), Optional.empty());
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CollectFundsAch> ach() {
        return (Optional<CollectFundsAch>) ach;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CollectFundsCardPayments> cardPayments() {
        return (Optional<CollectFundsCardPayments>) cardPayments;
    }

    public static Builder builder() {
        return new Builder();
    }


    public CollectFunds withAch(CollectFundsAch ach) {
        Utils.checkNotNull(ach, "ach");
        this.ach = Optional.ofNullable(ach);
        return this;
    }


    public CollectFunds withAch(Optional<? extends CollectFundsAch> ach) {
        Utils.checkNotNull(ach, "ach");
        this.ach = ach;
        return this;
    }

    public CollectFunds withCardPayments(CollectFundsCardPayments cardPayments) {
        Utils.checkNotNull(cardPayments, "cardPayments");
        this.cardPayments = Optional.ofNullable(cardPayments);
        return this;
    }


    public CollectFunds withCardPayments(Optional<? extends CollectFundsCardPayments> cardPayments) {
        Utils.checkNotNull(cardPayments, "cardPayments");
        this.cardPayments = cardPayments;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CollectFunds other = (CollectFunds) o;
        return 
            Utils.enhancedDeepEquals(this.ach, other.ach) &&
            Utils.enhancedDeepEquals(this.cardPayments, other.cardPayments);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            ach, cardPayments);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CollectFunds.class,
                "ach", ach,
                "cardPayments", cardPayments);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<? extends CollectFundsAch> ach = Optional.empty();

        private Optional<? extends CollectFundsCardPayments> cardPayments = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder ach(CollectFundsAch ach) {
            Utils.checkNotNull(ach, "ach");
            this.ach = Optional.ofNullable(ach);
            return this;
        }

        public Builder ach(Optional<? extends CollectFundsAch> ach) {
            Utils.checkNotNull(ach, "ach");
            this.ach = ach;
            return this;
        }


        public Builder cardPayments(CollectFundsCardPayments cardPayments) {
            Utils.checkNotNull(cardPayments, "cardPayments");
            this.cardPayments = Optional.ofNullable(cardPayments);
            return this;
        }

        public Builder cardPayments(Optional<? extends CollectFundsCardPayments> cardPayments) {
            Utils.checkNotNull(cardPayments, "cardPayments");
            this.cardPayments = cardPayments;
            return this;
        }

        public CollectFunds build() {

            return new CollectFunds(
                ach, cardPayments);
        }

    }
}
