/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Deprecated;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.Optional;

/**
 * CardTransactionDetails
 * 
 * <p>Card-specific details about the transaction.
 */
public class CardTransactionDetails {
    /**
     * Status of a transaction within the card payment lifecycle.
     */
    @JsonProperty("status")
    private CardTransactionStatus status;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("failureCode")
    private Optional<? extends CardTransactionFailureCode> failureCode;

    /**
     * An optional override of the default card statement descriptor for a transfer. Accounts must be enabled by Moov to set this field.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("dynamicDescriptor")
    private Optional<String> dynamicDescriptor;

    /**
     * Specifies the nature and initiator of a transaction. 
     * 
     * <p>Crucial for recurring and merchant-initiated transactions as per card scheme rules. 
     * Omit for customer-initiated e-commerce transactions.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("transactionSource")
    private Optional<? extends TransactionSource> transactionSource;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("initiatedOn")
    private Optional<OffsetDateTime> initiatedOn;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("confirmedOn")
    private Optional<OffsetDateTime> confirmedOn;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("settledOn")
    private Optional<OffsetDateTime> settledOn;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("failedOn")
    private Optional<OffsetDateTime> failedOn;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("canceledOn")
    private Optional<OffsetDateTime> canceledOn;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("completedOn")
    private Optional<OffsetDateTime> completedOn;

    /**
     * The program assigned by the card network that determines the interchange rate for the transfer.
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("interchangeQualification")
    @Deprecated
    private Optional<String> interchangeQualification;

    /**
     * The program assigned by the card network that determines the interchange rate for the transfer.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("feeProgram")
    private Optional<String> feeProgram;

    /**
     * An alphanumeric code generated by the card network to demonstrate approval for the transaction.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("authorizationCode")
    private Optional<String> authorizationCode;

    @JsonCreator
    public CardTransactionDetails(
            @JsonProperty("status") CardTransactionStatus status,
            @JsonProperty("failureCode") Optional<? extends CardTransactionFailureCode> failureCode,
            @JsonProperty("dynamicDescriptor") Optional<String> dynamicDescriptor,
            @JsonProperty("transactionSource") Optional<? extends TransactionSource> transactionSource,
            @JsonProperty("initiatedOn") Optional<OffsetDateTime> initiatedOn,
            @JsonProperty("confirmedOn") Optional<OffsetDateTime> confirmedOn,
            @JsonProperty("settledOn") Optional<OffsetDateTime> settledOn,
            @JsonProperty("failedOn") Optional<OffsetDateTime> failedOn,
            @JsonProperty("canceledOn") Optional<OffsetDateTime> canceledOn,
            @JsonProperty("completedOn") Optional<OffsetDateTime> completedOn,
            @JsonProperty("interchangeQualification") Optional<String> interchangeQualification,
            @JsonProperty("feeProgram") Optional<String> feeProgram,
            @JsonProperty("authorizationCode") Optional<String> authorizationCode) {
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(failureCode, "failureCode");
        Utils.checkNotNull(dynamicDescriptor, "dynamicDescriptor");
        Utils.checkNotNull(transactionSource, "transactionSource");
        Utils.checkNotNull(initiatedOn, "initiatedOn");
        Utils.checkNotNull(confirmedOn, "confirmedOn");
        Utils.checkNotNull(settledOn, "settledOn");
        Utils.checkNotNull(failedOn, "failedOn");
        Utils.checkNotNull(canceledOn, "canceledOn");
        Utils.checkNotNull(completedOn, "completedOn");
        Utils.checkNotNull(interchangeQualification, "interchangeQualification");
        Utils.checkNotNull(feeProgram, "feeProgram");
        Utils.checkNotNull(authorizationCode, "authorizationCode");
        this.status = status;
        this.failureCode = failureCode;
        this.dynamicDescriptor = dynamicDescriptor;
        this.transactionSource = transactionSource;
        this.initiatedOn = initiatedOn;
        this.confirmedOn = confirmedOn;
        this.settledOn = settledOn;
        this.failedOn = failedOn;
        this.canceledOn = canceledOn;
        this.completedOn = completedOn;
        this.interchangeQualification = interchangeQualification;
        this.feeProgram = feeProgram;
        this.authorizationCode = authorizationCode;
    }
    
    public CardTransactionDetails(
            CardTransactionStatus status) {
        this(status, Optional.empty(), Optional.empty(),
            Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty());
    }

    /**
     * Status of a transaction within the card payment lifecycle.
     */
    @JsonIgnore
    public CardTransactionStatus status() {
        return status;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CardTransactionFailureCode> failureCode() {
        return (Optional<CardTransactionFailureCode>) failureCode;
    }

    /**
     * An optional override of the default card statement descriptor for a transfer. Accounts must be enabled by Moov to set this field.
     */
    @JsonIgnore
    public Optional<String> dynamicDescriptor() {
        return dynamicDescriptor;
    }

    /**
     * Specifies the nature and initiator of a transaction. 
     * 
     * <p>Crucial for recurring and merchant-initiated transactions as per card scheme rules. 
     * Omit for customer-initiated e-commerce transactions.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<TransactionSource> transactionSource() {
        return (Optional<TransactionSource>) transactionSource;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> initiatedOn() {
        return initiatedOn;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> confirmedOn() {
        return confirmedOn;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> settledOn() {
        return settledOn;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> failedOn() {
        return failedOn;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> canceledOn() {
        return canceledOn;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> completedOn() {
        return completedOn;
    }

    /**
     * The program assigned by the card network that determines the interchange rate for the transfer.
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public Optional<String> interchangeQualification() {
        return interchangeQualification;
    }

    /**
     * The program assigned by the card network that determines the interchange rate for the transfer.
     */
    @JsonIgnore
    public Optional<String> feeProgram() {
        return feeProgram;
    }

    /**
     * An alphanumeric code generated by the card network to demonstrate approval for the transaction.
     */
    @JsonIgnore
    public Optional<String> authorizationCode() {
        return authorizationCode;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Status of a transaction within the card payment lifecycle.
     */
    public CardTransactionDetails withStatus(CardTransactionStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public CardTransactionDetails withFailureCode(CardTransactionFailureCode failureCode) {
        Utils.checkNotNull(failureCode, "failureCode");
        this.failureCode = Optional.ofNullable(failureCode);
        return this;
    }


    public CardTransactionDetails withFailureCode(Optional<? extends CardTransactionFailureCode> failureCode) {
        Utils.checkNotNull(failureCode, "failureCode");
        this.failureCode = failureCode;
        return this;
    }

    /**
     * An optional override of the default card statement descriptor for a transfer. Accounts must be enabled by Moov to set this field.
     */
    public CardTransactionDetails withDynamicDescriptor(String dynamicDescriptor) {
        Utils.checkNotNull(dynamicDescriptor, "dynamicDescriptor");
        this.dynamicDescriptor = Optional.ofNullable(dynamicDescriptor);
        return this;
    }


    /**
     * An optional override of the default card statement descriptor for a transfer. Accounts must be enabled by Moov to set this field.
     */
    public CardTransactionDetails withDynamicDescriptor(Optional<String> dynamicDescriptor) {
        Utils.checkNotNull(dynamicDescriptor, "dynamicDescriptor");
        this.dynamicDescriptor = dynamicDescriptor;
        return this;
    }

    /**
     * Specifies the nature and initiator of a transaction. 
     * 
     * <p>Crucial for recurring and merchant-initiated transactions as per card scheme rules. 
     * Omit for customer-initiated e-commerce transactions.
     */
    public CardTransactionDetails withTransactionSource(TransactionSource transactionSource) {
        Utils.checkNotNull(transactionSource, "transactionSource");
        this.transactionSource = Optional.ofNullable(transactionSource);
        return this;
    }


    /**
     * Specifies the nature and initiator of a transaction. 
     * 
     * <p>Crucial for recurring and merchant-initiated transactions as per card scheme rules. 
     * Omit for customer-initiated e-commerce transactions.
     */
    public CardTransactionDetails withTransactionSource(Optional<? extends TransactionSource> transactionSource) {
        Utils.checkNotNull(transactionSource, "transactionSource");
        this.transactionSource = transactionSource;
        return this;
    }

    public CardTransactionDetails withInitiatedOn(OffsetDateTime initiatedOn) {
        Utils.checkNotNull(initiatedOn, "initiatedOn");
        this.initiatedOn = Optional.ofNullable(initiatedOn);
        return this;
    }


    public CardTransactionDetails withInitiatedOn(Optional<OffsetDateTime> initiatedOn) {
        Utils.checkNotNull(initiatedOn, "initiatedOn");
        this.initiatedOn = initiatedOn;
        return this;
    }

    public CardTransactionDetails withConfirmedOn(OffsetDateTime confirmedOn) {
        Utils.checkNotNull(confirmedOn, "confirmedOn");
        this.confirmedOn = Optional.ofNullable(confirmedOn);
        return this;
    }


    public CardTransactionDetails withConfirmedOn(Optional<OffsetDateTime> confirmedOn) {
        Utils.checkNotNull(confirmedOn, "confirmedOn");
        this.confirmedOn = confirmedOn;
        return this;
    }

    public CardTransactionDetails withSettledOn(OffsetDateTime settledOn) {
        Utils.checkNotNull(settledOn, "settledOn");
        this.settledOn = Optional.ofNullable(settledOn);
        return this;
    }


    public CardTransactionDetails withSettledOn(Optional<OffsetDateTime> settledOn) {
        Utils.checkNotNull(settledOn, "settledOn");
        this.settledOn = settledOn;
        return this;
    }

    public CardTransactionDetails withFailedOn(OffsetDateTime failedOn) {
        Utils.checkNotNull(failedOn, "failedOn");
        this.failedOn = Optional.ofNullable(failedOn);
        return this;
    }


    public CardTransactionDetails withFailedOn(Optional<OffsetDateTime> failedOn) {
        Utils.checkNotNull(failedOn, "failedOn");
        this.failedOn = failedOn;
        return this;
    }

    public CardTransactionDetails withCanceledOn(OffsetDateTime canceledOn) {
        Utils.checkNotNull(canceledOn, "canceledOn");
        this.canceledOn = Optional.ofNullable(canceledOn);
        return this;
    }


    public CardTransactionDetails withCanceledOn(Optional<OffsetDateTime> canceledOn) {
        Utils.checkNotNull(canceledOn, "canceledOn");
        this.canceledOn = canceledOn;
        return this;
    }

    public CardTransactionDetails withCompletedOn(OffsetDateTime completedOn) {
        Utils.checkNotNull(completedOn, "completedOn");
        this.completedOn = Optional.ofNullable(completedOn);
        return this;
    }


    public CardTransactionDetails withCompletedOn(Optional<OffsetDateTime> completedOn) {
        Utils.checkNotNull(completedOn, "completedOn");
        this.completedOn = completedOn;
        return this;
    }

    /**
     * The program assigned by the card network that determines the interchange rate for the transfer.
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public CardTransactionDetails withInterchangeQualification(String interchangeQualification) {
        Utils.checkNotNull(interchangeQualification, "interchangeQualification");
        this.interchangeQualification = Optional.ofNullable(interchangeQualification);
        return this;
    }


    /**
     * The program assigned by the card network that determines the interchange rate for the transfer.
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public CardTransactionDetails withInterchangeQualification(Optional<String> interchangeQualification) {
        Utils.checkNotNull(interchangeQualification, "interchangeQualification");
        this.interchangeQualification = interchangeQualification;
        return this;
    }

    /**
     * The program assigned by the card network that determines the interchange rate for the transfer.
     */
    public CardTransactionDetails withFeeProgram(String feeProgram) {
        Utils.checkNotNull(feeProgram, "feeProgram");
        this.feeProgram = Optional.ofNullable(feeProgram);
        return this;
    }


    /**
     * The program assigned by the card network that determines the interchange rate for the transfer.
     */
    public CardTransactionDetails withFeeProgram(Optional<String> feeProgram) {
        Utils.checkNotNull(feeProgram, "feeProgram");
        this.feeProgram = feeProgram;
        return this;
    }

    /**
     * An alphanumeric code generated by the card network to demonstrate approval for the transaction.
     */
    public CardTransactionDetails withAuthorizationCode(String authorizationCode) {
        Utils.checkNotNull(authorizationCode, "authorizationCode");
        this.authorizationCode = Optional.ofNullable(authorizationCode);
        return this;
    }


    /**
     * An alphanumeric code generated by the card network to demonstrate approval for the transaction.
     */
    public CardTransactionDetails withAuthorizationCode(Optional<String> authorizationCode) {
        Utils.checkNotNull(authorizationCode, "authorizationCode");
        this.authorizationCode = authorizationCode;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CardTransactionDetails other = (CardTransactionDetails) o;
        return 
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.failureCode, other.failureCode) &&
            Utils.enhancedDeepEquals(this.dynamicDescriptor, other.dynamicDescriptor) &&
            Utils.enhancedDeepEquals(this.transactionSource, other.transactionSource) &&
            Utils.enhancedDeepEquals(this.initiatedOn, other.initiatedOn) &&
            Utils.enhancedDeepEquals(this.confirmedOn, other.confirmedOn) &&
            Utils.enhancedDeepEquals(this.settledOn, other.settledOn) &&
            Utils.enhancedDeepEquals(this.failedOn, other.failedOn) &&
            Utils.enhancedDeepEquals(this.canceledOn, other.canceledOn) &&
            Utils.enhancedDeepEquals(this.completedOn, other.completedOn) &&
            Utils.enhancedDeepEquals(this.interchangeQualification, other.interchangeQualification) &&
            Utils.enhancedDeepEquals(this.feeProgram, other.feeProgram) &&
            Utils.enhancedDeepEquals(this.authorizationCode, other.authorizationCode);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            status, failureCode, dynamicDescriptor,
            transactionSource, initiatedOn, confirmedOn,
            settledOn, failedOn, canceledOn,
            completedOn, interchangeQualification, feeProgram,
            authorizationCode);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CardTransactionDetails.class,
                "status", status,
                "failureCode", failureCode,
                "dynamicDescriptor", dynamicDescriptor,
                "transactionSource", transactionSource,
                "initiatedOn", initiatedOn,
                "confirmedOn", confirmedOn,
                "settledOn", settledOn,
                "failedOn", failedOn,
                "canceledOn", canceledOn,
                "completedOn", completedOn,
                "interchangeQualification", interchangeQualification,
                "feeProgram", feeProgram,
                "authorizationCode", authorizationCode);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private CardTransactionStatus status;

        private Optional<? extends CardTransactionFailureCode> failureCode = Optional.empty();

        private Optional<String> dynamicDescriptor = Optional.empty();

        private Optional<? extends TransactionSource> transactionSource = Optional.empty();

        private Optional<OffsetDateTime> initiatedOn = Optional.empty();

        private Optional<OffsetDateTime> confirmedOn = Optional.empty();

        private Optional<OffsetDateTime> settledOn = Optional.empty();

        private Optional<OffsetDateTime> failedOn = Optional.empty();

        private Optional<OffsetDateTime> canceledOn = Optional.empty();

        private Optional<OffsetDateTime> completedOn = Optional.empty();

        @Deprecated
        private Optional<String> interchangeQualification = Optional.empty();

        private Optional<String> feeProgram = Optional.empty();

        private Optional<String> authorizationCode = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Status of a transaction within the card payment lifecycle.
         */
        public Builder status(CardTransactionStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        public Builder failureCode(CardTransactionFailureCode failureCode) {
            Utils.checkNotNull(failureCode, "failureCode");
            this.failureCode = Optional.ofNullable(failureCode);
            return this;
        }

        public Builder failureCode(Optional<? extends CardTransactionFailureCode> failureCode) {
            Utils.checkNotNull(failureCode, "failureCode");
            this.failureCode = failureCode;
            return this;
        }


        /**
         * An optional override of the default card statement descriptor for a transfer. Accounts must be enabled by Moov to set this field.
         */
        public Builder dynamicDescriptor(String dynamicDescriptor) {
            Utils.checkNotNull(dynamicDescriptor, "dynamicDescriptor");
            this.dynamicDescriptor = Optional.ofNullable(dynamicDescriptor);
            return this;
        }

        /**
         * An optional override of the default card statement descriptor for a transfer. Accounts must be enabled by Moov to set this field.
         */
        public Builder dynamicDescriptor(Optional<String> dynamicDescriptor) {
            Utils.checkNotNull(dynamicDescriptor, "dynamicDescriptor");
            this.dynamicDescriptor = dynamicDescriptor;
            return this;
        }


        /**
         * Specifies the nature and initiator of a transaction. 
         * 
         * <p>Crucial for recurring and merchant-initiated transactions as per card scheme rules. 
         * Omit for customer-initiated e-commerce transactions.
         */
        public Builder transactionSource(TransactionSource transactionSource) {
            Utils.checkNotNull(transactionSource, "transactionSource");
            this.transactionSource = Optional.ofNullable(transactionSource);
            return this;
        }

        /**
         * Specifies the nature and initiator of a transaction. 
         * 
         * <p>Crucial for recurring and merchant-initiated transactions as per card scheme rules. 
         * Omit for customer-initiated e-commerce transactions.
         */
        public Builder transactionSource(Optional<? extends TransactionSource> transactionSource) {
            Utils.checkNotNull(transactionSource, "transactionSource");
            this.transactionSource = transactionSource;
            return this;
        }


        public Builder initiatedOn(OffsetDateTime initiatedOn) {
            Utils.checkNotNull(initiatedOn, "initiatedOn");
            this.initiatedOn = Optional.ofNullable(initiatedOn);
            return this;
        }

        public Builder initiatedOn(Optional<OffsetDateTime> initiatedOn) {
            Utils.checkNotNull(initiatedOn, "initiatedOn");
            this.initiatedOn = initiatedOn;
            return this;
        }


        public Builder confirmedOn(OffsetDateTime confirmedOn) {
            Utils.checkNotNull(confirmedOn, "confirmedOn");
            this.confirmedOn = Optional.ofNullable(confirmedOn);
            return this;
        }

        public Builder confirmedOn(Optional<OffsetDateTime> confirmedOn) {
            Utils.checkNotNull(confirmedOn, "confirmedOn");
            this.confirmedOn = confirmedOn;
            return this;
        }


        public Builder settledOn(OffsetDateTime settledOn) {
            Utils.checkNotNull(settledOn, "settledOn");
            this.settledOn = Optional.ofNullable(settledOn);
            return this;
        }

        public Builder settledOn(Optional<OffsetDateTime> settledOn) {
            Utils.checkNotNull(settledOn, "settledOn");
            this.settledOn = settledOn;
            return this;
        }


        public Builder failedOn(OffsetDateTime failedOn) {
            Utils.checkNotNull(failedOn, "failedOn");
            this.failedOn = Optional.ofNullable(failedOn);
            return this;
        }

        public Builder failedOn(Optional<OffsetDateTime> failedOn) {
            Utils.checkNotNull(failedOn, "failedOn");
            this.failedOn = failedOn;
            return this;
        }


        public Builder canceledOn(OffsetDateTime canceledOn) {
            Utils.checkNotNull(canceledOn, "canceledOn");
            this.canceledOn = Optional.ofNullable(canceledOn);
            return this;
        }

        public Builder canceledOn(Optional<OffsetDateTime> canceledOn) {
            Utils.checkNotNull(canceledOn, "canceledOn");
            this.canceledOn = canceledOn;
            return this;
        }


        public Builder completedOn(OffsetDateTime completedOn) {
            Utils.checkNotNull(completedOn, "completedOn");
            this.completedOn = Optional.ofNullable(completedOn);
            return this;
        }

        public Builder completedOn(Optional<OffsetDateTime> completedOn) {
            Utils.checkNotNull(completedOn, "completedOn");
            this.completedOn = completedOn;
            return this;
        }


        /**
         * The program assigned by the card network that determines the interchange rate for the transfer.
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder interchangeQualification(String interchangeQualification) {
            Utils.checkNotNull(interchangeQualification, "interchangeQualification");
            this.interchangeQualification = Optional.ofNullable(interchangeQualification);
            return this;
        }

        /**
         * The program assigned by the card network that determines the interchange rate for the transfer.
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder interchangeQualification(Optional<String> interchangeQualification) {
            Utils.checkNotNull(interchangeQualification, "interchangeQualification");
            this.interchangeQualification = interchangeQualification;
            return this;
        }


        /**
         * The program assigned by the card network that determines the interchange rate for the transfer.
         */
        public Builder feeProgram(String feeProgram) {
            Utils.checkNotNull(feeProgram, "feeProgram");
            this.feeProgram = Optional.ofNullable(feeProgram);
            return this;
        }

        /**
         * The program assigned by the card network that determines the interchange rate for the transfer.
         */
        public Builder feeProgram(Optional<String> feeProgram) {
            Utils.checkNotNull(feeProgram, "feeProgram");
            this.feeProgram = feeProgram;
            return this;
        }


        /**
         * An alphanumeric code generated by the card network to demonstrate approval for the transaction.
         */
        public Builder authorizationCode(String authorizationCode) {
            Utils.checkNotNull(authorizationCode, "authorizationCode");
            this.authorizationCode = Optional.ofNullable(authorizationCode);
            return this;
        }

        /**
         * An alphanumeric code generated by the card network to demonstrate approval for the transaction.
         */
        public Builder authorizationCode(Optional<String> authorizationCode) {
            Utils.checkNotNull(authorizationCode, "authorizationCode");
            this.authorizationCode = authorizationCode;
            return this;
        }

        public CardTransactionDetails build() {

            return new CardTransactionDetails(
                status, failureCode, dynamicDescriptor,
                transactionSource, initiatedOn, confirmedOn,
                settledOn, failedOn, canceledOn,
                completedOn, interchangeQualification, feeProgram,
                authorizationCode);
        }

    }
}
