/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;

/**
 * CardPresentPaymentPaymentMethod
 * 
 * <p>A card used at point of sale terminal for a card present transaction as contained within a payment method.
 */
public class CardPresentPaymentPaymentMethod implements PaymentMethod {
    /**
     * ID of the payment method.
     */
    @JsonProperty("paymentMethodID")
    private String paymentMethodID;


    @JsonProperty("paymentMethodType")
    private CardPresentPaymentPaymentMethodPaymentMethodType paymentMethodType;

    /**
     * Describes payment card details captured with tap or in-person payment.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("terminalCard")
    private Optional<? extends TerminalCard> terminalCard;

    @JsonCreator
    public CardPresentPaymentPaymentMethod(
            @JsonProperty("paymentMethodID") String paymentMethodID,
            @JsonProperty("paymentMethodType") CardPresentPaymentPaymentMethodPaymentMethodType paymentMethodType,
            @JsonProperty("terminalCard") Optional<? extends TerminalCard> terminalCard) {
        Utils.checkNotNull(paymentMethodID, "paymentMethodID");
        Utils.checkNotNull(paymentMethodType, "paymentMethodType");
        Utils.checkNotNull(terminalCard, "terminalCard");
        this.paymentMethodID = paymentMethodID;
        this.paymentMethodType = paymentMethodType;
        this.terminalCard = terminalCard;
    }
    
    public CardPresentPaymentPaymentMethod(
            String paymentMethodID,
            CardPresentPaymentPaymentMethodPaymentMethodType paymentMethodType) {
        this(paymentMethodID, paymentMethodType, Optional.empty());
    }

    /**
     * ID of the payment method.
     */
    @JsonIgnore
    public String paymentMethodID() {
        return paymentMethodID;
    }

    @JsonIgnore
    @Override
    public String paymentMethodType() {
        return Utils.discriminatorToString(paymentMethodType);
    }

    /**
     * Describes payment card details captured with tap or in-person payment.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<TerminalCard> terminalCard() {
        return (Optional<TerminalCard>) terminalCard;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * ID of the payment method.
     */
    public CardPresentPaymentPaymentMethod withPaymentMethodID(String paymentMethodID) {
        Utils.checkNotNull(paymentMethodID, "paymentMethodID");
        this.paymentMethodID = paymentMethodID;
        return this;
    }

    public CardPresentPaymentPaymentMethod withPaymentMethodType(CardPresentPaymentPaymentMethodPaymentMethodType paymentMethodType) {
        Utils.checkNotNull(paymentMethodType, "paymentMethodType");
        this.paymentMethodType = paymentMethodType;
        return this;
    }

    /**
     * Describes payment card details captured with tap or in-person payment.
     */
    public CardPresentPaymentPaymentMethod withTerminalCard(TerminalCard terminalCard) {
        Utils.checkNotNull(terminalCard, "terminalCard");
        this.terminalCard = Optional.ofNullable(terminalCard);
        return this;
    }


    /**
     * Describes payment card details captured with tap or in-person payment.
     */
    public CardPresentPaymentPaymentMethod withTerminalCard(Optional<? extends TerminalCard> terminalCard) {
        Utils.checkNotNull(terminalCard, "terminalCard");
        this.terminalCard = terminalCard;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CardPresentPaymentPaymentMethod other = (CardPresentPaymentPaymentMethod) o;
        return 
            Utils.enhancedDeepEquals(this.paymentMethodID, other.paymentMethodID) &&
            Utils.enhancedDeepEquals(this.paymentMethodType, other.paymentMethodType) &&
            Utils.enhancedDeepEquals(this.terminalCard, other.terminalCard);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            paymentMethodID, paymentMethodType, terminalCard);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CardPresentPaymentPaymentMethod.class,
                "paymentMethodID", paymentMethodID,
                "paymentMethodType", paymentMethodType,
                "terminalCard", terminalCard);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String paymentMethodID;

        private CardPresentPaymentPaymentMethodPaymentMethodType paymentMethodType;

        private Optional<? extends TerminalCard> terminalCard = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * ID of the payment method.
         */
        public Builder paymentMethodID(String paymentMethodID) {
            Utils.checkNotNull(paymentMethodID, "paymentMethodID");
            this.paymentMethodID = paymentMethodID;
            return this;
        }


        public Builder paymentMethodType(CardPresentPaymentPaymentMethodPaymentMethodType paymentMethodType) {
            Utils.checkNotNull(paymentMethodType, "paymentMethodType");
            this.paymentMethodType = paymentMethodType;
            return this;
        }


        /**
         * Describes payment card details captured with tap or in-person payment.
         */
        public Builder terminalCard(TerminalCard terminalCard) {
            Utils.checkNotNull(terminalCard, "terminalCard");
            this.terminalCard = Optional.ofNullable(terminalCard);
            return this;
        }

        /**
         * Describes payment card details captured with tap or in-person payment.
         */
        public Builder terminalCard(Optional<? extends TerminalCard> terminalCard) {
            Utils.checkNotNull(terminalCard, "terminalCard");
            this.terminalCard = terminalCard;
            return this;
        }

        public CardPresentPaymentPaymentMethod build() {

            return new CardPresentPaymentPaymentMethod(
                paymentMethodID, paymentMethodType, terminalCard);
        }

    }
}
